/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs;

import java.util.Arrays;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.lttng2.ui.Activator;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.INewConnectionDialog;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.ITraceControlComponent;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewConnectionDialog
extends Dialog
implements INewConnectionDialog {
    public static final String TARGET_NEW_CONNECTION_ICON_FILE = "icons/elcl16/target_add.gif";
    private Composite fDialogComposite = null;
    private Group fComboGroup = null;
    private Group fTextGroup = null;
    private CCombo fExistingHostsCombo = null;
    private Button fButton = null;
    private Text fConnectionNameText = null;
    private Text fHostNameText = null;
    private ITraceControlComponent fParent;
    private String fConnectionName = null;
    private String fHostName = null;
    private IHost[] fExistingHosts = new IHost[0];

    public NewConnectionDialog(Shell shell) {
        super(shell);
        this.setShellStyle(16);
    }

    @Override
    public String getConnectionName() {
        return this.fConnectionName;
    }

    @Override
    public String getHostName() {
        return this.fHostName;
    }

    @Override
    public void setTraceControlParent(ITraceControlComponent parent) {
        this.fParent = parent;
    }

    @Override
    public void setHosts(IHost[] hosts) {
        if (hosts != null) {
            this.fExistingHosts = Arrays.copyOf(hosts, hosts.length);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TraceControl_NewDialogTitle);
        newShell.setImage(Activator.getDefault().loadIcon(TARGET_NEW_CONNECTION_ICON_FILE));
    }

    protected Control createDialogArea(Composite parent) {
        this.fDialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        this.fDialogComposite.setLayout((Layout)layout);
        this.fDialogComposite.setLayoutData((Object)new GridData(1808));
        this.fComboGroup = new Group(this.fDialogComposite, 32);
        this.fComboGroup.setText(Messages.TraceControl_NewNodeExistingConnectionGroupName);
        layout = new GridLayout(2, true);
        this.fComboGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        this.fComboGroup.setLayoutData((Object)data);
        this.fExistingHostsCombo = new CCombo((Composite)this.fComboGroup, 8);
        this.fExistingHostsCombo.setToolTipText(Messages.TraceControl_NewNodeComboToolTip);
        this.fExistingHostsCombo.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        String[] items = new String[this.fExistingHosts.length];
        int i = 0;
        while (i < items.length) {
            items[i] = String.valueOf(String.valueOf(this.fExistingHosts[i].getAliasName()) + " - " + this.fExistingHosts[i].getHostName());
            ++i;
        }
        this.fExistingHostsCombo.setItems(items);
        this.fExistingHostsCombo.setEnabled(this.fExistingHosts.length > 0);
        this.fTextGroup = new Group(this.fDialogComposite, 32);
        layout = new GridLayout(3, true);
        this.fTextGroup.setLayout((Layout)layout);
        data = new GridData(768);
        this.fTextGroup.setLayoutData((Object)data);
        this.fButton = new Button((Composite)this.fTextGroup, 32);
        this.fButton.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        this.fButton.setText(Messages.TraceControl_NewNodeEditButtonName);
        this.fButton.setEnabled(this.fExistingHosts.length > 0);
        Label connectionNameLabel = new Label((Composite)this.fTextGroup, 131072);
        connectionNameLabel.setText(Messages.TraceControl_NewNodeConnectionNameLabel);
        this.fConnectionNameText = new Text((Composite)this.fTextGroup, 0);
        this.fConnectionNameText.setToolTipText(Messages.TraceControl_NewNodeConnectionNameTooltip);
        this.fConnectionNameText.setEnabled(this.fExistingHosts.length == 0);
        Label hostNameLabel = new Label((Composite)this.fTextGroup, 131072);
        hostNameLabel.setText(Messages.TraceControl_NewNodeHostNameLabel);
        this.fHostNameText = new Text((Composite)this.fTextGroup, 0);
        this.fHostNameText.setToolTipText(Messages.TraceControl_NewNodeHostNameTooltip);
        this.fHostNameText.setEnabled(this.fExistingHosts.length == 0);
        this.fButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (NewConnectionDialog.this.fButton.getSelection()) {
                    NewConnectionDialog.this.fExistingHostsCombo.deselectAll();
                    NewConnectionDialog.this.fExistingHostsCombo.setEnabled(false);
                    NewConnectionDialog.this.fConnectionNameText.setEnabled(true);
                    NewConnectionDialog.this.fHostNameText.setEnabled(true);
                } else {
                    NewConnectionDialog.this.fExistingHostsCombo.setEnabled(true);
                    NewConnectionDialog.this.fConnectionNameText.setEnabled(false);
                    NewConnectionDialog.this.fHostNameText.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fExistingHostsCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = NewConnectionDialog.this.fExistingHostsCombo.getSelectionIndex();
                NewConnectionDialog.this.fConnectionNameText.setText(NewConnectionDialog.this.fExistingHosts[index].getAliasName());
                NewConnectionDialog.this.fHostNameText.setText(NewConnectionDialog.this.fExistingHosts[index].getHostName());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        data = new GridData(768);
        this.fHostNameText.setText("666.666.666.666");
        Point minSize = this.fHostNameText.computeSize(-1, -1, true);
        data.widthHint = minSize.x + 5;
        data.horizontalSpan = 2;
        this.fConnectionNameText.setLayoutData((Object)data);
        this.fHostNameText.setLayoutData((Object)data);
        this.fHostNameText.setText("");
        return this.fDialogComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "&Cancel", true);
        this.createButton(parent, 0, "&Ok", true);
    }

    protected void okPressed() {
        this.fConnectionName = this.fConnectionNameText.getText();
        this.fHostName = this.fHostNameText.getText();
        if (!"".equals(this.fHostName)) {
            if ("".equals(this.fConnectionName)) {
                this.fConnectionName = this.fHostName;
            }
            if (this.fParent.containsChild(this.fConnectionName)) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_NewDialogTitle, (String)(String.valueOf(Messages.TraceControl_AlreadyExistsError) + " (" + this.fConnectionName + ")"));
                return;
            }
        } else {
            return;
        }
        super.okPressed();
    }
}

