/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.core.event;

import org.eclipse.linuxtools.internal.lttng.core.event.LttngTimestamp;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;

public class LttngLocation
implements ITmfLocation<LttngTimestamp>,
Comparable<LttngLocation>,
Cloneable {
    private static final long DEFAULT_CURR_TIME = 0L;
    private boolean isLastOperationParse = false;
    private boolean isLastOperationReadNext = false;
    private boolean isLastOperationSeek = false;
    private LttngTimestamp operationTime = null;

    public LttngLocation() {
        this(0L);
    }

    public LttngLocation(long newCurrentTimestampValue) {
        this.isLastOperationParse = false;
        this.isLastOperationReadNext = false;
        this.isLastOperationSeek = false;
        this.operationTime = new LttngTimestamp(newCurrentTimestampValue);
    }

    public LttngLocation(LttngTimestamp newCurrentTimestamp) {
        this.isLastOperationParse = false;
        this.isLastOperationReadNext = false;
        this.isLastOperationSeek = false;
        this.operationTime = new LttngTimestamp((ITmfTimestamp)newCurrentTimestamp);
    }

    public LttngLocation(LttngLocation oldLocation) {
        this.isLastOperationParse = oldLocation.isLastOperationParse;
        this.isLastOperationReadNext = oldLocation.isLastOperationReadNext;
        this.isLastOperationSeek = oldLocation.isLastOperationSeek;
        this.operationTime = oldLocation.operationTime;
    }

    public LttngLocation clone() {
        LttngLocation newLocation = new LttngLocation(this);
        newLocation.operationTime = new LttngTimestamp((ITmfTimestamp)this.operationTime);
        return newLocation;
    }

    public LttngTimestamp getOperationTime() {
        return this.operationTime;
    }

    public long getOperationTimeValue() {
        return this.operationTime.getValue();
    }

    public void setOperationTime(LttngTimestamp newOperationTime) {
        this.operationTime.setValue(newOperationTime.getValue());
    }

    public void setOperationTime(Long newOperationTimeValue) {
        this.operationTime.setValue(newOperationTimeValue);
    }

    public void setLastOperationParse() {
        this.isLastOperationParse = true;
        this.isLastOperationReadNext = false;
        this.isLastOperationSeek = false;
    }

    public boolean isLastOperationParse() {
        return this.isLastOperationParse;
    }

    public void setLastOperationReadNext() {
        this.isLastOperationParse = false;
        this.isLastOperationReadNext = true;
        this.isLastOperationSeek = false;
    }

    public boolean isLastOperationReadNext() {
        return this.isLastOperationReadNext;
    }

    public void setLastOperationSeek() {
        this.isLastOperationParse = false;
        this.isLastOperationReadNext = false;
        this.isLastOperationSeek = true;
    }

    public boolean isLastOperationSeek() {
        return this.isLastOperationSeek;
    }

    public void resetLocationState() {
        this.isLastOperationParse = false;
        this.isLastOperationReadNext = false;
        this.isLastOperationSeek = false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.isLastOperationParse ? 1231 : 1237);
        result = 31 * result + (this.isLastOperationReadNext ? 1231 : 1237);
        result = 31 * result + (this.isLastOperationSeek ? 1231 : 1237);
        result = 31 * result + (this.operationTime == null ? 0 : this.operationTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LttngLocation)) {
            return false;
        }
        LttngLocation o = (LttngLocation)obj;
        return this.operationTime.equals((Object)o.operationTime) && this.isLastOperationParse == o.isLastOperationParse && this.isLastOperationReadNext == o.isLastOperationReadNext && this.isLastOperationSeek == o.isLastOperationSeek;
    }

    public String toString() {
        return this.operationTime.toString();
    }

    public void setLocation(LttngTimestamp location) {
        this.operationTime = location;
    }

    public LttngTimestamp getLocation() {
        return new LttngTimestamp((ITmfTimestamp)this.operationTime);
    }

    @Override
    public int compareTo(LttngLocation o) {
        return this.operationTime.compareTo((ITmfTimestamp)o.operationTime);
    }
}

