/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.view.fields;

import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTTreeViewer;
import org.eclipse.linuxtools.internal.gprof.parser.GmonDecoder;
import org.eclipse.linuxtools.internal.gprof.view.GmonView;
import org.eclipse.linuxtools.internal.gprof.view.fields.SampleProfField;
import org.eclipse.linuxtools.internal.gprof.view.histogram.TreeElement;
import org.eclipse.swt.graphics.Color;

public class SamplePerCallField
extends SampleProfField {
    public SamplePerCallField(AbstractSTTreeViewer viewer) {
        super(viewer);
    }

    @Override
    public int compare(Object obj1, Object obj2) {
        TreeElement e1 = (TreeElement)obj1;
        TreeElement e2 = (TreeElement)obj2;
        int c1 = e1.getCalls();
        int c2 = e2.getCalls();
        if (!(c1 != 0 && c1 != -1 || c2 != 0 && c2 != -1)) {
            return 0;
        }
        if (c1 == 0 || c1 == -1) {
            return -1;
        }
        if (c2 == 0 || c2 == -1) {
            return 1;
        }
        float f1 = (float)e1.getSamples() / (float)c1;
        float f2 = (float)e2.getSamples() / (float)c2;
        return Float.compare(f1, f2);
    }

    @Override
    public String getColumnHeaderText() {
        String prefix = "";
        Object o = this.viewer.getInput();
        if (o instanceof GmonDecoder) {
            GmonDecoder decoder = (GmonDecoder)o;
            if (decoder.isICache()) {
                prefix = "ICACHE ";
            } else if (decoder.isDCache()) {
                prefix = "DCACHE ";
            }
        }
        return String.valueOf(prefix) + "Time/Call";
    }

    @Override
    public String getColumnHeaderTooltip() {
        Object o = this.viewer.getInput();
        if (o instanceof GmonDecoder) {
            GmonDecoder decoder = (GmonDecoder)o;
            if (decoder.isICache()) {
                return "Time/Call spent by function accessing instruction cache";
            }
            if (decoder.isDCache()) {
                return "Time/Call spent by function accessing data cache";
            }
            return "Time/Call spent by function";
        }
        return null;
    }

    @Override
    public String getValue(Object obj) {
        TreeElement e = (TreeElement)obj;
        int i = e.getSamples();
        int j = e.getCalls();
        if (i == -1 || j <= 0) {
            return "";
        }
        float k = (float)i / (float)j;
        double prof_rate = this.getProfRate();
        if (prof_rate != 0.0) {
            return SamplePerCallField.getValue(k, prof_rate);
        }
        return "";
    }

    @Override
    public Color getBackground(Object element) {
        return GmonView.getBackground(element);
    }

    @Override
    public Number getNumber(Object obj) {
        TreeElement e = (TreeElement)obj;
        int i = e.getSamples();
        int j = e.getCalls();
        if (i == -1 || j <= 0) {
            return 0L;
        }
        float k = (float)i / (float)j;
        double prof_rate = this.getProfRate();
        if (prof_rate != 0.0) {
            return (double)k / prof_rate;
        }
        return 0L;
    }
}

