/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts;

import org.eclipse.linuxtools.dataviewers.piechart.PieChart;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.AbstractChartWithoutAxisBuilder;
import org.eclipse.swt.widgets.Composite;

public class PieChartBuilder
extends AbstractChartWithoutAxisBuilder {
    public static final String ID = "org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.piechartbuilder";

    public PieChartBuilder(Composite parent, int style, String title, IAdapter adapter) {
        super(adapter, parent, style, title);
    }

    protected void createChart() {
        this.chart = new PieChart((Composite)this, this.getStyle());
    }

    protected void buildXSeries() {
        Object[][] data = this.adapter.getData();
        if (data == null || data.length == 0 || data[0].length == 0) {
            return;
        }
        int start = 0;
        int len = Math.min(this.maxItems, data.length);
        if (this.maxItems < data.length) {
            start = data.length - this.maxItems;
        }
        double[][] values = new double[len][data[0].length - 1];
        String[] labels = new String[len];
        int i = 0;
        while (i < labels.length) {
            if (data[i].length < 2) {
                return;
            }
            labels[i] = data[start + i][0].toString();
            int j = 1;
            while (j < data[start + i].length) {
                values[i][j - 1] = this.getDoubleValue(data[start + i][j]);
                ++j;
            }
            ++i;
        }
        ((PieChart)this.chart).addPieChartSeries(labels, values);
        this.chart.redraw();
    }

    public void updateDataSet() {
        this.buildXSeries();
    }
}

