/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.jni;

import java.util.HashMap;
import org.eclipse.linuxtools.internal.lttng.jni.common.JniTime;
import org.eclipse.linuxtools.internal.lttng.jni.common.Jni_C_Pointer;
import org.eclipse.linuxtools.internal.lttng.jni.common.Jni_C_Pointer_And_Library_Id;
import org.eclipse.linuxtools.internal.lttng.jni.exception.JniException;
import org.eclipse.linuxtools.internal.lttng.jni.exception.JniNoSuchEventException;
import org.eclipse.linuxtools.internal.lttng.jni.exception.JniTracefileException;
import org.eclipse.linuxtools.internal.lttng.jni.exception.JniTracefileWithoutEventException;
import org.eclipse.linuxtools.lttng.jni.JniEvent;
import org.eclipse.linuxtools.lttng.jni.JniMarker;
import org.eclipse.linuxtools.lttng.jni.JniTrace;
import org.eclipse.linuxtools.lttng.jni.Jni_C_Common;

public abstract class JniTracefile
extends Jni_C_Common {
    private Jni_C_Pointer_And_Library_Id thisTracefilePtr = new Jni_C_Pointer_And_Library_Id();
    private JniTrace parentTrace = null;
    private boolean isCpuOnline = false;
    private String tracefilePath = "";
    private String tracefileName = "";
    private long cpuNumber = 0L;
    private long tid = 0L;
    private long pgid = 0L;
    private long creation = 0L;
    private Jni_C_Pointer tracePtr = null;
    private Jni_C_Pointer markerDataPtr = null;
    private int CFileDescriptor = 0;
    private long fileSize = 0L;
    private long blocksNumber = 0L;
    private boolean isBytesOrderReversed = false;
    private boolean isFloatWordOrdered = false;
    private long alignement = 0L;
    private long bufferHeaderSize = 0L;
    private int bitsOfCurrentTimestampCounter = 0;
    private int bitsOfEvent = 0;
    private long currentTimestampCounterMask = 0L;
    private long currentTimestampCounterMaskNextBit = 0L;
    private long eventsLost = 0L;
    private long subBufferCorrupt = 0L;
    private JniEvent currentEvent = null;
    private Jni_C_Pointer bufferPtr = null;
    private long bufferSize = 0L;
    private HashMap<Integer, JniMarker> tracefileMarkersMap = null;

    protected native boolean ltt_getIsCpuOnline(int var1, long var2);

    protected native String ltt_getTracefilepath(int var1, long var2);

    protected native String ltt_getTracefilename(int var1, long var2);

    protected native long ltt_getCpuNumber(int var1, long var2);

    protected native long ltt_getTid(int var1, long var2);

    protected native long ltt_getPgid(int var1, long var2);

    protected native long ltt_getCreation(int var1, long var2);

    protected native long ltt_getTracePtr(int var1, long var2);

    protected native long ltt_getMarkerDataPtr(int var1, long var2);

    protected native int ltt_getCFileDescriptor(int var1, long var2);

    protected native long ltt_getFileSize(int var1, long var2);

    protected native long ltt_getBlockNumber(int var1, long var2);

    protected native boolean ltt_getIsBytesOrderReversed(int var1, long var2);

    protected native boolean ltt_getIsFloatWordOrdered(int var1, long var2);

    protected native long ltt_getAlignement(int var1, long var2);

    protected native long ltt_getBufferHeaderSize(int var1, long var2);

    protected native int ltt_getBitsOfCurrentTimestampCounter(int var1, long var2);

    protected native int ltt_getBitsOfEvent(int var1, long var2);

    protected native long ltt_getCurrentTimestampCounterMask(int var1, long var2);

    protected native long ltt_getCurrentTimestampCounterMaskNextBit(int var1, long var2);

    protected native long ltt_getEventsLost(int var1, long var2);

    protected native long ltt_getSubBufferCorrupt(int var1, long var2);

    protected native long ltt_getEventPtr(int var1, long var2);

    protected native long ltt_getBufferPtr(int var1, long var2);

    protected native long ltt_getBufferSize(int var1, long var2);

    protected native void ltt_feedAllMarkers(int var1, long var2);

    protected native void ltt_printTracefile(int var1, long var2);

    protected JniTracefile() {
    }

    public JniTracefile(JniTracefile oldTracefile) {
        this.thisTracefilePtr = oldTracefile.thisTracefilePtr;
        this.parentTrace = oldTracefile.parentTrace;
        this.tracefileMarkersMap = oldTracefile.tracefileMarkersMap;
        this.isCpuOnline = oldTracefile.isCpuOnline;
        this.tracefilePath = oldTracefile.tracefilePath;
        this.tracefileName = oldTracefile.tracefileName;
        this.cpuNumber = oldTracefile.cpuNumber;
        this.tid = oldTracefile.tid;
        this.pgid = oldTracefile.pgid;
        this.creation = oldTracefile.creation;
        this.tracePtr = oldTracefile.tracePtr;
        this.markerDataPtr = oldTracefile.markerDataPtr;
        this.CFileDescriptor = oldTracefile.CFileDescriptor;
        this.fileSize = oldTracefile.fileSize;
        this.blocksNumber = oldTracefile.blocksNumber;
        this.isBytesOrderReversed = oldTracefile.isBytesOrderReversed;
        this.isFloatWordOrdered = oldTracefile.isFloatWordOrdered;
        this.alignement = oldTracefile.alignement;
        this.bufferHeaderSize = oldTracefile.bufferHeaderSize;
        this.bitsOfCurrentTimestampCounter = oldTracefile.bitsOfCurrentTimestampCounter;
        this.bitsOfEvent = oldTracefile.bitsOfEvent;
        this.currentTimestampCounterMask = oldTracefile.currentTimestampCounterMask;
        this.currentTimestampCounterMaskNextBit = oldTracefile.currentTimestampCounterMaskNextBit;
        this.eventsLost = oldTracefile.eventsLost;
        this.subBufferCorrupt = oldTracefile.subBufferCorrupt;
        this.currentEvent = oldTracefile.currentEvent;
        this.bufferPtr = oldTracefile.bufferPtr;
        this.bufferSize = oldTracefile.bufferSize;
    }

    public JniTracefile(Jni_C_Pointer_And_Library_Id newPtr, JniTrace newParentTrace) throws JniException {
        this.thisTracefilePtr = newPtr;
        this.parentTrace = newParentTrace;
        this.tracefileMarkersMap = new HashMap();
        try {
            this.populateTracefileInformation();
        }
        catch (JniNoSuchEventException jniNoSuchEventException) {
            throw new JniTracefileWithoutEventException("JniEvent constructor reported that no event of this type are usable. (Jni_Tracefile)");
        }
    }

    public int readNextEvent() {
        return this.currentEvent.readNextEvent();
    }

    public int seekToTime(JniTime seekTime) {
        return this.currentEvent.seekToTime(seekTime);
    }

    private void populateTracefileInformation() throws JniException {
        if (this.thisTracefilePtr.getPointer() == 0L) {
            throw new JniTracefileException("Pointer is NULL, trace closed? (populateTracefileInformation)");
        }
        this.isCpuOnline = this.ltt_getIsCpuOnline(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.tracefilePath = this.ltt_getTracefilepath(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.tracefileName = this.ltt_getTracefilename(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.cpuNumber = this.ltt_getCpuNumber(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.tid = this.ltt_getTid(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.pgid = this.ltt_getPgid(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.creation = this.ltt_getCreation(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.tracePtr = new Jni_C_Pointer(this.ltt_getTracePtr(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer()));
        this.markerDataPtr = new Jni_C_Pointer(this.ltt_getMarkerDataPtr(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer()));
        this.CFileDescriptor = this.ltt_getCFileDescriptor(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.fileSize = this.ltt_getFileSize(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.blocksNumber = this.ltt_getBlockNumber(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.isBytesOrderReversed = this.ltt_getIsBytesOrderReversed(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.isFloatWordOrdered = this.ltt_getIsFloatWordOrdered(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.alignement = this.ltt_getAlignement(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.bufferHeaderSize = this.ltt_getBufferHeaderSize(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.bitsOfCurrentTimestampCounter = this.ltt_getBitsOfCurrentTimestampCounter(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.bitsOfEvent = this.ltt_getBitsOfEvent(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.currentTimestampCounterMask = this.ltt_getCurrentTimestampCounterMask(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.currentTimestampCounterMaskNextBit = this.ltt_getCurrentTimestampCounterMaskNextBit(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.eventsLost = this.ltt_getEventsLost(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.subBufferCorrupt = this.ltt_getSubBufferCorrupt(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.bufferPtr = new Jni_C_Pointer(this.ltt_getBufferPtr(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer()));
        this.bufferSize = this.ltt_getBufferSize(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        this.ltt_feedAllMarkers(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
        Jni_C_Pointer_And_Library_Id tmpEventPointer = new Jni_C_Pointer_And_Library_Id(this.thisTracefilePtr.getLibraryId(), this.ltt_getEventPtr(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer()));
        this.currentEvent = this.allocateNewJniEvent(tmpEventPointer, this.tracefileMarkersMap, this);
    }

    private void addMarkersFromC(int markerId, long markerInfoPtr) {
        try {
            JniMarker newMarker = this.allocateNewJniMarker(new Jni_C_Pointer_And_Library_Id(this.thisTracefilePtr.getLibraryId(), markerInfoPtr));
            this.tracefileMarkersMap.put(markerId, newMarker);
        }
        catch (Exception e) {
            this.printlnC(this.thisTracefilePtr.getLibraryId(), "Failed to add marker to tracefileMarkersMap!(addMarkersFromC)\n\tException raised : " + e.toString());
        }
    }

    public boolean getIsCpuOnline() {
        return this.isCpuOnline;
    }

    public String getTracefilePath() {
        return this.tracefilePath;
    }

    public String getTracefileName() {
        return this.tracefileName;
    }

    public long getCpuNumber() {
        return this.cpuNumber;
    }

    public long getTid() {
        return this.tid;
    }

    public long getPgid() {
        return this.pgid;
    }

    public long getCreation() {
        return this.creation;
    }

    public Jni_C_Pointer getTracePtr() {
        return this.tracePtr;
    }

    public Jni_C_Pointer getMarkerDataPtr() {
        return this.markerDataPtr;
    }

    public int getCFileDescriptor() {
        return this.CFileDescriptor;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getBlocksNumber() {
        return this.blocksNumber;
    }

    public boolean getIsBytesOrderReversed() {
        return this.isBytesOrderReversed;
    }

    public boolean getIsFloatWordOrdered() {
        return this.isFloatWordOrdered;
    }

    public long getAlignement() {
        return this.alignement;
    }

    public long getBufferHeaderSize() {
        return this.bufferHeaderSize;
    }

    public int getBitsOfCurrentTimestampCounter() {
        return this.bitsOfCurrentTimestampCounter;
    }

    public int getBitsOfEvent() {
        return this.bitsOfEvent;
    }

    public long getCurrentTimestampCounterMask() {
        return this.currentTimestampCounterMask;
    }

    public long getCurrentTimestampCounterMaskNextBit() {
        return this.currentTimestampCounterMaskNextBit;
    }

    public long getEventsLost() {
        return this.eventsLost;
    }

    public long getSubBufferCorrupt() {
        return this.subBufferCorrupt;
    }

    public JniEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public Jni_C_Pointer getBufferPtr() {
        return this.bufferPtr;
    }

    public long getBufferSize() {
        return this.bufferSize;
    }

    public HashMap<Integer, JniMarker> getTracefileMarkersMap() {
        return this.tracefileMarkersMap;
    }

    public JniTrace getParentTrace() {
        return this.parentTrace;
    }

    public Jni_C_Pointer_And_Library_Id getTracefilePtr() {
        return this.thisTracefilePtr;
    }

    public void printTracefileInformation() {
        this.ltt_printTracefile(this.thisTracefilePtr.getLibraryId(), this.thisTracefilePtr.getPointer());
    }

    public String toString() {
        String returnData = "";
        returnData = String.valueOf(returnData) + "isCpuOnline                        : " + this.isCpuOnline + "\n";
        returnData = String.valueOf(returnData) + "tracefilePath                      : " + this.tracefilePath + "\n";
        returnData = String.valueOf(returnData) + "tracefileName                      : " + this.tracefileName + "\n";
        returnData = String.valueOf(returnData) + "cpuNumber                          : " + this.cpuNumber + "\n";
        returnData = String.valueOf(returnData) + "tid                                : " + this.tid + "\n";
        returnData = String.valueOf(returnData) + "pgid                               : " + this.pgid + "\n";
        returnData = String.valueOf(returnData) + "creation                           : " + this.creation + "\n";
        returnData = String.valueOf(returnData) + "tracePtr                           : " + this.tracePtr + "\n";
        returnData = String.valueOf(returnData) + "markerDataPtr                      : " + this.markerDataPtr + "\n";
        returnData = String.valueOf(returnData) + "CFileDescriptor                    : " + this.CFileDescriptor + "\n";
        returnData = String.valueOf(returnData) + "fileSize                           : " + this.fileSize + "\n";
        returnData = String.valueOf(returnData) + "blocksNumber                       : " + this.blocksNumber + "\n";
        returnData = String.valueOf(returnData) + "isBytesOrderReversed               : " + this.isBytesOrderReversed + "\n";
        returnData = String.valueOf(returnData) + "isFloatWordOrdered                 : " + this.isFloatWordOrdered + "\n";
        returnData = String.valueOf(returnData) + "alignement                         : " + this.alignement + "\n";
        returnData = String.valueOf(returnData) + "bufferHeaderSize                   : " + this.bufferHeaderSize + "\n";
        returnData = String.valueOf(returnData) + "bitsOfCurrentTimestampCounter      : " + this.bitsOfCurrentTimestampCounter + "\n";
        returnData = String.valueOf(returnData) + "bitsOfEvent                        : " + this.bitsOfEvent + "\n";
        returnData = String.valueOf(returnData) + "currentTimestampCounterMask        : " + this.currentTimestampCounterMask + "\n";
        returnData = String.valueOf(returnData) + "currentTimestampCounterMaskNextBit : " + this.currentTimestampCounterMaskNextBit + "\n";
        returnData = String.valueOf(returnData) + "eventsLost                         : " + this.eventsLost + "\n";
        returnData = String.valueOf(returnData) + "subBufferCorrupt                   : " + this.subBufferCorrupt + "\n";
        returnData = String.valueOf(returnData) + "currentEvent                       : " + this.currentEvent.getReferenceToString() + "\n";
        returnData = String.valueOf(returnData) + "bufferPtr                          : " + this.bufferPtr + "\n";
        returnData = String.valueOf(returnData) + "bufferSize                         : " + this.bufferSize + "\n";
        returnData = String.valueOf(returnData) + "tracefileMarkersMap                : " + this.tracefileMarkersMap.keySet() + "\n";
        return returnData;
    }

    public abstract JniEvent allocateNewJniEvent(Jni_C_Pointer_And_Library_Id var1, HashMap<Integer, JniMarker> var2, JniTracefile var3) throws JniException;

    public abstract JniMarker allocateNewJniMarker(Jni_C_Pointer_And_Library_Id var1) throws JniException;
}

