/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpmstubby;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.internal.rpmstubby.AbstractGenerator;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyLog;
import org.eclipse.linuxtools.internal.rpmstubby.model.FeatureModel;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class StubbyGenerator
extends AbstractGenerator {
    private FeatureModel model;
    private IFile featureFile;

    public StubbyGenerator(IFile featureFile) {
        this.featureFile = featureFile;
        this.parse(featureFile);
        this.specfileName = String.valueOf(this.model.getPackageName().toLowerCase()) + ".spec";
        this.projectName = featureFile.getProject().getName();
    }

    private void parse(IFile featureFile) {
        DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
        IPath featureDir = featureFile.getLocation().removeLastSegments(1);
        String featurePropertiesFile = String.valueOf(featureDir.toOSString()) + "/feature.properties";
        Properties featureProperties = new Properties();
        try {
            featureProperties.load(new FileInputStream(featurePropertiesFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            StubbyLog.logError(e);
        }
        try {
            DocumentBuilder docbuilder = docfactory.newDocumentBuilder();
            Document docroot = docbuilder.parse(featureFile.getContents());
            this.model = new FeatureModel(docroot, featureProperties);
        }
        catch (ParserConfigurationException e) {
            StubbyLog.logError(e);
        }
        catch (SAXException e) {
            StubbyLog.logError(e);
        }
        catch (IOException e) {
            StubbyLog.logError(e);
        }
        catch (CoreException e) {
            StubbyLog.logError(e);
        }
    }

    public String generateSpecfile() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("%global eclipse_base   %{_libdir}/eclipse\n");
        buffer.append("%global install_loc    %{_datadir}/eclipse/dropins/" + this.model.getSimplePackageName() + "\n\n");
        buffer.append("Name:           " + this.model.getPackageName().toLowerCase() + "\n");
        buffer.append("Version:        " + this.model.getVersion() + "\n");
        buffer.append("Release:        1%{?dist}\n");
        buffer.append("Summary:        " + this.model.getSummary() + "\n\n");
        buffer.append("Group:          Development/Tools\n");
        buffer.append("License:        " + this.model.getLicense() + "\n");
        buffer.append("URL:            " + this.model.getURL() + "\n");
        buffer.append("Source0:        #FIXME\n");
        buffer.append("BuildArch: noarch\n\n");
        this.generateRequires(buffer);
        buffer.append("\n%description\n" + this.model.getDescription() + "\n");
        this.generatePrepSection(buffer);
        this.generateBuildSection(buffer);
        this.generateInstallSection(buffer);
        this.generateFilesSections(buffer);
        this.generateChangelog(buffer);
        return buffer.toString();
    }

    private void generateRequires(StringBuilder buffer) {
        buffer.append("BuildRequires: eclipse-pde >= 1:3.4.0\n");
        buffer.append("Requires: eclipse-platform >= 3.4.0\n");
    }

    private void generateInstallSection(StringBuilder buffer) {
        buffer.append("%install\n");
        buffer.append("install -d -m 755 %{buildroot}%{install_loc}\n\n");
        buffer.append("%{__unzip} -q -d %{buildroot}%{install_loc} \\\n");
        buffer.append("     build/rpmBuild/" + this.model.getFeatureId() + ".zip \n\n");
    }

    private void generateFilesSections(StringBuilder buffer) {
        String[] files;
        buffer.append("%files\n");
        buffer.append("%{install_loc}\n");
        String docsRoot = this.featureFile.getLocation().removeLastSegments(1).lastSegment();
        String[] stringArray = files = this.featureFile.getLocation().removeLastSegments(1).toFile().list();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (file.matches("(epl-.*|license)\\.html")) {
                buffer.append("%doc " + docsRoot + "/" + file + "\n");
            }
            ++n2;
        }
        buffer.append("\n");
    }

    private void generatePrepSection(StringBuilder buffer) {
        buffer.append("\n%prep\n");
        buffer.append("#FIXME Replace FIXME with the root directory name in Source0\n");
        buffer.append("%setup -q -n FIXME\n\n");
    }

    private void generateBuildSection(StringBuilder buffer) {
        buffer.append("%build\n");
        buffer.append("%{eclipse_base}/buildscripts/pdebuild -f ").append(this.model.getFeatureId());
        buffer.append("\n\n");
    }

    public String getPackageName(String packageName) {
        String[] packageItems = packageName.split("\\.");
        String name = packageItems[packageItems.length - 1];
        if (name.equalsIgnoreCase("feature")) {
            name = packageItems[packageItems.length - 2];
        }
        return "eclipse-" + name;
    }

    private void generateChangelog(StringBuilder buffer) {
        buffer.append("%changelog\n\n");
        buffer.append("#FIXME\n");
    }
}

