/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui.editor;

import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.linuxtools.internal.rpm.ui.editor.RpmPackageBuildProposalsJob;
import org.eclipse.linuxtools.internal.rpm.ui.editor.RpmPackageProposalsList;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.internal.rpm.ui.editor.UiUtils;
import org.eclipse.linuxtools.rpm.ui.editor.RpmMacroProposalsList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.rpm.ui.editor";
    private static Activator plugin;
    private ContributionTemplateStore fTemplateStore;
    private ContributionContextTypeRegistry fContextTypeRegistry;
    private RpmMacroProposalsList macrosList;
    private List<String> rpmGroups = new ArrayList<String>();
    public static RpmPackageProposalsList packagesList;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        RpmPackageBuildProposalsJob.setPropertyChangeListener(true);
        RpmPackageBuildProposalsJob.update();
        UiUtils.pluginSanityCheck();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        RpmPackageBuildProposalsJob.setPropertyChangeListener(false);
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public TemplateStore getTemplateStore() {
        if (this.fTemplateStore == null) {
            this.fTemplateStore = new ContributionTemplateStore(this.getContextTypeRegistry(), this.getPreferenceStore(), "templates");
            try {
                this.fTemplateStore.load();
            }
            catch (IOException e) {
                SpecfileLog.logError(e);
            }
        }
        return this.fTemplateStore;
    }

    public RpmMacroProposalsList getRpmMacroList() {
        this.macrosList = new RpmMacroProposalsList();
        return this.macrosList;
    }

    public RpmPackageProposalsList getRpmPackageList() {
        if (packagesList == null) {
            packagesList = new RpmPackageProposalsList();
        } else if (packagesList.getProposals("").size() == 0) {
            packagesList = new RpmPackageProposalsList();
        }
        return packagesList;
    }

    public List<String> getRpmGroups() {
        String docDir;
        File dir;
        if (this.rpmGroups.isEmpty() && (dir = new File(docDir = "/usr/share/doc/")).exists()) {
            File[] files = dir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("rpm-");
                }
            });
            try {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    File groupsFile = new File(file, "GROUPS");
                    if (groupsFile.exists()) {
                        String line;
                        LineNumberReader reader = new LineNumberReader(new FileReader(groupsFile));
                        while ((line = reader.readLine()) != null) {
                            this.rpmGroups.add(line);
                        }
                        break;
                    }
                    ++n2;
                }
            }
            catch (IOException e) {
                SpecfileLog.logError(e);
            }
        }
        return this.rpmGroups;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.fContextTypeRegistry == null) {
            this.fContextTypeRegistry = new ContributionContextTypeRegistry();
            this.fContextTypeRegistry.addContextType("org.eclipse.linuxtools.rpm.ui.editor.preambleSection");
            this.fContextTypeRegistry.addContextType("org.eclipse.linuxtools.rpm.ui.editor.preSection");
            this.fContextTypeRegistry.addContextType("org.eclipse.linuxtools.rpm.ui.editor.buildSection");
            this.fContextTypeRegistry.addContextType("org.eclipse.linuxtools.rpm.ui.editor.installSection");
            this.fContextTypeRegistry.addContextType("org.eclipse.linuxtools.rpm.ui.editor.changelogSection");
        }
        return this.fContextTypeRegistry;
    }

    public Image getImage(String imageRelativePath) {
        ImageRegistry registry = this.getImageRegistry();
        Image image = registry.get(imageRelativePath);
        if (image == null) {
            ImageDescriptor desc = Activator.getImageDescriptor(imageRelativePath);
            registry.put(imageRelativePath, desc);
            image = registry.get(imageRelativePath);
        }
        return image;
    }
}

