/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphing.actions;

import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.linuxtools.systemtap.ui.graphing.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.graphing.structures.GraphDisplaySet;
import org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorView;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.ITabListener;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class ExportDataSetAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;
    private IAction action;

    public void init(IWorkbenchWindow window) {
        LogManager.logDebug((String)"Start ExportDataSetAction.init", (Object)((Object)this));
        LogManager.logInfo((String)"Initialize ExportDataSetAction", (Object)((Object)this));
        this.fWindow = window;
        LogManager.logDebug((String)"End ExportDataSetAction.init", (Object)((Object)this));
    }

    public void run(IAction act) {
        LogManager.logDebug((String)"Start ExportDataSetAction.run", (Object)((Object)this));
        File f = null;
        IDataSet data = this.getDataSet();
        if (data != null) {
            f = this.getFile();
        }
        if (f != null && data != null) {
            data.writeToFile(f);
        }
        LogManager.logDebug((String)"End ExportDataSetAction.run", (Object)((Object)this));
    }

    public IDataSet getDataSet() {
        LogManager.logDebug((String)"Start ExportDataSetAction.getDataSet", (Object)((Object)this));
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorView");
        IDataSet data = null;
        GraphDisplaySet gds = ((GraphSelectorView)ivp).getActiveDisplaySet();
        if (gds != null) {
            data = gds.getDataSet();
        }
        LogManager.logDebug((String)"End ExportDataSetAction.getDataSet", (Object)((Object)this));
        return data;
    }

    public File getFile() {
        LogManager.logDebug((String)"Start ExportDataSetAction.getFile", (Object)((Object)this));
        String path = null;
        FileDialog dialog = new FileDialog(this.fWindow.getShell(), 8192);
        dialog.setText(Localization.getString("ExportDataSetAction.NewFile"));
        path = dialog.open();
        if (path == null) {
            return null;
        }
        LogManager.logDebug((String)"End ExportDataSetAction.getFile", (Object)((Object)this));
        return new File(path);
    }

    public void selectionChanged(IAction a, ISelection s) {
        this.action = a;
        this.setEnablement(false);
        this.buildEnablementChecks();
    }

    private void buildEnablementChecks() {
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorView");
        if (ivp != null) {
            final GraphSelectorView gsv = (GraphSelectorView)ivp;
            this.setEnablement(gsv.getActiveDisplaySet() != null);
            gsv.addTabListener(new ITabListener(){

                public void tabClosed() {
                    ExportDataSetAction.this.setEnablement(gsv.getActiveDisplaySet() != null);
                }

                public void tabOpened() {
                    ExportDataSetAction.this.setEnablement(true);
                }

                public void tabChanged() {
                }
            });
        }
    }

    private void setEnablement(boolean enable) {
        this.action.setEnabled(enable);
    }

    public void dispose() {
        LogManager.logDebug((String)"Start ExportDataSetAction.dispose", (Object)((Object)this));
        LogManager.logInfo((String)"Dispose ExportDataSetAction", (Object)((Object)this));
        this.fWindow = null;
        this.action = null;
        LogManager.logDebug((String)"End ExportDataSetAction.dispose", (Object)((Object)this));
    }
}

