/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.rpmlint.parser;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.rpm.core.utils.Utils;
import org.eclipse.linuxtools.rpm.rpmlint.Activator;
import org.eclipse.linuxtools.rpm.rpmlint.RpmlintLog;
import org.eclipse.linuxtools.rpm.rpmlint.parser.RpmlintItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpmlintParser {
    private static final String COLON = ":";
    private static final String SPACE = " ";
    private static final String EMPTY_STRING = "";
    private static RpmlintParser rpmlintParser;

    private RpmlintParser() {
    }

    public static RpmlintParser getInstance() {
        if (rpmlintParser == null) {
            rpmlintParser = new RpmlintParser();
        }
        return rpmlintParser;
    }

    public ArrayList<RpmlintItem> parseVisisted(ArrayList<String> visitedResources) {
        ArrayList<RpmlintItem> retList = new ArrayList<RpmlintItem>();
        ArrayList<List<String>> commandsList = this.splitArrayList(visitedResources, 500);
        Iterator<List<String>> iterator = commandsList.iterator();
        while (iterator.hasNext()) {
            if (commandsList.size() > 1) {
                retList.addAll(this.parseRpmlintOutput(this.runRpmlintCommand(iterator.next())));
                continue;
            }
            return this.parseRpmlintOutput(this.runRpmlintCommand(visitedResources));
        }
        return retList;
    }

    public void addMarker(IFile file, String message, int lineNumber, int charStart, int charEnd, int severity, String rpmlintID, String rpmlintrefferedContent) {
        try {
            IMarker marker = file.createMarker("org.eclipse.linuxtools.rpm.rpmlint.rpmlintProblem");
            marker.setAttribute("location", (Object)file.getFullPath().toString());
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            marker.setAttribute("lineNumber", lineNumber);
            marker.setAttribute("charStart", charStart);
            marker.setAttribute("charEnd", charEnd);
            marker.setAttribute("rpmlintErrorId", (Object)rpmlintID);
            marker.setAttribute("rpmlintrefferedContent", (Object)rpmlintrefferedContent);
        }
        catch (CoreException e) {
            RpmlintLog.logError(e);
        }
    }

    public void addMarker(IFile file, String message, int severity, String rpmlintID, String rpmlintrefferedContent) {
        try {
            IMarker marker = file.createMarker("org.eclipse.linuxtools.rpm.rpmlint.rpmlintProblem");
            marker.setAttribute("location", (Object)file.getFullPath().toString());
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            marker.setAttribute("rpmlintErrorId", (Object)rpmlintID);
            marker.setAttribute("rpmlintrefferedContent", (Object)rpmlintrefferedContent);
        }
        catch (CoreException e) {
            RpmlintLog.logError(e);
        }
    }

    public void deleteMarkers(IResource resource) {
        try {
            resource.deleteMarkers("org.eclipse.linuxtools.rpm.rpmlint.rpmlintProblem", false, 0);
        }
        catch (CoreException e) {
            RpmlintLog.logError(e);
        }
    }

    private ArrayList<RpmlintItem> parseRpmlintOutput(BufferedInputStream in) {
        RpmlintItem item = new RpmlintItem();
        ArrayList<RpmlintItem> rpmlintItems = new ArrayList<RpmlintItem>();
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(in));
        boolean isFirtItemLine = true;
        String description = EMPTY_STRING;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                int useOfTabsAndSpaces;
                if (isFirtItemLine) {
                    isFirtItemLine = false;
                    String[] lineItems = line.split(COLON, 4);
                    item.setFileName(lineItems[0]);
                    try {
                        Integer.parseInt(line.split(SPACE)[0]);
                        return rpmlintItems;
                    }
                    catch (NumberFormatException numberFormatException) {
                        int lineNbr;
                        try {
                            lineNbr = Integer.parseInt(lineItems[1]);
                            item.setSeverity(lineItems[2]);
                            lineItems = lineItems[3].trim().split(SPACE, 2);
                        }
                        catch (NumberFormatException numberFormatException2) {
                            lineItems = line.split(COLON, 3);
                            lineNbr = -1;
                            item.setSeverity(lineItems[1]);
                            lineItems = lineItems[2].trim().split(SPACE, 2);
                        }
                        item.setLineNbr(lineNbr);
                        item.setId(lineItems[0]);
                        if (lineItems.length > 1) {
                            RpmlintItem tmpItem = this.parseRpmOutput(item, lineItems[1]);
                            if (tmpItem == null) {
                                item.setRefferedContent(lineItems[1]);
                            }
                            item = tmpItem;
                        }
                        item.setRefferedContent(EMPTY_STRING);
                    }
                } else {
                    description = String.valueOf(description) + line + '\n';
                }
                if (!line.equals(EMPTY_STRING)) continue;
                if (item.getMessage() == null) {
                    item.setMessage(description.substring(0, description.length() - 2));
                }
                if ((useOfTabsAndSpaces = this.getMixedUseOfTabsAndSpaces(item.getRefferedContent())) != -1) {
                    item.setLineNbr(useOfTabsAndSpaces);
                }
                rpmlintItems.add(item);
                item = new RpmlintItem();
                isFirtItemLine = true;
                description = EMPTY_STRING;
            }
            in.close();
        }
        catch (IOException e) {
            RpmlintLog.logError(e);
        }
        return rpmlintItems;
    }

    private RpmlintItem parseRpmOutput(RpmlintItem item, String line) {
        String[] rpmErrorItems = line.split(COLON, 4);
        if (!item.getId().equalsIgnoreCase("specfile-error")) {
            return null;
        }
        item.setSeverity("E");
        try {
            if (rpmErrorItems[1].matches(" line [0-9]+$")) {
                item.setLineNbr(Integer.parseInt(rpmErrorItems[1].replace(" line ", EMPTY_STRING)));
                item.setMessage(rpmErrorItems[2]);
                item.setRefferedContent(rpmErrorItems[3]);
            } else {
                item.setLineNbr(-1);
                item.setMessage(rpmErrorItems[1]);
                item.setRefferedContent(EMPTY_STRING);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return item;
    }

    private BufferedInputStream runRpmlintCommand(List<String> visitedResources) {
        BufferedInputStream in = null;
        int i = 2;
        String[] cmd = new String[visitedResources.size() + i];
        cmd[0] = Activator.getRpmlintPath();
        cmd[1] = "-i";
        Iterator<String> iterator = visitedResources.iterator();
        while (iterator.hasNext()) {
            cmd[i] = iterator.next();
            ++i;
        }
        try {
            in = Utils.runCommandToInputStream((String[])cmd);
        }
        catch (IOException e) {
            RpmlintLog.logError(e);
        }
        return in;
    }

    public int getRealLineNbr(String specContent, String strToFind) {
        int ret = -1;
        if (strToFind.equals(EMPTY_STRING)) {
            return ret;
        }
        LineNumberReader reader = new LineNumberReader(new StringReader(specContent));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.replaceAll("\t| ", EMPTY_STRING).indexOf(strToFind.replaceAll("\t| ", EMPTY_STRING)) <= -1) continue;
                ret = reader.getLineNumber();
            }
        }
        catch (IOException iOException) {}
        return ret;
    }

    private int getMixedUseOfTabsAndSpaces(String refferedContent) {
        int lineNbr = -1;
        if (refferedContent.indexOf("(spaces: line") > -1) {
            String tabsAndSpacesPref = Activator.getDefault().getPreferenceStore().getString("RpmlintSpaces");
            String[] spacesAndTabs = refferedContent.split("line");
            lineNbr = tabsAndSpacesPref == "RpmlintSpaces" ? Integer.parseInt(spacesAndTabs[1].split(",")[0].trim()) : Integer.parseInt(spacesAndTabs[2].replaceFirst("\\)", EMPTY_STRING).trim());
        }
        return lineNbr;
    }

    private ArrayList<List<String>> splitArrayList(ArrayList<String> list, int listSize) {
        ArrayList<List<String>> resultList = new ArrayList<List<String>>();
        if (list.size() <= listSize) {
            resultList.add(list);
            return resultList;
        }
        int i = 0;
        while (i < this.getNumberOfIterations(list, listSize)) {
            int maxLength = (i + 1) * listSize > list.size() ? list.size() : (i + 1) * listSize;
            ArrayList<List<String>> sublist = new ArrayList<List<String>>();
            sublist.add(list.subList(i * listSize, maxLength));
            resultList.addAll(sublist);
            ++i;
        }
        return resultList;
    }

    private int getNumberOfIterations(List<String> list, int subCollectionSize) {
        return list.size() % subCollectionSize == 0 ? list.size() / subCollectionSize : list.size() / subCollectionSize + 1;
    }
}

