/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.state.model;

import java.util.Stack;
import org.eclipse.linuxtools.lttng.state.StateStrings;

public class LttngIRQState
implements Cloneable {
    private Stack<StateStrings.IRQMode> mode_stack = new Stack();

    public LttngIRQState() {
        this.mode_stack.push(StateStrings.IRQMode.LTTV_IRQ_UNKNOWN);
    }

    public LttngIRQState clone() {
        LttngIRQState newState = null;
        try {
            newState = (LttngIRQState)super.clone();
            newState.mode_stack = (Stack)this.mode_stack.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println("Cloning failed with : " + e.getMessage());
        }
        return newState;
    }

    public void clearIrqStack() {
        this.mode_stack.clear();
    }

    public void clearAndSetBaseToIrqStack(StateStrings.IRQMode newState) {
        this.mode_stack.clear();
        this.mode_stack.push(newState);
    }

    public void pushToIrqStack(StateStrings.IRQMode newState) {
        this.mode_stack.push(newState);
    }

    public StateStrings.IRQMode popFromIrqStack() {
        StateStrings.IRQMode returnedMode = this.mode_stack.pop();
        if (this.mode_stack.size() < 1) {
            this.mode_stack.push(StateStrings.IRQMode.LTTV_IRQ_UNKNOWN);
        }
        return returnedMode;
    }

    public StateStrings.IRQMode peekFromIrqStack() {
        return this.mode_stack.peek();
    }
}

