/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.voice.preferences.util;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboFieldEditor
extends FieldEditor {
    Combo comboField;
    private String[][] labelsAndValues;
    protected String value;

    protected ComboFieldEditor(String string, String string2, String[][] stringArray, Composite composite) {
        this.init(string, string2);
        this.initLabelsAndValues(stringArray);
        this.createControl(composite);
        this.setEnabled(this.comboField.getItemCount() > 0, composite);
    }

    protected void initLabelsAndValues(String[][] stringArray) {
        assert (this.checkArray(stringArray));
        this.labelsAndValues = stringArray;
    }

    protected void adjustForNumColumns(int n) {
        GridData gridData = (GridData)this.comboField.getLayoutData();
        gridData.horizontalSpan = n - 1;
        gridData.grabExcessHorizontalSpace = gridData.horizontalSpan == 1;
    }

    protected void doFillIntoGrid(Composite composite, int n) {
        this.getLabelControl(composite);
        this.comboField = this.getComboControl(composite);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n - 1;
        this.comboField.setLayoutData((Object)gridData);
    }

    protected void doLoad() {
        this.updateValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    protected void doStore() {
        if (this.value != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), this.value);
        } else {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    private boolean checkArray(String[][] stringArray) {
        if (stringArray == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = stringArray[n];
            if (stringArray2 == null || stringArray2.length != 2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void updateValue(String string) {
        if (string != null) {
            int n = 0;
            while (n < this.labelsAndValues.length) {
                if (this.labelsAndValues[n][1].equals(string)) {
                    this.comboField.select(n);
                    this.value = string;
                    return;
                }
                ++n;
            }
        }
        if (this.labelsAndValues.length > 0) {
            this.comboField.select(0);
            this.value = this.labelsAndValues[0][1];
        }
    }

    public Combo getComboControl() {
        return this.comboField;
    }

    protected Combo getComboControl(Composite composite) {
        if (this.comboField == null) {
            this.comboField = new Combo(composite, 2124);
            this.comboField.setFont(composite.getFont());
            if (this.labelsAndValues != null) {
                int n = 0;
                while (n < this.labelsAndValues.length) {
                    this.comboField.add(this.labelsAndValues[n][0]);
                    ++n;
                }
            }
            this.comboField.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    int n = ComboFieldEditor.this.comboField.getSelectionIndex();
                    if (n >= 0) {
                        String string = ComboFieldEditor.this.value;
                        ComboFieldEditor.this.value = ComboFieldEditor.this.labelsAndValues[n][1];
                        ComboFieldEditor.this.setPresentsDefaultValue(false);
                        ComboFieldEditor.this.fireValueChanged("field_editor_value", string, ComboFieldEditor.this.value);
                    }
                }
            });
            this.comboField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    ComboFieldEditor.this.comboField = null;
                }
            });
        } else {
            this.checkParent((Control)this.comboField, composite);
        }
        return this.comboField;
    }

    public void setEnabled(boolean bl, Composite composite) {
        super.setEnabled(bl, composite);
        this.getComboControl(composite).setEnabled(bl);
    }
}

