/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.ui.report.action;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.actf.visualization.eval.IEvaluationItem;
import org.eclipse.actf.visualization.eval.IGuidelineItem;
import org.eclipse.actf.visualization.eval.ITechniquesItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.ui.report.Messages;
import org.eclipse.actf.visualization.internal.ui.report.action.ShowTechniquesAction;
import org.eclipse.actf.visualization.internal.ui.report.table.ResultTableViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TechniquesSubMenu
extends MenuManager {
    private TableViewer _tableViewer;
    private Action _dummy;

    public TechniquesSubMenu(ResultTableViewer resultTableViewer) {
        super(Messages.ViewTechniques);
        this._tableViewer = resultTableViewer.getTableViewer();
        this._tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                List list = ((IStructuredSelection)selectionChangedEvent.getSelection()).toList();
                TechniquesSubMenu.this.setTechniques(list);
            }
        });
        this._dummy = new Action(Messages.NoTechniques){};
        this._dummy.setEnabled(false);
        this.add((IAction)this._dummy);
    }

    public void setTechniques(List<IProblemItem> list) {
        this.removeAll();
        TreeSet<IEvaluationItem> treeSet = new TreeSet<IEvaluationItem>(new Comparator<IEvaluationItem>(){

            @Override
            public int compare(IEvaluationItem iEvaluationItem, IEvaluationItem iEvaluationItem2) {
                return iEvaluationItem.getId().compareTo(iEvaluationItem2.getId());
            }
        });
        for (IProblemItem object2 : list) {
            treeSet.add(object2.getEvaluationItem());
        }
        TreeSet<ITechniquesItem> treeSet2 = new TreeSet<ITechniquesItem>(new Comparator<ITechniquesItem>(){

            @Override
            public int compare(ITechniquesItem iTechniquesItem, ITechniquesItem iTechniquesItem2) {
                int n = iTechniquesItem.getGuidelineName().compareTo(iTechniquesItem2.getGuidelineName());
                if (n == 0) {
                    n = iTechniquesItem.getId().compareTo(iTechniquesItem2.getId());
                }
                return n;
            }
        });
        for (IEvaluationItem iEvaluationItem : treeSet) {
            IGuidelineItem[] iGuidelineItemArray = iEvaluationItem.getGuidelines();
            ITechniquesItem[][] iTechniquesItemArray = iEvaluationItem.getTechniques();
            int n = 0;
            while (n < iGuidelineItemArray.length) {
                if (iGuidelineItemArray[n].isEnabled()) {
                    treeSet2.addAll(Arrays.asList(iTechniquesItemArray[n]));
                }
                ++n;
            }
        }
        Iterator iterator = treeSet2.iterator();
        while (iterator.hasNext()) {
            this.add((IAction)new ShowTechniquesAction((ITechniquesItem)iterator.next()));
        }
        if (this.getItems().length == 0) {
            this.add((IAction)this._dummy);
        }
    }
}

