/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.blind.html;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.actf.model.dom.html.HTMLParserFactory;
import org.eclipse.actf.model.dom.html.IErrorLogListener;
import org.eclipse.actf.model.dom.html.IHTMLParser;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.util.dom.DomPrintUtil;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.blind.BlindVisualizerBase;
import org.eclipse.actf.visualization.blind.IBlindVisualizer;
import org.eclipse.actf.visualization.blind.ui.internal.Messages;
import org.eclipse.actf.visualization.engines.blind.BlindVizResourceUtil;
import org.eclipse.actf.visualization.engines.blind.ParamBlind;
import org.eclipse.actf.visualization.engines.blind.eval.EvaluationResultBlind;
import org.eclipse.actf.visualization.engines.blind.html.IVisualizeMapData;
import org.eclipse.actf.visualization.engines.blind.html.VisualizeEngine;
import org.eclipse.actf.visualization.engines.blind.html.util.HtmlErrorLogListener;
import org.eclipse.actf.visualization.eval.CheckTargetFactory;
import org.eclipse.actf.visualization.eval.EvaluationUtil;
import org.eclipse.actf.visualization.eval.ICheckTarget;
import org.eclipse.actf.visualization.eval.IHtmlCheckTarget;
import org.eclipse.actf.visualization.eval.IHtmlChecker;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.html.HtmlEvalUtil;
import org.eclipse.actf.visualization.eval.html.statistics.PageData;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetNodeInfo;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItemVisitor;
import org.eclipse.actf.visualization.util.html2view.Html2ViewMapMaker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BlindVisualizerHtml
extends BlindVisualizerBase
implements IBlindVisualizer {
    public static final int FRAME = 1;
    private static final String ORIG_HTML_FILE = "origSource.html";
    private static final String IE_HTML_FILE = "ieSource.html";
    private static final String MAPPED_HTML_FILE_PRE = "MappedHTML";
    private static final String HTML_SOURCE_FILE = "source.html";
    private IWebBrowserACTF webBrowser;
    private final boolean PERFORMANCE_DEBUG = false;

    public boolean setModelService(IModelService targetModel) {
        this.webBrowser = null;
        if (super.setModelService(targetModel)) {
            this.webBrowser = (IWebBrowserACTF)targetModel;
            return true;
        }
        return false;
    }

    public boolean isTarget(IModelService modelService) {
        return modelService != null && modelService instanceof IWebBrowserACTF;
    }

    public int visualize() {
        block25: {
            boolean hasFrame;
            File targetFile;
            Document originalDocument;
            Document document;
            Document ieDom;
            boolean isIEhtml;
            HtmlErrorLogListener errorLogListener;
            Vector html2ViewMapV;
            File liveFile;
            File srcFile;
            block24: {
                GuidelineHolder.getInstance().setTargetMimeType("text/html");
                int frameId = 0;
                this.checkResult = new EvaluationResultBlind();
                srcFile = this.webBrowser.saveOriginalDocument(String.valueOf(this.tmpDirS) + ORIG_HTML_FILE);
                liveFile = this.webBrowser.saveDocumentAsHTMLFile(String.valueOf(this.tmpDirS) + IE_HTML_FILE);
                this.webBrowser.saveOriginalDocument(String.valueOf(this.tmpDirS) + HTML_SOURCE_FILE);
                html2ViewMapV = new Vector();
                IHTMLParser htmlParser = HTMLParserFactory.createHTMLParser();
                errorLogListener = new HtmlErrorLogListener();
                htmlParser.addErrorLogListener((IErrorLogListener)errorLogListener);
                String targetFileName = String.valueOf(this.tmpDirS) + MAPPED_HTML_FILE_PRE + frameId + ".html";
                isIEhtml = false;
                if (EvaluationUtil.isOriginalDOM()) {
                    html2ViewMapV = Html2ViewMapMaker.makeMap((String)ORIG_HTML_FILE, (String)(MAPPED_HTML_FILE_PRE + frameId + ".html"), (String)this.tmpDirS);
                    if (html2ViewMapV.size() == 0) {
                        isIEhtml = true;
                    }
                } else {
                    isIEhtml = true;
                }
                if (isIEhtml) {
                    ieDom = this.webBrowser.getLiveDocument();
                    IHTMLParser tmpHtmlParser = HTMLParserFactory.createHTMLParser();
                    tmpHtmlParser.parse((InputStream)new FileInputStream(String.valueOf(this.tmpDirS) + IE_HTML_FILE));
                    document = tmpHtmlParser.getDocument();
                    tmpHtmlParser.parse((InputStream)new FileInputStream(String.valueOf(this.tmpDirS) + ORIG_HTML_FILE));
                    originalDocument = tmpHtmlParser.getDocument();
                    targetFile = liveFile;
                } else {
                    htmlParser.parse((InputStream)new FileInputStream(targetFileName));
                    originalDocument = document = htmlParser.getDocument();
                    ieDom = this.webBrowser.getLiveDocument();
                    targetFile = srcFile;
                }
                hasFrame = false;
                if (document != null) break block24;
                return -1;
            }
            try {
                if (this.hasFrameset(document, this.webBrowser)) {
                    hasFrame = true;
                }
                this.setStatusMessage(Messages.BlindView_Now_processing);
                this.pageData = new PageData();
                VisualizeEngine engine = new VisualizeEngine();
                engine.setBaseUrl("");
                engine.setTargetUrl(this.targetUrl);
                engine.setDocument(document);
                engine.setHtml2viewMapV(html2ViewMapV);
                engine.setInvisibleIdSet(new HashSet());
                engine.setPageData(this.pageData);
                engine.visualize();
                this.maxReachingTime = engine.getMaxTime();
                this.setInfoMessage(this.getMaxReachingTime());
                this.resultDocument = engine.getResult();
                this.checkResult.setProblemList(engine.getProbelems());
                this.checkResult.setTargetUrl(this.targetUrl);
                if (this.variantFile != null) {
                    this.variantFile.delete();
                }
                this.variantFile = engine.getVariantFile();
                this.checkResult.addAssociateFile(this.variantFile);
                IVisualizeMapData mapData = engine.getVisualizeMapData();
                this.checkResult.setSourceFile(new File(String.valueOf(this.tmpDirS) + HTML_SOURCE_FILE));
                boolean isDBCS = false;
                if (ParamBlind.getInstance().iLanguage == 1) {
                    isDBCS = true;
                }
                HtmlEvalUtil edu = new HtmlEvalUtil(document, this.resultDocument, this.targetUrl, mapData.getOrig2idMap(), originalDocument, ieDom, this.pageData, isDBCS, isIEhtml);
                edu.setLiveFile(liveFile);
                edu.setSrcFile(srcFile);
                edu.setTargetFile(targetFile);
                ArrayList tmpResults = new ArrayList(1024);
                IHtmlCheckTarget checkTarget = CheckTargetFactory.createHtmlCheckTarget((Document)document, (String)this.webBrowser.getURL(), null, (HtmlEvalUtil)edu);
                int i = 0;
                while (i < this.checkers.length) {
                    if (this.checkers[i] instanceof IHtmlChecker) {
                        tmpResults.addAll(((IHtmlChecker)this.checkers[i]).checkHtml(checkTarget));
                    } else if (this.checkers[i].isTargetFormat(this.webBrowser.getCurrentMIMEType()) && this.checkers[i].isEnabled()) {
                        tmpResults.addAll(this.checkers[i].check((ICheckTarget)checkTarget));
                    }
                    ++i;
                }
                i = 0;
                while (i < tmpResults.size()) {
                    IProblemItem tmpItem = (IProblemItem)tmpResults.get(i);
                    HighlightTargetNodeInfo nodeInfo = tmpItem.getHighlightTargetNodeInfo();
                    if (nodeInfo != null) {
                        if (tmpItem.getHighlightTargetIds().length == 0) {
                            tmpItem.setHighlightTargetIds(nodeInfo.getHighlightTargetIds(mapData.getOrig2idMap()));
                        }
                        if (EvaluationUtil.isOriginalDOM()) {
                            tmpItem.setHighlightTargetSourceInfo(nodeInfo.getHighlightTargetSourceInfo(html2ViewMapV));
                        }
                    }
                    ++i;
                }
                this.checkResult.addProblemItems(tmpResults);
                this.checkResult.addProblemItems((Collection)errorLogListener.getHtmlProblemVector());
                this.checkResult.accept((IProblemItemVisitor)this.pageData);
                if (this.resultFile != null) {
                    this.resultFile.delete();
                }
                this.resultFile = BlindVizResourceUtil.createTempFile((String)"result", (String)".html");
                try {
                    DomPrintUtil dpu = new DomPrintUtil(this.resultDocument);
                    dpu.writeToFile(this.resultFile);
                }
                catch (Exception exception) {
                    DebugPrintUtil.devOrDebugPrintln((Object)"error: saveHtmlDocumentAsUTF8");
                }
                if (!hasFrame) break block25;
                this.pageData.setHasFrame(true);
                return 1;
            }
            catch (Exception e) {
                this.setStatusMessage(Messages.Visualization_Error);
                e.printStackTrace();
                return -1;
            }
        }
        if (this.webBrowser != null && !this.webBrowser.isUrlExists()) {
            this.pageData.setError(true);
            return -1;
        }
        return 0;
    }

    private boolean hasFrameset(Document document, IWebBrowserACTF webBrowser) {
        NodeList framesetNl = document.getElementsByTagName("frameset");
        if (framesetNl.getLength() > 0) {
            PrintWriter fileOutput;
            NodeList frameList = document.getElementsByTagName("frame");
            String sFileName = BlindVizResourceUtil.getTempDirectory() + "frameList.html";
            String base = webBrowser.getURL();
            try {
                Element baseE;
                String baseUrlS;
                URL baseURL = new URL(base);
                NodeList baseNL = document.getElementsByTagName("base");
                if (baseNL.getLength() > 0 && (baseUrlS = (baseE = (Element)baseNL.item(baseNL.getLength() - 1)).getAttribute("href")).length() > 0) {
                    URL tmpUrl = new URL(baseURL, baseUrlS);
                    base = tmpUrl.toString();
                }
            }
            catch (Exception exception) {}
            try {
                fileOutput = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(sFileName), "UTF-8"));
            }
            catch (IOException iOException) {
                return true;
            }
            fileOutput.write("<html>");
            fileOutput.write("<head>" + FileUtils.LINE_SEP);
            fileOutput.write("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" >" + FileUtils.LINE_SEP);
            fileOutput.write("<base href=\"" + base + "\"></head>" + FileUtils.LINE_SEP + "<body><P>");
            fileOutput.write("This page contains of ");
            fileOutput.write(String.valueOf(frameList.getLength()));
            fileOutput.write(" frames.");
            fileOutput.write("<br>" + FileUtils.LINE_SEP);
            fileOutput.write("Please select one of them.");
            fileOutput.write("</P>" + FileUtils.LINE_SEP + "<ol>" + FileUtils.LINE_SEP);
            int i = 0;
            while (i < frameList.getLength()) {
                Element frameEl = (Element)frameList.item(i);
                String strTitle = frameEl.getAttribute("title");
                String strName = frameEl.getAttribute("name");
                if (strTitle.equals("")) {
                    strTitle.equals("none");
                }
                if (strName.equals("")) {
                    strName.equals("none");
                }
                fileOutput.write("<li><a href=\"" + frameEl.getAttribute("src") + "\">Title: \"" + strTitle + "\".<BR> Name: \"" + strName + "\".<BR> src: \"" + frameEl.getAttribute("src") + "\".</a>" + FileUtils.LINE_SEP);
                ++i;
            }
            fileOutput.write("</ol></body></html>");
            fileOutput.flush();
            fileOutput.close();
            webBrowser.navigate(sFileName);
            return true;
        }
        return false;
    }
}

