/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.blind.ui.views;

import java.util.HashSet;
import org.eclipse.actf.mediator.MediatorEvent;
import org.eclipse.actf.ui.util.AbstractPartListener;
import org.eclipse.actf.ui.util.PlatformUIUtil;
import org.eclipse.actf.visualization.blind.ui.actions.BlindSaveAction;
import org.eclipse.actf.visualization.blind.ui.actions.BlindVisualizationAction;
import org.eclipse.actf.visualization.blind.ui.internal.PartControlBlind;
import org.eclipse.actf.visualization.blind.ui.internal.SelectionListenerBlind;
import org.eclipse.actf.visualization.engines.blind.html.ui.actions.BlindOpenIdCssAction;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.ElementViewerManagerFactory;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.IElementViewerManager;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.IHighlightElementListener;
import org.eclipse.actf.visualization.engines.blind.ui.actions.BlindSettingAction;
import org.eclipse.actf.visualization.engines.blind.ui.actions.BlindVisualizationBrowserModeAction;
import org.eclipse.actf.visualization.ui.IVisualizationView;
import org.eclipse.actf.visualization.ui.VisualizationStatusLineContributionItem;
import org.eclipse.actf.visualization.ui.report.table.ResultTableLabelProvider;
import org.eclipse.actf.visualization.ui.report.table.ResultTableSorter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class BlindView
extends ViewPart
implements IVisualizationView {
    private IBaseLabelProvider baseLabelProvider;
    private ResultTableSorter viewerSorter;
    private IElementViewerManager elementViewerManager;
    private PartControlBlind partRightBlind;
    private HashSet<IWorkbenchPage> pageSet = new HashSet();
    private BlindVisualizationBrowserModeAction browserVisualizaton;

    public BlindView() {
        this.baseLabelProvider = new ResultTableLabelProvider();
        this.viewerSorter = new ResultTableSorter();
        this.elementViewerManager = ElementViewerManagerFactory.getInstance();
    }

    public void init(IViewSite site) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setStatusLine();
    }

    public void createPartControl(Composite parent) {
        this.partRightBlind = new PartControlBlind(this, parent);
        this.getSite().getPage().addSelectionListener("org.eclipse.actf.visualization.ui.report.views.DetailedReportView", (ISelectionListener)new SelectionListenerBlind(this.partRightBlind));
        this.elementViewerManager.setHighlightElementListener((IHighlightElementListener)this.partRightBlind);
        this.addPartListener();
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager toolbarManager = bars.getToolBarManager();
        this.browserVisualizaton = new BlindVisualizationBrowserModeAction();
        toolbarManager.add((IAction)new BlindVisualizationAction(this.partRightBlind));
        toolbarManager.add((IAction)this.browserVisualizaton);
        toolbarManager.add((IAction)new BlindSettingAction());
        toolbarManager.add((IAction)new BlindSaveAction(this.partRightBlind));
        toolbarManager.add((IAction)new BlindOpenIdCssAction());
        toolbarManager.add((IContributionItem)new Separator("additions"));
    }

    public void setFocus() {
    }

    public void setStatusMessage(String statusMessage) {
        IContributionItem[] items = this.getViewSite().getActionBars().getStatusLineManager().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null && items[i].getId().equals("org.eclipse.actf.visualization.VisualizationStatusLineContributionItemorg.eclipse.actf.visualization.blind.ui.views.BlindView")) {
                ((VisualizationStatusLineContributionItem)items[i]).setStatusMessage(statusMessage);
            }
            ++i;
        }
    }

    public void setInfoMessage(String infoMessage) {
        IContributionItem[] items = this.getViewSite().getActionBars().getStatusLineManager().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null && items[i].getId().equals("org.eclipse.actf.visualization.VisualizationStatusLineContributionItemorg.eclipse.actf.visualization.blind.ui.views.BlindView")) {
                ((VisualizationStatusLineContributionItem)items[i]).setInfoMessage(infoMessage);
            }
            ++i;
        }
    }

    private void initPage(IWorkbenchPage page) {
        if (this.pageSet.add(page)) {
            page.addPartListener((IPartListener2)new AbstractPartListener(){

                public void partActivated(IWorkbenchPartReference partRef) {
                    IWorkbenchPart part = partRef.getPart(false);
                    if (part instanceof IVisualizationView) {
                        if (part.equals((Object)BlindView.this)) {
                            BlindView.this.elementViewerManager.activateElementViewer();
                        } else {
                            BlindView.this.elementViewerManager.hideElementViewer();
                        }
                    }
                }
            });
        }
    }

    private void addPartListener() {
        IWorkbenchWindow activeWindow = PlatformUIUtil.getActiveWindow();
        activeWindow.addPageListener(new IPageListener(){

            public void pageActivated(IWorkbenchPage page) {
            }

            public void pageClosed(IWorkbenchPage page) {
                BlindView.this.pageSet.remove(page);
            }

            public void pageOpened(IWorkbenchPage page) {
                BlindView.this.initPage(page);
            }
        });
        IWorkbenchPage activePage = PlatformUIUtil.getActivePage();
        if (activePage != null) {
            this.initPage(activePage);
        }
    }

    private void setStatusLine() {
        this.getViewSite().getActionBars().getStatusLineManager().add((IContributionItem)new VisualizationStatusLineContributionItem("org.eclipse.actf.visualization.blind.ui.views.BlindView"));
    }

    public IBaseLabelProvider getLabelProvider() {
        return this.baseLabelProvider;
    }

    public ViewerSorter getTableSorter() {
        this.viewerSorter.reset();
        return this.viewerSorter;
    }

    public int getResultTableMode() {
        return 0;
    }

    public void doVisualize() {
        if (this.partRightBlind != null) {
            this.partRightBlind.doVisualize();
        }
    }

    public void modelserviceChanged(MediatorEvent event) {
        if (this.partRightBlind.isBrowserModeSupported(event.getModelServiceHolder())) {
            this.browserVisualizaton.setEnabled(true);
        } else {
            this.browserVisualizaton.setEnabled(false);
        }
    }

    public void modelserviceInputChanged(MediatorEvent event) {
    }

    public void reportChanged(MediatorEvent event) {
    }

    public void reportGeneratorChanged(MediatorEvent event) {
    }

    public void setVisualizeMode(int mode) {
    }
}

