/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.blind.ui.internal;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.actf.mediator.IACTFReport;
import org.eclipse.actf.mediator.IACTFReportGenerator;
import org.eclipse.actf.mediator.Mediator;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.IModelServiceHolder;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.editor.browser.WaitForBrowserReadyHandler;
import org.eclipse.actf.model.ui.util.ModelServiceUtils;
import org.eclipse.actf.ui.util.DialogSave;
import org.eclipse.actf.ui.util.PlatformUIUtil;
import org.eclipse.actf.ui.util.timer.WaitExecSyncEventHandler;
import org.eclipse.actf.ui.util.timer.WaitExecSyncEventListener;
import org.eclipse.actf.visualization.blind.IBlindVisualizer;
import org.eclipse.actf.visualization.blind.internal.BlindVisualizerExtension;
import org.eclipse.actf.visualization.blind.ui.internal.BlindVisualizationBrowser;
import org.eclipse.actf.visualization.blind.ui.internal.Messages;
import org.eclipse.actf.visualization.blind.ui.internal.SaveReportBlind;
import org.eclipse.actf.visualization.engines.blind.BlindVizResourceUtil;
import org.eclipse.actf.visualization.engines.blind.eval.EvaluationResultBlind;
import org.eclipse.actf.visualization.engines.blind.eval.PageEvaluation;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.IHighlightElementListener;
import org.eclipse.actf.visualization.engines.blind.html.util.VisualizeReportUtil;
import org.eclipse.actf.visualization.eval.IEvaluationResult;
import org.eclipse.actf.visualization.eval.html.statistics.PageData;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetId;
import org.eclipse.actf.visualization.eval.problem.IProblemItemVisitor;
import org.eclipse.actf.visualization.eval.problem.ReportUtil;
import org.eclipse.actf.visualization.ui.IVisualizationView;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartControlBlind
implements IHighlightElementListener {
    private static final String ABOUT_BLANK = "about:blank";
    public static final String BLIND_REPORT_FILE = "report.htm";
    private IBlindVisualizer[] blindVizualizers = BlindVisualizerExtension.getVisualizers();
    private BlindVisualizationBrowser _blindBrowser;
    private boolean _canSave = false;
    private PageData _pageData;
    private String maxReachingTimeS = "";
    private PageEvaluation _pageEval;
    private Document resultDoc;
    private Shell _shell;
    private String targetUrl;
    private Mediator mediator = Mediator.getInstance();
    private IVisualizationView vizView;
    private IEvaluationResult checkResult = new EvaluationResultBlind();
    private HashMap<String, WaitExecSyncEventListener> eventhandlerHolder = new HashMap();
    private static final String LISTENER_KEY = "browser";

    public PartControlBlind(IVisualizationView vizView, Composite parent) {
        this.vizView = vizView;
        this._shell = parent.getShell();
        this._blindBrowser = new BlindVisualizationBrowser(parent);
        this._blindBrowser.setBrowserSilent();
    }

    public void doSave(boolean withReport) {
        String saveFile = DialogSave.open((Shell)this._shell, (int)4, (String)this.targetUrl, (String)".csv");
        if (saveFile != null) {
            IEvaluationResult result = (IEvaluationResult)Mediator.getInstance().getReport((IACTFReportGenerator)this.vizView);
            if (result != null) {
                try {
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(saveFile)), "Shift_JIS");
                    PrintWriter reportPW = new PrintWriter(osw);
                    ReportUtil reportUtil = new ReportUtil();
                    reportUtil.setPrintWriter(reportPW);
                    reportUtil.writeFirstLine();
                    result.accept((IProblemItemVisitor)reportUtil);
                    reportPW.flush();
                    reportPW.close();
                }
                catch (Exception exception) {}
            }
            if (withReport) {
                if (this.resultDoc == null || saveFile == null) {
                    return;
                }
                if (saveFile.toLowerCase().endsWith(".csv")) {
                    saveFile = saveFile.substring(0, saveFile.length() - 3);
                }
                saveFile = saveFile.concat(".html");
                String imageBriefDir = String.valueOf(saveFile.substring(saveFile.lastIndexOf("\\") + 1, saveFile.lastIndexOf("."))) + "/";
                imageBriefDir = imageBriefDir.replace(' ', '_');
                this.saveReportFile(saveFile, imageBriefDir, true);
            }
        }
    }

    public int doVisualize() {
        return this.doVisualize(true);
    }

    public int doVisualize(boolean isShowResult) {
        IModelService modelService = ModelServiceUtils.getActiveModelService();
        int ret = -1;
        if (modelService == null) {
            IEditorPart editor = ModelServiceUtils.reopenInACTFBrowser();
            if (editor instanceof IModelServiceHolder) {
                modelService = ((IModelServiceHolder)editor).getModelService();
                WaitForBrowserReadyHandler handler = new WaitForBrowserReadyHandler((IWebBrowserACTF)modelService, 30.0, false, new Runnable(){

                    public void run() {
                        PartControlBlind.this.eventhandlerHolder.remove(PartControlBlind.LISTENER_KEY);
                        PartControlBlind.this.doVisualize();
                        PlatformUIUtil.showView((String)"org.eclipse.actf.visualization.blind.ui.views.BlindView");
                    }
                });
                this.eventhandlerHolder.put(LISTENER_KEY, new WaitExecSyncEventListener((WaitExecSyncEventHandler)handler));
                ret = 0;
                return 0;
            }
            return ret;
        }
        String resultFilePath = "";
        this.targetUrl = modelService.getURL();
        this.maxReachingTimeS = "";
        this.checkResult = new EvaluationResultBlind();
        this.mediator.setReport((IACTFReportGenerator)this.vizView, (IACTFReport)this.checkResult);
        this._blindBrowser.navigate(ABOUT_BLANK);
        this._canSave = false;
        this.vizView.setStatusMessage(Messages.BlindView_Now_preparing);
        IBlindVisualizer[] iBlindVisualizerArray = this.blindVizualizers;
        int n = this.blindVizualizers.length;
        int n2 = 0;
        while (n2 < n) {
            IBlindVisualizer bvh = iBlindVisualizerArray[n2];
            if (bvh.setModelService(modelService)) {
                bvh.setVisualizationView(this.vizView);
                ret = bvh.visualize();
                this._pageData = bvh.getPageData();
                this.checkResult = bvh.getEvaluationResult();
                this.resultDoc = bvh.getResultDocument();
                this.maxReachingTimeS = bvh.getMaxReachingTime();
                resultFilePath = bvh.getResultFile().getAbsolutePath();
                if (ret > -1) {
                    this.vizView.setStatusMessage(Messages.BlindView_Now_rendering);
                    CreateReport cr = new CreateReport(this.checkResult, new File(BlindVizResourceUtil.getTempDirectory(), BLIND_REPORT_FILE));
                    if (isShowResult) {
                        this._blindBrowser.navigate(resultFilePath);
                        this._shell.getDisplay().asyncExec((Runnable)cr);
                    } else {
                        this._blindBrowser.navigate(ABOUT_BLANK);
                        this._shell.getDisplay().syncExec((Runnable)cr);
                    }
                    this._canSave = true;
                } else {
                    this.checkResult.setProblemList(new ArrayList());
                    this._blindBrowser.navigate(ABOUT_BLANK);
                    CreateReport cr = new CreateReport(this.checkResult);
                    this._shell.getDisplay().syncExec((Runnable)cr);
                }
                return ret;
            }
            ++n2;
        }
        System.out.println("not supported: " + modelService.getID() + " " + modelService.getCurrentMIMEType());
        return -1;
    }

    public void saveReportFile(String sFileName, String imageBriefDir, boolean bAccessory) {
        if (this._canSave) {
            this.vizView.setStatusMessage(Messages.BlindView_saving_file);
            SaveReportBlind.saveReport((Document)this.resultDoc.cloneNode(true), this.mediator.getReport((IACTFReportGenerator)this.vizView), sFileName, imageBriefDir, this.maxReachingTimeS, this._pageEval, bAccessory);
            this.vizView.setStatusMessage(Messages.BlindView_end_saving_file);
        }
    }

    private void execScript(String script) {
        this._blindBrowser.execScript(script);
    }

    public void clearHighlight() {
        this._blindBrowser.clearHighlight();
    }

    protected IEvaluationResult getCheckResult() {
        return this.checkResult;
    }

    public void highlight(List<HighlightTargetId> targetIdList) {
        if (targetIdList != null) {
            switch (targetIdList.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.execScript("setHighlight(" + targetIdList.get(0).getStartId() + "," + targetIdList.get(0).getEndId() + ");");
                    break;
                }
                default: {
                    Iterator<HighlightTargetId> ite = targetIdList.iterator();
                    StringBuffer strStart = new StringBuffer(512);
                    StringBuffer strEnd = new StringBuffer(512);
                    HighlightTargetId tmpId = ite.next();
                    strStart.append(tmpId.getStartId());
                    strEnd.append(tmpId.getEndId());
                    while (ite.hasNext()) {
                        tmpId = ite.next();
                        strStart.append("," + tmpId.getStartId());
                        strEnd.append("," + tmpId.getEndId());
                    }
                    String highlightScript = "setHighlight2(new Array(" + strStart.toString() + "), new Array(" + strEnd.toString() + "));";
                    this.execScript(highlightScript);
                }
            }
        }
    }

    public boolean isBrowserModeSupported(IModelServiceHolder msh) {
        if (msh != null) {
            IBlindVisualizer[] iBlindVisualizerArray = this.blindVizualizers;
            int n = this.blindVizualizers.length;
            int n2 = 0;
            while (n2 < n) {
                IBlindVisualizer bvh = iBlindVisualizerArray[n2];
                if (bvh.setModelService(msh.getModelService()) && bvh.getClass().getName().startsWith("org.eclipse.actf.visualization.blind.")) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private class CreateReport
    extends Thread {
        IEvaluationResult _checkResult;
        File targetFile;

        CreateReport(IEvaluationResult checkResult, File filePath) {
            this._checkResult = checkResult;
            this.targetFile = filePath;
        }

        CreateReport(IEvaluationResult checkResult) {
            this._checkResult = checkResult;
            this.targetFile = null;
        }

        public void run() {
            PartControlBlind.this._pageEval = new PageEvaluation(this._checkResult.getProblemList(), PartControlBlind.this._pageData);
            if (this.targetFile == null) {
                PartControlBlind.this.checkResult.setSummaryReportUrl(PartControlBlind.ABOUT_BLANK);
                PartControlBlind.this.checkResult.setSummaryReportText("");
            } else {
                VisualizeReportUtil.createReport((File)this.targetFile, (PageEvaluation)PartControlBlind.this._pageEval);
                this._checkResult.setSummaryReportUrl(this.targetFile.getAbsolutePath());
                this._checkResult.setSummaryReportText(PartControlBlind.this._pageEval.getSummary());
                this._checkResult.setLineStyleListener((LineStyleListener)PageEvaluation.getHighLightStringListener());
            }
            if (this._checkResult instanceof EvaluationResultBlind) {
                ((EvaluationResultBlind)this._checkResult).setPageEvaluation(PartControlBlind.this._pageEval);
            }
            PartControlBlind.this._shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PartControlBlind.this.mediator.setReport((IACTFReportGenerator)PartControlBlind.this.vizView, (IACTFReport)CreateReport.this._checkResult);
                    PartControlBlind.this.vizView.setStatusMessage(Messages.BlindView_Done);
                }
            });
        }
    }
}

