/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.flash.ui.properties;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.actf.accservice.swtbridge.MSAA;
import org.eclipse.actf.model.flash.ASAccInfo;
import org.eclipse.actf.model.flash.IASNode;
import org.eclipse.actf.model.flash.IFlashConst;
import org.eclipse.actf.visualization.gui.msaa.properties.AttributePropertySource;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class FlashNodePropertySource
implements IPropertySource,
IFlashConst {
    private static boolean DEBUG_MODE = false;
    private IASNode flashNode;
    public static final String PID_LOCATION = "Location";
    public static final String PID_TABINDEX = "tabIndex";
    private static final IPropertyDescriptor[] DESCRIPTORS = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"objectName", "objectName"), new PropertyDescriptor((Object)"type", "type"), new PropertyDescriptor((Object)"value", "value"), new PropertyDescriptor((Object)"target", "target"), new PropertyDescriptor((Object)"depth", "depth"), new PropertyDescriptor((Object)"currentFrame", "currentFrame"), new PropertyDescriptor((Object)"className", "className"), new PropertyDescriptor((Object)"text", "text"), new PropertyDescriptor((Object)"title", "title"), new PropertyDescriptor((Object)"Location", "Location"), new PropertyDescriptor((Object)"tabIndex", "tabIndex"), new PropertyDescriptor((Object)"accInfo", "accInfo"), new PropertyDescriptor((Object)"isUIComponent", "isUIComponent"), new PropertyDescriptor((Object)"isOpaqueObject", "isOpaqueObject"), new PropertyDescriptor((Object)"isInputable", "isInputable"), new PropertyDescriptor((Object)"WMode", "WMode")};

    public FlashNodePropertySource(IASNode flashNode) {
        this.flashNode = flashNode;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Set keySet;
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < DESCRIPTORS.length) {
            if (this.getPropertyValue(DESCRIPTORS[i].getId()) != null) {
                result.add(DESCRIPTORS[i]);
            }
            ++i;
        }
        if (DEBUG_MODE && (keySet = this.flashNode.getKeys()) != null) {
            for (String key : keySet) {
                result.add(new PropertyDescriptor((Object)key, "[" + key + "]"));
            }
        }
        return result.toArray(new IPropertyDescriptor[result.size()]);
    }

    public Object getPropertyValue(Object id) {
        String strValue = null;
        if ("objectName".equals(id)) {
            strValue = this.flashNode.getObjectName();
        } else if ("type".equals(id)) {
            strValue = this.flashNode.getType();
        } else if ("value".equals(id)) {
            strValue = this.flashNode.getValue();
        } else if ("target".equals(id)) {
            strValue = this.flashNode.getTarget();
        } else if ("className".equals(id)) {
            strValue = this.flashNode.getClassName();
        } else if ("text".equals(id)) {
            strValue = this.flashNode.getText(false);
        } else if ("title".equals(id)) {
            strValue = this.flashNode.getTitle();
        } else if (PID_LOCATION.equals(id)) {
            try {
                double x = this.flashNode.getX();
                double y = this.flashNode.getY();
                double w = this.flashNode.getWidth();
                double h = this.flashNode.getHeight();
                if (Double.NaN != x) {
                    strValue = String.valueOf(x) + ", " + y + ", " + (x + w) + ", " + (y + h) + " (width=" + w + ", height=" + h + ")";
                }
            }
            catch (Exception exception) {}
        } else if ("WMode".equals(id)) {
            if (this.flashNode.getParent() == null) {
                strValue = this.flashNode.getPlayer().getWMode();
            }
        } else if (PID_TABINDEX.equals(id)) {
            if (this.flashNode.getTabIndex() > -1) {
                strValue = String.valueOf(this.flashNode.getTabIndex());
            }
        } else if ("accInfo".equals(id)) {
            ASAccInfo accInfo = this.flashNode.getAccInfo();
            if (accInfo != null) {
                AttributePropertySource attrSource = new AttributePropertySource(null, accInfo.toString());
                Set accInfoSet = accInfo.getKeys();
                for (String keyName : accInfoSet) {
                    Object keyValue = accInfo.get(keyName);
                    if (keyValue instanceof Integer) {
                        int intValue = (Integer)keyValue;
                        if ("role".equals(keyName)) {
                            keyValue = MSAA.getRoleText((int)intValue);
                        } else if ("state".equals(keyName)) {
                            keyValue = MSAA.getStateText((int)intValue);
                        }
                    }
                    if (keyValue instanceof String && ((String)keyValue).length() == 0) continue;
                    attrSource.put((Object)keyName, keyValue);
                }
                return attrSource;
            }
        } else {
            Object obj = this.flashNode.getObject(id.toString());
            if (obj != null) {
                strValue = obj.toString();
            }
        }
        return strValue;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public static boolean isDebugMode() {
        return DEBUG_MODE;
    }

    public static void setDebugMode(boolean debug_mode) {
        DEBUG_MODE = debug_mode;
    }
}

