/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.engines.blind.BlindVizResourceUtil;
import org.eclipse.actf.visualization.engines.blind.html.VisualizeEngine;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacket;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacketCollection;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetId;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.engines.blind.html.BlindProblem;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.DocumentCleaner;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationNodeInfo;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeMapDataImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualizeViewUtil {
    private static final String SCRIPT = "script";
    private static final String NAME = "name";
    private static final String TITLE = "title";
    private static final String HREF = "href";
    private static final String IMG = "img";
    private static final String NULL_STRING = "";
    private static final String BODY = "body";
    private static final String STYLE = "style";
    private static final String ID = "id";
    private static final String DIV = "div";
    private static final String INPUT = "input";
    private static final String IMAGE = "image";
    private static final String TYPE = "type";
    private static final String ON_CLICK = "onClick";
    private static final String ALT = "alt";
    private static final String SRC = "src";

    public static File prepareActions(Document result, VisualizeMapDataImpl mapData, String baseUrl, boolean servletMode) {
        Map<Node, Node> linkMap = mapData.getIntraPageLinkMap();
        List<VisualizationNodeInfo> targetElementList = mapData.getNodeInfoList();
        NodeList bodyEl = result.getElementsByTagName(BODY);
        int i = 0;
        while (i < bodyEl.getLength()) {
            Element tmpE = (Element)bodyEl.item(i);
            DocumentCleaner.removeOnMouse(tmpE);
            DocumentCleaner.removeOnLoad(tmpE);
            ++i;
        }
        if (bodyEl.getLength() == 0) {
            Element tmpN = result.getDocumentElement();
            if (tmpN != null) {
                tmpN.appendChild(result.createElement(BODY));
            } else {
                DebugPrintUtil.devOrDebugPrintln((Object)"VisualizeViewUtil: no doc element");
                return null;
            }
        }
        Element div = result.createElement(DIV);
        div.setAttribute(STYLE, "position:absolute;pixelLeft= 10;pixelTop=10; color:red;font-size=12pt");
        div.setAttribute(ID, "test");
        Node tmpBody = bodyEl.item(0);
        tmpBody.insertBefore(div, tmpBody.getFirstChild());
        VisualizeViewUtil.insertLinkIcon(result, linkMap, baseUrl);
        VisualizeViewUtil.insertControlPane(result);
        bodyEl = result.getElementsByTagName("map");
        if (bodyEl != null) {
            int i2 = 0;
            while (i2 < bodyEl.getLength()) {
                Element x = (Element)bodyEl.item(i2);
                x.setAttribute(ON_CLICK, "cancelMapLink(event)");
                ++i2;
            }
        }
        return VisualizeViewUtil.createScriptFile(result, targetElementList, baseUrl, servletMode);
    }

    private static void insertLinkIcon(Document doc, Map<Node, Node> linkMap, String baseUrl) {
        Iterator<Node> it = linkMap.keySet().iterator();
        HashSet<String> alreadySet = new HashSet<String>();
        int id = 0;
        while (it.hasNext()) {
            Element lel = (Element)it.next();
            Element ael = (Element)linkMap.get(lel);
            Element imgel1 = doc.createElement(IMG);
            String href = lel.getAttribute(HREF).substring(1);
            imgel1.setAttribute(ALT, "Intra-page link: " + href);
            imgel1.setAttribute(TITLE, "Intra-page link: " + href);
            imgel1.setAttribute(SRC, String.valueOf(baseUrl) + "img/jump.gif");
            imgel1.setAttribute(NAME, "jump" + id);
            if (lel.hasChildNodes()) {
                lel.insertBefore(imgel1, lel.getFirstChild());
            } else {
                lel.appendChild(imgel1);
            }
            if (!alreadySet.contains(href)) {
                Element imgel2 = doc.createElement(IMG);
                imgel2.setAttribute(ALT, "Intra-page link destination: " + href);
                imgel2.setAttribute(TITLE, "Intra-page link destination: " + href);
                imgel2.setAttribute(SRC, String.valueOf(baseUrl) + "img/dest.gif");
                imgel2.setAttribute(NAME, href);
                if (ael.hasChildNodes()) {
                    ael.insertBefore(imgel2, ael.getFirstChild());
                } else {
                    ael.appendChild(imgel2);
                }
                alreadySet.add(href);
            }
            ++id;
        }
    }

    private static void insertControlPane(Document result) {
        NodeList bodyEl = result.getElementsByTagName(BODY);
        Element div = result.createElement(DIV);
        div.setAttribute(STYLE, "position:absolute;font-size: medium; background-color: #FFFFFF; border-color: #333333 #000000 #000000; padding-top: 5px; padding-right: 5px; padding-bottom: 5px; padding-left: 5px; border-style: solid; border-top-width: 1px; border-right-width: 1px; border-bottom-width: 1px; border-left-width: 1px");
        div.setAttribute(ID, "control_pane");
        Element input1 = result.createElement(INPUT);
        input1.setAttribute(TYPE, IMAGE);
        input1.setAttribute(SRC, "img/stop.gif");
        input1.setAttribute(ALT, "Stop/Move Balloon");
        input1.setAttribute(ON_CLICK, "control_moving()");
        div.appendChild(input1);
        Element input2 = result.createElement(INPUT);
        input2.setAttribute(TYPE, IMAGE);
        input2.setAttribute(SRC, "img/clear.gif");
        input2.setAttribute(ALT, "Clear Line");
        input2.setAttribute(ON_CLICK, "clean_Line()");
        Element input3 = result.createElement(INPUT);
        input3.setAttribute(TYPE, IMAGE);
        input3.setAttribute(SRC, "img/refresh.gif");
        input3.setAttribute(ALT, "Refresh Line");
        input3.setAttribute(ON_CLICK, "refresh_Jump()");
        Element input4 = result.createElement(INPUT);
        input4.setAttribute(TYPE, IMAGE);
        input4.setAttribute(SRC, "img/draw.gif");
        input4.setAttribute(ALT, "Draw All Line");
        input4.setAttribute(ON_CLICK, "draw_all_Line()");
        div.appendChild(input2);
        div.appendChild(input3);
        div.appendChild(input4);
        Node tmpBody = bodyEl.item(0);
        tmpBody.insertBefore(div, tmpBody.getFirstChild());
    }

    private static File createScriptFile(Document result, List<VisualizationNodeInfo> elementList, String baseUrl, boolean servletMode) {
        try {
            File valiantFile = BlindVizResourceUtil.createTempFile((String)"variant", (String)".js");
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(valiantFile), "UTF-8"));
            StringBuffer sb = new StringBuffer();
            sb.append("var id2time = new Array();");
            sb.append("var id2comment = new Array();");
            int size = elementList.size();
            int i = 0;
            while (i < size) {
                VisualizationNodeInfo curInfo = elementList.get(i);
                String comment = curInfo.getComment();
                StringBuffer comment_sb = new StringBuffer();
                int x = 0;
                while (x < comment.length()) {
                    if (comment.charAt(x) == '\"') {
                        comment_sb.append("\\");
                    }
                    if (comment.charAt(x) == '\'') {
                        comment_sb.append('\\');
                    }
                    comment_sb.append(comment.charAt(x));
                    ++x;
                }
                sb.append("id2time['id");
                sb.append(curInfo.getId());
                sb.append("']=");
                sb.append(curInfo.getTime());
                sb.append(";");
                sb.append("id2comment['id");
                sb.append(curInfo.getId());
                sb.append("']='");
                sb.append(comment_sb.toString());
                sb.append("';");
                ++i;
            }
            String tmpS = sb.toString().replaceAll("\n", NULL_STRING).replaceAll("\r", NULL_STRING);
            pw.write(tmpS);
            sb = new StringBuffer();
            sb.append("var baloonSwitch = 1; ");
            sb.append("var baseUrl = '" + baseUrl + "'; ");
            sb.append("var acc_imageDir = 'img/'; ");
            if (servletMode) {
                sb.append("var servletMode = true; ");
            } else {
                sb.append("var servletMode = false; ");
            }
            sb.append("var isAlert = true; ");
            pw.write(sb.toString());
            pw.flush();
            pw.close();
            NodeList nl = result.getElementsByTagName("head");
            if (nl.getLength() > 0) {
                Element el = (Element)nl.item(0);
                Element script = result.createElement(SCRIPT);
                script.setAttribute(SRC, String.valueOf(baseUrl) + valiantFile.getName());
                el.appendChild(script);
                Element script2 = result.createElement(SCRIPT);
                script2.setAttribute(SRC, String.valueOf(baseUrl) + "img/highlight.js");
                el.appendChild(script2);
            }
            Element div = result.createElement(DIV);
            div.setAttribute(STYLE, "position:absolute;font-size: medium; background-color: #FFFFFF; border-color: #333333 #000000 #000000; padding-top: 5px; padding-right: 5px; padding-bottom: 5px; padding-left: 5px; border-style: solid; border-top-width: 1px; border-right-width: 1px; border-bottom-width: 1px; border-left-width: 1px");
            div.setAttribute(ID, "balloon");
            Element messageDiv = result.createElement(DIV);
            messageDiv.setAttribute(ID, "message");
            messageDiv.appendChild(result.createTextNode(NULL_STRING));
            div.appendChild(messageDiv);
            NodeList bodyNl = result.getElementsByTagName(BODY);
            if (bodyNl.getLength() > 0) {
                Element bodyEl = (Element)bodyNl.item(0);
                bodyEl.insertBefore(div, bodyEl.getFirstChild());
            }
            return valiantFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void visualizeError(Document doc, List<IProblemItem> problems, VisualizeMapDataImpl mapData, String baseUrlS) {
        int size = problems.size();
        int i = 0;
        while (i < size) {
            BlindProblem prob = (BlindProblem)problems.get(i);
            Node node = prob.getTargetNodeInResultDoc();
            Integer idObj = mapData.getIdOfNode(node);
            int subType = prob.getSubType();
            switch (subType) {
                case 2: 
                case 6: 
                case 10: 
                case 12: {
                    break;
                }
                default: {
                    if (idObj == null) break;
                    int id = idObj;
                    prob.setNodeId(id);
                }
            }
            VisualizationNodeInfo info = mapData.getNodeInfo(node);
            if (info != null) {
                if (38 == prob.getSubType()) {
                    info.appendComment(prob.getDescription().replaceAll("&", "&amp;"));
                } else {
                    info.appendComment(prob.getDescription());
                }
            } else if (node != null && node.getNodeType() == 1) {
                try {
                    String id = ((Element)node).getAttribute(ID);
                    if (id.startsWith(ID)) {
                        id = id.substring(2);
                    }
                }
                catch (Exception exception) {}
            }
            switch (prob.getSubType()) {
                case 0: 
                case 4: 
                case 38: {
                    Element el = (Element)node;
                    Node replacement = mapData.getReplacement(el);
                    if (replacement != null) {
                        el = (Element)replacement;
                    }
                    Element img = VisualizeViewUtil.createErrorImageElement(node, prob, idObj, baseUrlS);
                    el.appendChild(img);
                    break;
                }
                case 9: {
                    int startId = -1;
                    int endId = -1;
                    try {
                        List<Node> nl = prob.getNodeList();
                        node = nl.get(1);
                        Integer endNodeId = mapData.getIdOfNode(node);
                        if (endNodeId != null) {
                            endId = endNodeId;
                        }
                    }
                    catch (NullPointerException npe) {
                        npe.printStackTrace();
                    }
                    if (idObj != null) {
                        startId = idObj;
                    } else if (endId > -1) {
                        startId = endId;
                    }
                    prob.setNodeId(startId);
                    prob.addNodeIds(new HighlightTargetId(startId, startId));
                    prob.addNodeIds(new HighlightTargetId(endId, endId));
                    break;
                }
                case 8: 
                case 14: 
                case 17: 
                case 18: 
                case 19: 
                case 25: 
                case 26: 
                case 35: {
                    Element element = (Element)node;
                    Element image = VisualizeViewUtil.createErrorImageElement(element, prob, idObj, baseUrlS);
                    element.appendChild(image);
                    break;
                }
                case 15: {
                    Element image2 = VisualizeViewUtil.createErrorImageElement(node, prob, idObj, baseUrlS);
                    if (node.getNodeType() == 1) {
                        node.appendChild(image2);
                        break;
                    }
                    node.getParentNode().insertBefore(image2, node);
                    break;
                }
                case 36: 
                case 37: {
                    Element image3 = VisualizeViewUtil.createErrorImageElement(node, prob, idObj, baseUrlS);
                    node.getParentNode().insertBefore(image3, node);
                }
            }
            ++i;
        }
    }

    private static Element createErrorImageElement(Node target, IProblemItem prob, Integer idObj, String baseUrlS) {
        Element img = target.getOwnerDocument().createElement(IMG);
        img.setAttribute(ALT, "error icon");
        if (38 == prob.getSubType()) {
            img.setAttribute(TITLE, prob.getDescription().replaceAll("&", "&amp;"));
        } else {
            img.setAttribute(TITLE, prob.getDescription());
        }
        img.setAttribute("onmouseover", "updateBaloon('id" + idObj + "');");
        img.setAttribute(SRC, String.valueOf(baseUrlS) + "img/" + VisualizeEngine.ERROR_ICON_NAME);
        return img;
    }

    public static Document returnTextView(Document result, IPacketCollection allPc, String baseUrl) {
        NodeList nl;
        NodeList bodyNl = result.getElementsByTagName(BODY);
        if (bodyNl.getLength() > 0) {
            Element bodyEl = (Element)bodyNl.item(0);
            NodeList nl2 = bodyEl.getChildNodes();
            int size = nl2.getLength();
            int i = size - 1;
            while (i >= 0) {
                bodyEl.removeChild(nl2.item(i));
                --i;
            }
            size = allPc.size();
            boolean brFlag = false;
            boolean insideLink = false;
            int i2 = 0;
            while (i2 < size) {
                String str;
                IPacket p = (IPacket)allPc.get(i2);
                if (p.getContext().isLinkTag()) {
                    insideLink = true;
                }
                if ((str = p.getText()) != null && !str.equals(NULL_STRING)) {
                    Element spanEl = result.createElement("span");
                    spanEl.appendChild(result.createTextNode(str));
                    bodyEl.appendChild(spanEl);
                    if (insideLink) {
                        spanEl.setAttribute(STYLE, "text-decoration: underline;");
                    }
                    brFlag = false;
                }
                if (p.getContext().isLineDelimiter() && !brFlag) {
                    Element br = result.createElement("br");
                    bodyEl.appendChild(br);
                    brFlag = true;
                }
                if (!p.getContext().isLinkTag()) {
                    insideLink = false;
                }
                ++i2;
            }
        }
        if ((nl = result.getElementsByTagName("head")).getLength() > 0) {
            Element el = (Element)nl.item(0);
            Element script = result.createElement(SCRIPT);
            script.setAttribute(SRC, String.valueOf(baseUrl) + "img/highlight-dummy.js");
            el.appendChild(script);
        }
        return result;
    }
}

