/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html.util;

import org.eclipse.actf.visualization.engines.voicebrowser.IPacket;
import org.w3c.dom.Node;

public class VisualizationNodeInfo {
    private int orgTotalWords;
    private int orgTotalLines;
    private int orgTime = 0;
    private int totalWords;
    private int totalLines;
    private int words;
    private int lines;
    private int id;
    private int packetId;
    private IPacket packet = null;
    private Node node = null;
    private boolean isHeading = false;
    private boolean tableHeader = false;
    private boolean isLabel = false;
    private boolean isIdRequiredInput = false;
    private boolean isSequence = false;
    private boolean isBlockElement = false;
    private boolean isInvisible = false;
    private int time = 0;
    private String comment = "";

    VisualizationNodeInfo() {
        this.totalWords = 0;
        this.totalLines = 0;
        this.words = 0;
        this.lines = 0;
        this.id = 0;
        this.packetId = 0;
        this.packet = null;
        this.node = null;
    }

    VisualizationNodeInfo(VisualizationNodeInfo info) {
        if (info != null) {
            this.totalWords = info.getTotalWords();
            this.totalLines = info.getTotalLines();
            this.words = info.getWords();
            this.lines = info.getLines();
            this.packet = info.getPacket();
            this.packetId = info.getPacketId();
            if (this.packet == null) {
                this.node = info.getNode();
            }
            this.comment = "";
            this.id = 0;
            if (this.packet == null) {
                // empty if block
            }
        } else {
            this.totalWords = 0;
            this.totalLines = 0;
            this.words = 0;
            this.lines = 0;
            this.id = 0;
            this.packetId = 0;
            this.packet = null;
            this.node = null;
            this.comment = "";
        }
    }

    public Node getNode() {
        if (this.packet != null) {
            return this.packet.getNode();
        }
        return this.node;
    }

    public int getTotalWords() {
        return this.totalWords;
    }

    public void setNode(Node node) {
        this.packet = null;
        this.node = node;
    }

    public void setTotalWords(int totalWords) {
        this.totalWords = totalWords;
    }

    public int getLines() {
        return this.lines;
    }

    public int getTotalLines() {
        return this.totalLines;
    }

    public int getWords() {
        return this.words;
    }

    public void setLines(int lines) {
        this.lines = lines;
    }

    public void setTotalLines(int totalLines) {
        this.totalLines = totalLines;
    }

    public void setWords(int words) {
        this.words = words;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getPacketId() {
        return this.packetId;
    }

    public void setPacketId(int packetId) {
        this.packetId = packetId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" Info=");
        sb.append(String.valueOf(this.getTime()) + " : ");
        sb.append(this.getTotalWords());
        sb.append(",");
        sb.append(this.getWords());
        sb.append(",");
        sb.append(this.getTotalLines());
        sb.append(",");
        sb.append(this.getLines());
        sb.append(",");
        sb.append(this.getNode());
        return sb.toString();
    }

    public IPacket getPacket() {
        return this.packet;
    }

    public void setPacket(IPacket packet) {
        this.packet = packet;
    }

    public boolean isHeading() {
        return this.isHeading;
    }

    public void setHeading(boolean headingOrListitem) {
        this.isHeading = headingOrListitem;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public String getComment() {
        return this.comment;
    }

    public void appendComment(String string) {
        this.comment = this.comment.length() != 0 ? String.valueOf(this.comment) + " " + string : string;
    }

    public boolean isTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(boolean b) {
        this.tableHeader = b;
    }

    public boolean isLabel() {
        return this.isLabel;
    }

    public void setLabel(boolean b) {
        this.isLabel = b;
    }

    public boolean isIdRequiredInput() {
        return this.isIdRequiredInput;
    }

    public void setIdRequiredInput(boolean b) {
        this.isIdRequiredInput = b;
    }

    public void setAccesskey(boolean hasAccesskey) {
    }

    public boolean isSequence() {
        return this.isSequence;
    }

    public void setSequence(boolean b) {
        this.isSequence = b;
    }

    public boolean isBlockElement() {
        return this.isBlockElement;
    }

    public void setBlockElement(boolean b) {
        this.isBlockElement = b;
    }

    public boolean isInvisible() {
        return this.isInvisible;
    }

    public void setInvisible(boolean isInvisible) {
        this.isInvisible = isInvisible;
    }

    public int getOrgTime() {
        return this.orgTime;
    }

    public int getOrgTotalLines() {
        return this.orgTotalLines;
    }

    public int getOrgTotalWords() {
        return this.orgTotalWords;
    }

    public void setOrgTime(int orgTime) {
        this.orgTime = orgTime;
    }

    public void setOrgTotalLines(int orgTotalLines) {
        this.orgTotalLines = orgTotalLines;
    }

    public void setOrgTotalWords(int orgTotalWords) {
        this.orgTotalWords = orgTotalWords;
    }
}

