/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.actf.visualization.engines.blind.html.IVisualizeMapData;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.IElementViewerAccessKeyInfo;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.IElementViewerIdInfo;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.IElementViewerInfoProvider;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl.ElementInfoProviderExtension;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualizationAttributeInfo {
    String attributeName;
    String attributeValue;
    String tagName;
    String category = "";
    String helpUrl = "";
    String description = "";
    int nodeId;
    private static IElementViewerInfoProvider[] provider = ElementInfoProviderExtension.getProviders();

    VisualizationAttributeInfo(Element target, IVisualizeMapData mapData, String targetAttribute) {
        int i;
        this.attributeName = targetAttribute;
        this.tagName = target.getNodeName();
        this.attributeValue = target.getAttribute(targetAttribute);
        try {
            this.nodeId = mapData.getIdOfOrigNode(target);
        }
        catch (Exception exception) {
            this.nodeId = -1;
        }
        if (this.attributeName.equalsIgnoreCase("id")) {
            i = 0;
            while (i < provider.length) {
                IElementViewerIdInfo idInfo = provider[i].getIdInfo(this.attributeValue);
                if (idInfo != null) {
                    this.category = idInfo.getCategory();
                    this.helpUrl = idInfo.getHelpUrl();
                }
                ++i;
            }
        }
        if (this.attributeName.equalsIgnoreCase("accesskey")) {
            i = 0;
            while (i < provider.length) {
                IElementViewerAccessKeyInfo keyInfo = provider[i].getAccessKeyInfo(this.attributeValue);
                if (keyInfo != null) {
                    this.description = keyInfo.getDescription();
                    this.helpUrl = keyInfo.getHelpUrl();
                }
                ++i;
            }
            this.attributeValue = "Alt+ " + this.attributeValue;
        }
    }

    public String getAttribtueName() {
        return this.attributeName;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getHelpUrl() {
        return this.helpUrl;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return String.valueOf(this.tagName) + " : " + this.attributeValue + " : " + this.nodeId;
    }

    public static List<VisualizationAttributeInfo> listUp(Document target, IVisualizeMapData mapData, String targetAttribute) {
        ArrayList<VisualizationAttributeInfo> result = new ArrayList<VisualizationAttributeInfo>();
        NodeList bodyNl = target.getElementsByTagName("body");
        if (bodyNl.getLength() > 0) {
            Node tmpN = bodyNl.item(0);
            Stack<Node> stack = new Stack<Node>();
            while (tmpN != null) {
                Element currentE;
                if (tmpN.getNodeType() == 1 && (currentE = (Element)tmpN).hasAttribute(targetAttribute)) {
                    result.add(new VisualizationAttributeInfo(currentE, mapData, targetAttribute));
                }
                if (tmpN.hasChildNodes()) {
                    stack.push(tmpN);
                    tmpN = tmpN.getFirstChild();
                    continue;
                }
                if (tmpN.getNextSibling() != null) {
                    tmpN = tmpN.getNextSibling();
                    continue;
                }
                tmpN = null;
                while (tmpN == null && stack.size() > 0) {
                    tmpN = (Node)stack.pop();
                    tmpN = tmpN.getNextSibling();
                }
            }
        }
        return result;
    }
}

