/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.io;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionIOException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ImageUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.BMPWriter;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.IoUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.JPEGWriter;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.PBMWriter;

public class ImageWriter {
    public static void writeBufferedImage(BufferedImage _bi, String _fileName) throws LowVisionIOException {
        short type = IoUtil.getFileType(_fileName);
        if (type == 0) {
            throw new LowVisionIOException("Unknown image format.");
        }
        ImageWriter.writeBufferedImage(_bi, _fileName, type);
    }

    public static void writeBufferedImage(BufferedImage _bi, String _fileName, short _type) throws LowVisionIOException {
        if (_type == 1) {
            BMPWriter.writeBufferedImage(_bi, _fileName);
        } else if (_type == 2) {
            JPEGWriter.writeBufferedImage(_bi, _fileName);
        } else if (_type == 5) {
            File outFile = new File(_fileName);
            boolean result = true;
            try {
                result = ImageIO.write((RenderedImage)_bi, "GIF", outFile);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new LowVisionIOException("An error occurs while writing a GIF image.");
            }
            if (!result) {
                throw new LowVisionIOException("No appropriate writer is found while writing a GIF image.");
            }
        } else if (_type == 6) {
            File outFile = new File(_fileName);
            boolean result = true;
            try {
                result = ImageIO.write((RenderedImage)_bi, "PNG", outFile);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new LowVisionIOException("An error occurs while writing a PNG image.");
            }
            if (!result) {
                throw new LowVisionIOException("No appropriate writer is found while writing a PNG image.");
            }
        } else {
            throw new LowVisionIOException("Unknown image format.");
        }
    }

    public static void writeInt2D(Int2D _i2d, String _fileName) throws LowVisionIOException {
        ImageWriter.writeBufferedImage(ImageUtil.int2DToBufferedImage(_i2d), _fileName);
    }

    public static void writeInt2D(Int2D _i2d, String _fileName, short _type) throws LowVisionIOException {
        ImageWriter.writeBufferedImage(ImageUtil.int2DToBufferedImage(_i2d), _fileName, _type);
    }

    public static void writeBinaryImage(BinaryImage _bi, String _fileName) throws LowVisionIOException {
        short type = IoUtil.getFileType(_fileName);
        if (type == 0) {
            throw new LowVisionIOException("Unknown image format.");
        }
        ImageWriter.writeBinaryImage(_bi, _fileName, type);
    }

    public static void writeBinaryImage(BinaryImage _bi, String _fileName, short _type) throws LowVisionIOException {
        if (_type != 3) {
            throw new LowVisionIOException("Unknown image format.");
        }
        PBMWriter.writeBinaryImage(_bi, _fileName);
    }
}

