/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.io;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionIOException;
import org.eclipse.actf.visualization.internal.engines.lowvision.DebugUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.DosUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;

public class BMPReader {
    public static Int2D readInt2D(String _fileName) throws LowVisionIOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(_fileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new LowVisionIOException("The file was not found: " + _fileName);
        }
        return BMPReader.readInt2D(fis);
    }

    public static BufferedImage readBufferedImage(String _fileName) throws LowVisionIOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(_fileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new LowVisionIOException("The file was not found: " + _fileName);
        }
        return BMPReader.readBufferedImage(fis);
    }

    public static int getBitCount(String _fileName) throws LowVisionIOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(_fileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new LowVisionIOException("The file was not found: " + _fileName);
        }
        return BMPReader.getBitCount(fis);
    }

    public static int getBitCount(InputStream _is) throws LowVisionIOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(_is));
        try {
            byte magic1 = dis.readByte();
            byte magic2 = dis.readByte();
            if (magic1 != 66 || magic2 != 77) {
                throw new LowVisionIOException("Bad magic characters: " + magic1 + " and " + magic2);
            }
            DosUtil.upsideDownInt(dis.readInt());
            dis.skipBytes(4);
            DosUtil.upsideDownInt(dis.readInt());
            DosUtil.upsideDownInt(dis.readInt());
            DosUtil.upsideDownInt(dis.readInt());
            DosUtil.upsideDownInt(dis.readInt());
            dis.skipBytes(2);
            short bitCount = DosUtil.upsideDownShort(dis.readShort());
            if (bitCount != 8 && bitCount != 16 && bitCount != 24 && bitCount != 32) {
                throw new LowVisionIOException("Current version processes 8-bit/16-bit/24-bit/32-bit images only. The image's bitcount = " + bitCount);
            }
            return bitCount;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LowVisionIOException("IO error occurred when reading the header.");
        }
    }

    public static BufferedImage readBufferedImage(InputStream _is) throws LowVisionIOException {
        int linePadding;
        short bitCount;
        int imageHeight;
        int imageWidth;
        DataInputStream dis = new DataInputStream(new BufferedInputStream(_is));
        try {
            byte magic1 = dis.readByte();
            byte magic2 = dis.readByte();
            if (magic1 != 66 || magic2 != 77) {
                throw new LowVisionIOException("Bad magic characters: " + magic1 + " and " + magic2);
            }
            int fileSize = DosUtil.upsideDownInt(dis.readInt());
            dis.skipBytes(4);
            int offSet = DosUtil.upsideDownInt(dis.readInt());
            DosUtil.upsideDownInt(dis.readInt());
            imageWidth = DosUtil.upsideDownInt(dis.readInt());
            imageHeight = DosUtil.upsideDownInt(dis.readInt());
            dis.skipBytes(2);
            bitCount = DosUtil.upsideDownShort(dis.readShort());
            if (bitCount != 8 && bitCount != 16 && bitCount != 24 && bitCount != 32) {
                throw new LowVisionIOException("Current version processes 8-bit/16-bit/24-bit/32-bit images only. The image's bitcount = " + bitCount);
            }
            dis.skipBytes(4);
            DosUtil.upsideDownInt(dis.readInt());
            linePadding = 0;
            if (bitCount == 24) {
                int res = imageWidth * 3 % 4;
                if (res != 0) {
                    linePadding = 4 - res;
                }
            } else if (bitCount == 16 && imageWidth % 2 == 1) {
                linePadding = 2;
            }
            if (bitCount == 8 && imageWidth * imageHeight + offSet != fileSize) {
                DebugUtil.errMsg(null, "WARNING!!  Bad file size. imageWidth=" + imageWidth + ", linePadding=" + linePadding + ", imageHeight=" + imageHeight + ", offSet=" + offSet + ", fileSize=" + fileSize);
            }
            if (bitCount == 24 && (imageWidth * 3 + linePadding) * imageHeight + offSet != fileSize) {
                DebugUtil.errMsg(null, "WARNING!!  Bad file size. imageWidth=" + imageWidth + ", linePadding=" + linePadding + ", imageHeight=" + imageHeight + ", offSet=" + offSet + ", fileSize=" + fileSize);
            }
            if (bitCount == 32 && imageWidth * 4 * imageHeight + offSet != fileSize) {
                DebugUtil.errMsg(null, "WARNING!!  Bad file size. imageWidth=" + imageWidth + ", linePadding=" + linePadding + ", imageHeight=" + imageHeight + ", offSet=" + offSet + ", fileSize=" + fileSize);
            }
            dis.skipBytes(16);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LowVisionIOException("IO error occurred when reading the header.");
        }
        int[] colorTable = null;
        if (bitCount == 8) {
            try {
                byte[] byteTable = new byte[1024];
                int readNum = dis.read(byteTable);
                if (readNum != 1024) {
                    throw new LowVisionIOException("Amount of the image data is not enough.");
                }
                colorTable = new int[256];
                int k = 0;
                while (k < 256) {
                    byte b = byteTable[4 * k];
                    byte g = byteTable[4 * k + 1];
                    byte r = byteTable[4 * k + 2];
                    colorTable[k] = (r << 16) + (g << 8) + b;
                    ++k;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int bytesPerLine = 0;
        if (bitCount == 8) {
            bytesPerLine = imageWidth;
        } else if (bitCount == 16) {
            bytesPerLine = imageWidth * 2;
        } else if (bitCount == 24) {
            bytesPerLine = imageWidth * 3;
        } else if (bitCount == 32) {
            bytesPerLine = imageWidth * 4;
        }
        byte[][] srcArray = new byte[imageHeight][bytesPerLine];
        BufferedImage destImage = new BufferedImage(imageWidth, imageHeight, 1);
        WritableRaster destRaster = destImage.copyData(null);
        DataBufferInt destBufInt = (DataBufferInt)destRaster.getDataBuffer();
        int[] destArray = destBufInt.getData();
        try {
            int j;
            int j2 = 0;
            while (j2 < imageHeight) {
                int readNum = dis.read(srcArray[j2]);
                if (readNum != bytesPerLine) {
                    throw new LowVisionIOException("Amount of the image data is not enough.");
                }
                dis.skipBytes(linePadding);
                ++j2;
            }
            int destIndex = 0;
            if (bitCount == 8) {
                j = imageHeight - 1;
                while (j >= 0) {
                    int i = 0;
                    while (i < imageWidth) {
                        destArray[destIndex] = colorTable[srcArray[j][i]];
                        ++destIndex;
                        ++i;
                    }
                    --j;
                }
            } else if (bitCount == 16) {
                j = imageHeight - 1;
                while (j >= 0) {
                    int i = 0;
                    while (i < imageWidth) {
                        int pixel;
                        int i16 = srcArray[j][i * 2 + 1] << 8 | srcArray[j][i * 2] & 0xFF;
                        int b = i16 & 0x1F;
                        int g = i16 >> 5 & 0x1F;
                        int r = i16 >> 10 & 0x1F;
                        destArray[destIndex] = pixel = r << 19 | g << 11 | b << 3;
                        ++destIndex;
                        ++i;
                    }
                    --j;
                }
            } else if (bitCount == 24) {
                j = imageHeight - 1;
                while (j >= 0) {
                    int i = 0;
                    while (i < imageWidth) {
                        int pixel = 0;
                        pixel |= srcArray[j][i * 3] & 0xFF;
                        pixel |= (srcArray[j][i * 3 + 1] & 0xFF) << 8;
                        destArray[destIndex] = pixel |= (srcArray[j][i * 3 + 2] & 0xFF) << 16;
                        ++destIndex;
                        ++i;
                    }
                    --j;
                }
            } else if (bitCount == 32) {
                j = imageHeight - 1;
                while (j >= 0) {
                    int i = 0;
                    while (i < imageWidth) {
                        int pixel = 0;
                        pixel |= srcArray[j][i * 4] & 0xFF;
                        pixel |= (srcArray[j][i * 4 + 1] & 0xFF) << 8;
                        destArray[destIndex] = pixel |= (srcArray[j][i * 4 + 2] & 0xFF) << 16;
                        ++destIndex;
                        ++i;
                    }
                    --j;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LowVisionIOException("IO error occurred when reading the image data.");
        }
        srcArray = null;
        destImage.setData(destRaster);
        try {
            dis.close();
            _is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LowVisionIOException("IO error occurred when closing the input streams.");
        }
        return destImage;
    }

    public static Int2D readInt2D(InputStream _is) throws LowVisionIOException {
        int linePadding;
        short bitCount;
        int imageHeight;
        int imageWidth;
        DataInputStream dis = new DataInputStream(new BufferedInputStream(_is));
        try {
            byte magic1 = dis.readByte();
            byte magic2 = dis.readByte();
            if (magic1 != 66 || magic2 != 77) {
                throw new LowVisionIOException("Bad magic characters: " + magic1 + " and " + magic2);
            }
            int fileSize = DosUtil.upsideDownInt(dis.readInt());
            dis.skipBytes(4);
            int offSet = DosUtil.upsideDownInt(dis.readInt());
            DosUtil.upsideDownInt(dis.readInt());
            imageWidth = DosUtil.upsideDownInt(dis.readInt());
            imageHeight = DosUtil.upsideDownInt(dis.readInt());
            dis.skipBytes(2);
            bitCount = DosUtil.upsideDownShort(dis.readShort());
            if (bitCount != 8 && bitCount != 16 && bitCount != 24 && bitCount != 32) {
                throw new LowVisionIOException("Current version processes 8-bit/24-bit/32-bit images only. The image's bitcount = " + bitCount);
            }
            dis.skipBytes(4);
            DosUtil.upsideDownInt(dis.readInt());
            linePadding = 0;
            if (bitCount == 24) {
                int res = imageWidth * 3 % 4;
                if (res != 0) {
                    linePadding = 4 - res;
                }
            } else if (bitCount == 16 && imageWidth % 2 == 1) {
                linePadding = 2;
            }
            if (bitCount == 8 && imageWidth * imageHeight + offSet != fileSize) {
                DebugUtil.errMsg(null, "WARNING!!  Bad file size. imageWidth=" + imageWidth + ", linePadding=" + linePadding + ", imageHeight=" + imageHeight + ", offSet=" + offSet + ", fileSize=" + fileSize);
            }
            if (bitCount == 24 && (imageWidth * 3 + linePadding) * imageHeight + offSet != fileSize) {
                DebugUtil.errMsg(null, "WARNING!!  Bad file size. imageWidth=" + imageWidth + ", linePadding=" + linePadding + ", imageHeight=" + imageHeight + ", offSet=" + offSet + ", fileSize=" + fileSize);
            }
            if (bitCount == 32 && imageWidth * 4 * imageHeight + offSet != fileSize) {
                DebugUtil.errMsg(null, "WARNING!!  Bad file size. imageWidth=" + imageWidth + ", linePadding=" + linePadding + ", imageHeight=" + imageHeight + ", offSet=" + offSet + ", fileSize=" + fileSize);
            }
            dis.skipBytes(16);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LowVisionIOException("IO error occurred when reading the header.");
        }
        int[] colorTable = null;
        if (bitCount == 8) {
            try {
                byte[] byteTable = new byte[1024];
                int readNum = dis.read(byteTable);
                if (readNum != 1024) {
                    throw new LowVisionIOException("Amount of the image data is not enough.");
                }
                colorTable = new int[256];
                int k = 0;
                while (k < 256) {
                    byte b = byteTable[4 * k];
                    byte g = byteTable[4 * k + 1];
                    byte r = byteTable[4 * k + 2];
                    colorTable[k] = (r << 16) + (g << 8) + b;
                    ++k;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int bytesPerLine = 0;
        if (bitCount == 8) {
            bytesPerLine = imageWidth;
        } else if (bitCount == 16) {
            bytesPerLine = imageWidth * 2;
        } else if (bitCount == 24) {
            bytesPerLine = imageWidth * 3;
        } else if (bitCount == 32) {
            bytesPerLine = imageWidth * 4;
        }
        byte[][] srcArray = new byte[imageHeight][bytesPerLine];
        Int2D destImage = new Int2D(imageWidth, imageHeight);
        try {
            int pixel;
            int i;
            int j = 0;
            while (j < imageHeight) {
                int readNum = dis.read(srcArray[j]);
                if (readNum != bytesPerLine) {
                    throw new LowVisionIOException("Amount of the image data is not enough.");
                }
                dis.skipBytes(linePadding);
                ++j;
            }
            if (bitCount == 8) {
                j = imageHeight - 1;
                while (j >= 0) {
                    i = 0;
                    while (i < imageWidth) {
                        destImage.getData()[imageHeight - j - 1][i] = colorTable[srcArray[j][i]];
                        ++i;
                    }
                    --j;
                }
            } else if (bitCount == 16) {
                j = imageHeight - 1;
                while (j >= 0) {
                    i = 0;
                    while (i < imageWidth) {
                        int pixel2;
                        int i16 = srcArray[j][i * 2 + 1] << 8 | srcArray[j][i * 2] & 0xFF;
                        int b = i16 & 0x1F;
                        int g = i16 >> 5 & 0x1F;
                        int r = i16 >> 10 & 0x1F;
                        destImage.getData()[imageHeight - j - 1][i] = pixel2 = r << 19 | g << 11 | b << 3;
                        ++i;
                    }
                    --j;
                }
            } else if (bitCount == 24) {
                j = imageHeight - 1;
                while (j >= 0) {
                    i = 0;
                    while (i < imageWidth) {
                        pixel = 0;
                        pixel |= srcArray[j][i * 3] & 0xFF;
                        pixel |= (srcArray[j][i * 3 + 1] & 0xFF) << 8;
                        destImage.getData()[imageHeight - j - 1][i] = pixel |= (srcArray[j][i * 3 + 2] & 0xFF) << 16;
                        ++i;
                    }
                    --j;
                }
            } else if (bitCount == 32) {
                j = imageHeight - 1;
                while (j >= 0) {
                    i = 0;
                    while (i < imageWidth) {
                        pixel = 0;
                        pixel |= srcArray[j][i * 4] & 0xFF;
                        pixel |= (srcArray[j][i * 4 + 1] & 0xFF) << 8;
                        destImage.getData()[imageHeight - j - 1][i] = pixel |= (srcArray[j][i * 4 + 2] & 0xFF) << 16;
                        ++i;
                    }
                    --j;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LowVisionIOException("IO error occurred when reading the image data.");
        }
        srcArray = null;
        try {
            dis.close();
            _is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LowVisionIOException("IO error occurred when closing the input streams.");
        }
        return destImage;
    }
}

