/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Coord;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Neighbor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Topology {
    static final short TYPE_INTERIOR = 0;
    static final short TYPE_EDGE = 1;
    static final short TYPE_CONNECTED = 2;
    static final short TYPE_BRANCHING = 3;
    static final short TYPE_CROSSING = 4;
    ConnectedComponent component;
    int width;
    int height;
    int numNodes = 0;
    Node[] nodes = null;
    int numInterior = 0;
    int numEdges = 0;
    int numBranches = 0;
    int numCrosses = 0;
    int[][] distance = null;
    int count = 0;

    public Topology(ConnectedComponent _cc) throws ImageException {
        this(_cc, false);
    }

    public Topology(ConnectedComponent _cc, boolean _calcDistance) throws ImageException {
        int cn;
        Neighbor nei;
        this.component = _cc;
        this.width = this.component.shape.width;
        this.height = this.component.shape.height;
        BinaryImage bi = this.component.shape;
        Vector<Node> tmpNodes = new Vector<Node>();
        int topPosition = -1;
        int bottomPosition = -1;
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                if (bi.data[j][i] != 0) {
                    Node n;
                    ++this.count;
                    if (topPosition == -1) {
                        topPosition = j;
                    }
                    bottomPosition = j;
                    Neighbor nei2 = new Neighbor(bi, i, j);
                    int cn2 = nei2.crossingNumber();
                    if (cn2 == 1) {
                        ++this.numNodes;
                        ++this.numEdges;
                        n = new Node(i, j, 1);
                        tmpNodes.addElement(n);
                    } else if (cn2 == 3) {
                        ++this.numNodes;
                        ++this.numBranches;
                        n = new Node(i, j, 3);
                        tmpNodes.addElement(n);
                    } else if (cn2 == 4) {
                        ++this.numNodes;
                        ++this.numCrosses;
                        n = new Node(i, j, 4);
                        tmpNodes.addElement(n);
                    } else if (cn2 == 0) {
                        ++this.numNodes;
                        ++this.numInterior;
                        n = new Node(i, j, 0);
                        tmpNodes.addElement(n);
                    }
                }
                ++i;
            }
            ++j;
        }
        if (topPosition == -1) {
            return;
        }
        boolean existTop = false;
        boolean existBottom = false;
        int i = 0;
        while (i < this.numNodes) {
            Node n = (Node)tmpNodes.elementAt(i);
            if (n.y == topPosition) {
                existTop = true;
            }
            if (n.y == bottomPosition) {
                existBottom = true;
            }
            ++i;
        }
        Node topNode = null;
        Node bottomNode = null;
        if (!existTop) {
            int i2 = 0;
            while (i2 < this.width) {
                if (bi.data[topPosition][i2] != 0) {
                    nei = new Neighbor(bi, i2, topPosition);
                    cn = nei.crossingNumber();
                    if (cn == 2) {
                        ++this.numNodes;
                        topNode = new Node(i2, topPosition, 2);
                        break;
                    }
                    throw new ImageException("Unknown type");
                }
                ++i2;
            }
        }
        if (!existBottom) {
            int i3 = this.width - 1;
            while (i3 >= 0) {
                if (bi.data[bottomPosition][i3] != 0) {
                    nei = new Neighbor(bi, i3, bottomPosition);
                    cn = nei.crossingNumber();
                    if (cn == 2) {
                        ++this.numNodes;
                        bottomNode = new Node(i3, bottomPosition, 2);
                        break;
                    }
                    throw new ImageException("Unknown type");
                }
                --i3;
            }
        }
        this.nodes = new Node[this.numNodes];
        int offset = 0;
        if (topNode != null) {
            this.nodes[0] = topNode;
            offset = 1;
        }
        int i4 = 0;
        while (i4 < tmpNodes.size()) {
            this.nodes[i4 + offset] = (Node)tmpNodes.elementAt(i4);
            ++i4;
        }
        if (bottomNode != null) {
            this.nodes[this.numNodes - 1] = bottomNode;
        }
        if (_calcDistance) {
            this.distance = new int[this.numNodes][this.numNodes];
            i4 = 0;
            while (i4 < this.numNodes - 1) {
                int[][] map = this.getDistanceMap(new Coord(this.nodes[i4].x, this.nodes[i4].y));
                int j2 = i4 + 1;
                while (j2 < this.numNodes) {
                    this.distance[i4][j2] = map[this.nodes[j2].y][this.nodes[j2].x];
                    this.distance[j2][i4] = this.distance[i4][j2];
                    ++j2;
                }
                ++i4;
            }
        }
    }

    public static boolean match(Topology _t1, Topology _t2) {
        if (_t1.numInterior != _t2.numInterior) {
            return false;
        }
        if (_t1.numEdges != _t2.numEdges) {
            return false;
        }
        if (_t1.numBranches != _t2.numBranches) {
            return false;
        }
        return _t1.numCrosses == _t2.numCrosses;
    }

    public boolean match(Topology _t) {
        return Topology.match(this, _t);
    }

    private int[][] getDistanceMap(Coord _co) {
        int[][] map = new int[this.height][this.width];
        BinaryImage bi = this.component.shape;
        Vector<Coord> currentNodes = null;
        Vector<Coord> nextNodes = new Vector<Coord>();
        nextNodes.addElement(_co);
        int currentDistance = 1;
        int size = nextNodes.size();
        while (size > 0) {
            currentNodes = nextNodes;
            nextNodes = new Vector();
            int i = 0;
            while (i < size) {
                Coord co = (Coord)currentNodes.elementAt(i);
                int x = co.x;
                int y = co.y;
                if (x > 0 && bi.data[y][x - 1] != 0) {
                    this.checkAndSetDistance(x - 1, y, map, currentDistance, nextNodes);
                }
                if (y > 0 && bi.data[y - 1][x] != 0) {
                    this.checkAndSetDistance(x, y - 1, map, currentDistance, nextNodes);
                }
                if (x < this.width - 1 && bi.data[y][x + 1] != 0) {
                    this.checkAndSetDistance(x + 1, y, map, currentDistance, nextNodes);
                }
                if (y < this.height - 1 && bi.data[y + 1][x] != 0) {
                    this.checkAndSetDistance(x, y + 1, map, currentDistance, nextNodes);
                }
                if (x > 0 && y > 0 && bi.data[y - 1][x - 1] != 0) {
                    this.checkAndSetDistance(x - 1, y - 1, map, currentDistance, nextNodes);
                }
                if (x < this.width - 1 && y > 0 && bi.data[y - 1][x + 1] != 0) {
                    this.checkAndSetDistance(x + 1, y - 1, map, currentDistance, nextNodes);
                }
                if (x > 0 && y < this.height - 1 && bi.data[y + 1][x - 1] != 0) {
                    this.checkAndSetDistance(x - 1, y + 1, map, currentDistance, nextNodes);
                }
                if (x < this.width - 1 && y < this.height - 1 && bi.data[y + 1][x + 1] != 0) {
                    this.checkAndSetDistance(x + 1, y + 1, map, currentDistance, nextNodes);
                }
                ++i;
            }
            size = nextNodes.size();
            ++currentDistance;
        }
        return map;
    }

    private void checkAndSetDistance(int _x, int _y, int[][] _map, int _distance, Vector<Coord> _next) {
        if (_map[_y][_x] == 0) {
            _map[_y][_x] = _distance;
            _next.addElement(new Coord(_x, _y));
        }
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public int getNumInterior() {
        return this.numInterior;
    }

    public int getNumEdges() {
        return this.numEdges;
    }

    public int getNumBranches() {
        return this.numBranches;
    }

    public int getNumCrosses() {
        return this.numCrosses;
    }

    public int getCount() {
        return this.count;
    }

    public void showNodes(PrintStream _ps) {
        PrintWriter pw = new PrintWriter(_ps, true);
        this.showNodes(pw);
    }

    public void showNodes(PrintWriter _pw) {
        _pw.println("-------------------------------");
        _pw.println("Dumping nodes");
        char[][] cimage = new char[this.height][this.width];
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                cimage[j][i] = this.component.shape.data[j][i] != 0 ? 35 : 46;
                ++i;
            }
            ++j;
        }
        int i = 0;
        while (i < this.numNodes) {
            Node n = this.nodes[i];
            if (n.type == 1) {
                cimage[n.y][n.x] = 49;
            } else if (n.type == 2) {
                cimage[n.y][n.x] = 50;
            } else if (n.type == 3) {
                cimage[n.y][n.x] = 51;
            } else if (n.type == 4) {
                cimage[n.y][n.x] = 52;
            } else if (n.type == 0) {
                cimage[n.y][n.x] = 48;
            }
            ++i;
        }
        j = 0;
        while (j < this.height) {
            _pw.println(new String(cimage[j]));
            ++j;
        }
        _pw.println("-------------------------------");
    }

    public void showDistances(PrintStream _ps) {
        if (this.distance == null) {
            return;
        }
        PrintWriter pw = new PrintWriter(_ps, true);
        this.showDistances(pw);
    }

    public void showDistances(PrintWriter _pw) {
        if (this.distance == null) {
            return;
        }
        _pw.println("-------------------------------");
        _pw.println("Showing distances");
        StringBuffer top = new StringBuffer();
        top.append("    ");
        StringBuffer bar = new StringBuffer();
        bar.append("----");
        int i = 0;
        while (i < this.numNodes) {
            top.append("|" + this.numberFormat4(i));
            bar.append("+----");
            ++i;
        }
        _pw.println(top.toString());
        _pw.println(bar.toString());
        i = 0;
        while (i < this.numNodes) {
            StringBuffer sb = new StringBuffer();
            sb.append(String.valueOf(this.numberFormat4(i)) + "|");
            int j = 0;
            while (j < this.numNodes - 1) {
                sb.append(String.valueOf(this.numberFormat4(this.distance[i][j])) + "|");
                ++j;
            }
            sb.append(this.numberFormat4(this.distance[i][this.numNodes - 1]));
            _pw.println(sb.toString());
            ++i;
        }
        _pw.println("-------------------------------");
    }

    private String numberFormat4(int _i) {
        if (_i >= 0 && _i <= 9) {
            return "   " + _i;
        }
        if (10 <= _i && _i <= 99) {
            return "  " + _i;
        }
        if (100 <= _i && _i <= 999) {
            return " " + _i;
        }
        return "" + _i;
    }

    class Node {
        int x;
        int y;
        short type;

        public Node(int _x, int _y, short _type) {
            this.x = _x;
            this.y = _y;
            this.type = _type;
        }
    }
}

