/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.color;

import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorSRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorXYZ;

public class ColorYXY {
    private float YY;
    private float x;
    private float y;

    public ColorYXY() {
    }

    public ColorYXY(float _yy, float _x, float _y) throws ColorException {
        this(_yy, _x, _y, false);
    }

    public ColorYXY(float _yy, float _x, float _y, boolean _check) throws ColorException {
        this.setYY(_yy, _check);
        this.setX(_x, _check);
        this.setY(_y, _check);
    }

    public float getYY() {
        return this.YY;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setYY(float _yy) throws ColorException {
        this.setYY(_yy, false);
    }

    public void setYY(float _yy, boolean _check) throws ColorException {
        if (_yy < 0.0f) {
            if (_check) {
                throw new ColorException("Smaller than minimum.");
            }
            this.YY = 0.0f;
        } else if (1.0f < _yy) {
            if (_check) {
                throw new ColorException("Larger than maximum.");
            }
            this.YY = 1.0f;
        } else {
            this.YY = _yy;
        }
    }

    public void setX(float _x) throws ColorException {
        this.setX(_x, false);
    }

    public void setX(float _x, boolean _check) throws ColorException {
        if (_x < 0.0f) {
            if (_check) {
                throw new ColorException("Smaller than minimum.");
            }
            this.x = 0.0f;
        } else if (1.0f < _x) {
            if (_check) {
                throw new ColorException("Larger than maximum.");
            }
            this.x = 1.0f;
        } else {
            this.x = _x;
        }
    }

    public void setY(float _y) throws ColorException {
        this.setY(_y, false);
    }

    public void setY(float _y, boolean _check) throws ColorException {
        if (_y < 0.0f) {
            if (_check) {
                throw new ColorException("Smaller than minimum.");
            }
            this.y = 0.0f;
        } else if (1.0f < _y) {
            if (_check) {
                throw new ColorException("Larger than maximum.");
            }
            this.y = 1.0f;
        } else {
            this.y = _y;
        }
    }

    public ColorXYZ toXYZ() throws ColorException {
        return this.toXYZ(false);
    }

    public ColorXYZ toXYZ(boolean _check) throws ColorException {
        ColorXYZ xyz = new ColorXYZ();
        if (this.y == 0.0f) {
            xyz.setX(0.0f);
            xyz.setY(0.0f);
            xyz.setZ(0.0f);
        } else {
            xyz.setX(this.YY / this.y * this.x, _check);
            xyz.setY(this.YY, _check);
            xyz.setZ(this.YY / this.y * (1.0f - this.x - this.y), _check);
        }
        return xyz;
    }

    public ColorSRGB toSRGB() throws ColorException {
        return this.toSRGB(false);
    }

    public ColorSRGB toSRGB(boolean _check) throws ColorException {
        return this.toXYZ(_check).toSRGB(_check);
    }

    public ColorIRGB toIRGB() throws ColorException {
        return this.toIRGB(false);
    }

    public ColorIRGB toIRGB(boolean _check) throws ColorException {
        return this.toXYZ(_check).toSRGB(_check).toIRGB(_check);
    }
}

