/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.checker;

import org.eclipse.actf.visualization.internal.engines.lowvision.checker.ColorChecker;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;

public class W3CColorChecker
extends ColorChecker {
    private static final double THRESHOLD_Y = 125.0;
    private static final int THRESHOLD_C = 500;
    private double diffY;
    private int diffC;
    private double sevY;
    private double sevC;
    private double sevL;
    private double severity;
    private double contrastRatio;

    public W3CColorChecker(ColorIRGB _c1, ColorIRGB _c2) {
        super(_c1, _c2);
        int r1 = this.color1.getR();
        int g1 = this.color1.getG();
        int b1 = this.color1.getB();
        int r2 = this.color2.getR();
        int g2 = this.color2.getG();
        int b2 = this.color2.getB();
        double y1 = W3CColorChecker.calcY(r1, g1, b1);
        double y2 = W3CColorChecker.calcY(r2, g2, b2);
        double l1 = W3CColorChecker.calcL(r1, g1, b1);
        double l2 = W3CColorChecker.calcL(r2, g2, b2);
        this.contrastRatio = l1 > l2 ? (l1 + 0.05) / (l2 + 0.05) : (l2 + 0.05) / (l1 + 0.05);
        this.diffY = Math.abs(y1 - y2);
        this.diffC = Math.abs(r1 - r2) + Math.abs(g1 - g2) + Math.abs(b1 - b2);
        this.sevY = W3CColorChecker.calcSevY(this.diffY);
        this.sevC = W3CColorChecker.calcSevC(this.diffC);
        this.severity = this.sevL = W3CColorChecker.calcSevL(this.contrastRatio);
    }

    public W3CColorChecker(int _i1, int _i2) {
        this(new ColorIRGB(_i1), new ColorIRGB(_i2));
    }

    public double calcSeverity() {
        return this.severity;
    }

    public static double calcSeverity(ColorIRGB _c1, ColorIRGB _c2) {
        return new W3CColorChecker(_c1, _c2).calcSeverity();
    }

    public double calcLuminanceSeverity() {
        return this.sevY;
    }

    public static double calcLuminanceSeverity(ColorIRGB _c1, ColorIRGB _c2) {
        return new W3CColorChecker(_c1, _c2).calcLuminanceSeverity();
    }

    public double calcChrominanceSeverity() {
        return this.sevC;
    }

    public static double calcChrominanceSeverity(ColorIRGB _c1, ColorIRGB _c2) {
        return new W3CColorChecker(_c1, _c2).calcChrominanceSeverity();
    }

    public int calcLuminanceDifference() {
        int iDiff = (int)Math.round(this.diffY);
        if (iDiff < 0) {
            iDiff = 0;
        } else if (255 < iDiff) {
            iDiff = 255;
        }
        return iDiff;
    }

    public static int calcLuminanceDifference(ColorIRGB _c1, ColorIRGB _c2) {
        return new W3CColorChecker(_c1, _c2).calcLuminanceDifference();
    }

    public int calcChrominanceDifference() {
        return this.diffC;
    }

    public static int calcChrominanceDifference(ColorIRGB _c1, ColorIRGB _c2) {
        return new W3CColorChecker(_c1, _c2).calcChrominanceDifference();
    }

    private static double calcL(int _r, int _g, int _b) {
        return 0.2126 * W3CColorChecker.calcRGB(_r) + 0.7152 * W3CColorChecker.calcRGB(_g) + 0.0722 * W3CColorChecker.calcRGB(_b);
    }

    private static double calcY(int _r, int _g, int _b) {
        return (double)(_r * 299 + _g * 587 + _b * 114) / 1000.0;
    }

    private static double calcRGB(int rgb) {
        double tmp = (double)rgb / 255.0;
        if (tmp <= 0.03928) {
            return tmp / 12.92;
        }
        return Math.pow((tmp + 0.055) / 1.055, 2.4);
    }

    private static double calcSevY(double _diffY) {
        double sevY = 0.0;
        if (_diffY < 125.0) {
            sevY = -_diffY / 125.0 + 1.0;
        }
        if (sevY < 0.0) {
            sevY = 0.0;
        } else if (1.0 < sevY) {
            sevY = 1.0;
        }
        return sevY;
    }

    private static double calcSevC(int _diffC) {
        double sevC = 0.0;
        if (_diffC < 500) {
            sevC = -((double)_diffC) / 500.0 + 1.0;
        }
        if (sevC < 0.0) {
            sevC = 0.0;
        } else if (1.0 < sevC) {
            sevC = 1.0;
        }
        return sevC;
    }

    private static double calcSevL(double contrast) {
        double sevL = 0.0;
        if (contrast > 7.0) {
            return sevL;
        }
        if (contrast < 3.0) {
            return 1.0;
        }
        return 1.0 - (contrast - 3.0) / 4.0;
    }

    public double calcContrast() {
        return this.contrastRatio;
    }
}

