/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.character;

import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Container;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Topology;

public class CharacterMS
extends PageComponent {
    private int backgroundColor = -1;
    private int foregroundColor = -1;
    private Topology topology = null;
    private int[][] image = null;

    public CharacterMS(IPageImage _pi, ConnectedComponent _cc, Container _cont, int[][] _pixel) throws ImageException {
        super((short)5, _pi);
        this.cc = _cc;
        this.container = _cont;
        this.backgroundColor = _cont.getColor();
        this.topology = new Topology(this.cc.thinning());
        if (_pixel != null) {
            int w = this.cc.getShape().getWidth();
            int h = this.cc.getShape().getHeight();
            int offsetX = this.cc.getLeft();
            int offsetY = this.cc.getTop();
            this.image = new int[h][w];
            int sumR = 0;
            int sumG = 0;
            int sumB = 0;
            byte[][] data = this.cc.getShape().getData();
            int j = 0;
            while (j < h) {
                int i = 0;
                while (i < w) {
                    this.image[j][i] = _pixel[j + offsetY][i + offsetX];
                    if (data[j][i] != 0) {
                        int color = this.image[j][i];
                        sumR += color >> 16 & 0xFF;
                        sumG += color >> 8 & 0xFF;
                        sumB += color & 0xFF;
                    }
                    ++i;
                }
                ++j;
            }
            this.foregroundColor = (sumR /= this.cc.getCount()) << 16 | (sumG /= this.cc.getCount()) << 8 | (sumB /= this.cc.getCount());
        }
    }

    public CharacterMS(IPageImage _pi, ConnectedComponent _cc, Container _cont, IInt2D _pixel) throws ImageException {
        this(_pi, _cc, _cont, _pixel.getData());
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getForegroundColor() {
        return this.foregroundColor;
    }

    public IInt2D getInt2D() throws ImageException {
        return new Int2D(this.cc.getShape().getWidth(), this.cc.getShape().getHeight(), this.image);
    }

    public IInt2D makeMarginedImage(int _margin) throws ImageException {
        if (_margin == 0) {
            return this.getInt2D();
        }
        if (_margin < 0) {
            throw new ImageException("The margin must be non-negative.");
        }
        Int2D i2d = new Int2D(this.cc.getShape().getWidth() + 2 * _margin, this.cc.getShape().getHeight() + 2 * _margin);
        i2d.fill(this.backgroundColor);
        int j = 0;
        while (j < this.cc.getShape().getHeight()) {
            int i = 0;
            while (i < this.cc.getShape().getWidth()) {
                i2d.getData()[j + _margin][i + _margin] = this.image[j][i];
                ++i;
            }
            ++j;
        }
        return i2d;
    }

    public Topology getTopology() {
        return this.topology;
    }
}

