/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.lowvision.image;

import java.io.InputStream;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.SimulatedPageImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.BMPReader;

public class PageImageFactory {
    public static IPageImage createPageImage() {
        return new PageImage();
    }

    public static IPageImage createSimulationPageImage(IPageImage target, LowVisionType type) throws ImageException {
        return new SimulatedPageImage(target, type);
    }

    public static IPageImage createPageImage(String bmpFileName) {
        return PageImageFactory.createPageImage(bmpFileName, false);
    }

    public static IPageImage createPageImage(String bmpFileName, boolean removeScrollBar) {
        Int2D int2dWhole = new Int2D(0, 0);
        try {
            int2dWhole = BMPReader.readInt2D(bmpFileName);
            PageImage result = new PageImage(int2dWhole, removeScrollBar);
            int2dWhole = null;
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IPageImage createPageImage(InputStream is) {
        return PageImageFactory.createPageImage(is, false);
    }

    public static IPageImage createPageImage(InputStream is, boolean removeScrollBar) {
        Int2D int2dWhole = new Int2D(0, 0);
        try {
            int2dWhole = BMPReader.readInt2D(is);
            PageImage result = new PageImage(int2dWhole, removeScrollBar);
            int2dWhole = null;
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static synchronized IPageImage joinPageImages(IPageImage[] targets) {
        Int2D int2dWhole = new Int2D(0, 0);
        int iWholeWidth = 0;
        int iWholeHeight = 0;
        if (targets != null) {
            int i = 0;
            while (i < targets.length) {
                if (iWholeWidth < targets[i].getWidth()) {
                    iWholeWidth = targets[i].getWidth();
                }
                iWholeHeight += targets[i].getHeight();
                ++i;
            }
            int2dWhole = new Int2D(iWholeWidth, iWholeHeight);
            int iDrawY = 0;
            int i2 = 0;
            while (i2 < targets.length) {
                IInt2D tmpInt2d = ((PageImage)targets[i2]).getInt2D();
                int k = 0;
                while (k < tmpInt2d.getHeight()) {
                    System.arraycopy(tmpInt2d.getData()[k], 0, int2dWhole.getData()[iDrawY + k], 0, tmpInt2d.getWidth());
                    ++k;
                }
                iDrawY += tmpInt2d.getHeight();
                ++i2;
            }
        }
        return new PageImage(int2dWhole);
    }
}

