/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editors.ooo;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.model.dom.odf.ODFParser;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.util.converter.ODFConverter;
import org.eclipse.actf.model.dom.odf.util.converter.ODFConverterCreator;
import org.eclipse.actf.model.internal.ui.editors.ooo.OOoEditorScrollManager;
import org.eclipse.actf.model.internal.ui.editors.ooo.OOoEditorToolbar;
import org.eclipse.actf.model.internal.ui.editors.ooo.OOoWindowComposite;
import org.eclipse.actf.model.internal.ui.editors.ooo.util.ODFException;
import org.eclipse.actf.model.internal.ui.editors.ooo.util.OOoNavigation;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.IModelServiceHolder;
import org.eclipse.actf.model.ui.IModelServiceScrollManager;
import org.eclipse.actf.model.ui.ImagePositionInfo;
import org.eclipse.actf.model.ui.editors.ooo.initializer.util.OOoEditorInitUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OOoComposite
extends Composite
implements IModelService {
    private OOoWindowComposite _oOoWindowComposite = null;
    private Composite _comp;
    private OOoEditorScrollManager scrollManager;
    OOoEditorToolbar _toolbar;
    private String lastURL = null;
    private String title = "";
    private IModelServiceHolder holder;

    public OOoComposite(Composite parent, int style, IModelServiceHolder holder) {
        super(parent, style);
        if (OOoEditorInitUtil.isOOoInstalled((boolean)true)) {
            this.init();
        }
        this.holder = holder;
    }

    private void init() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this._toolbar = new OOoEditorToolbar(this, this, 0, true);
        this._comp = new Composite((Composite)this, 0x1000000);
        this._comp.setLayoutData((Object)new GridData(4, 4, true, true));
        try {
            this._comp.setLayout((Layout)gridLayout);
            this._oOoWindowComposite = new OOoWindowComposite(this._comp, 0x1000000);
            this._oOoWindowComposite.setLayoutData(new GridData(4, 4, true, true));
            this.scrollManager = new OOoEditorScrollManager(this._oOoWindowComposite);
        }
        catch (ODFException e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        super.dispose();
    }

    public String[] getSupportMIMETypes() {
        return MIMETYPES_ODF;
    }

    public String[] getSupportExtensions() {
        return EXTS_ODF;
    }

    public void open(String url) {
        File file;
        if (url != null && this._oOoWindowComposite != null && (file = new File(url)).exists()) {
            this._oOoWindowComposite.open(url);
            this._toolbar.getAddressText().setText(url);
            this.titleChange(file.getName());
        }
    }

    public void open(File target) {
    }

    public String getURL() {
        if (this._oOoWindowComposite != null) {
            return this._oOoWindowComposite.getUrl();
        }
        return "";
    }

    public List<Element> getElemList(Node root) {
        ArrayList<Element> elemList = new ArrayList<Element>();
        NodeList nl = root.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node instanceof Element) {
                elemList.add((Element)node);
            }
            if (node.hasChildNodes()) {
                elemList.addAll(this.getElemList(node));
            }
            ++i;
        }
        return elemList;
    }

    public Document getDocument() {
        String currentURL = this.getURL();
        if (currentURL == null) {
            return null;
        }
        OOoNavigation oooNavigation = this._oOoWindowComposite.getOooNavigation();
        ODFDocument odfDoc = oooNavigation.getContentXML();
        if (odfDoc != null && currentURL.equals(this.lastURL)) {
            return odfDoc;
        }
        ODFParser odfParser = new ODFParser();
        odfDoc = odfParser.getDocument(currentURL);
        int contentID = 0;
        List<Element> elemList = this.getElemList(odfDoc.getDocumentElement());
        int i = 0;
        while (i < elemList.size()) {
            Element elem = elemList.get(i);
            elem.setAttribute("actf-odf-content-id", new Integer(contentID).toString());
            ++contentID;
            ++i;
        }
        oooNavigation.setContentXML(odfDoc);
        this.lastURL = currentURL;
        return odfDoc;
    }

    public Document getLiveDocument() {
        return null;
    }

    public Composite getTargetComposite() {
        return this._comp;
    }

    public File saveDocumentAsHTMLFile(String file) {
        if (file == null) {
            return null;
        }
        ODFDocument odfDoc = (ODFDocument)this.getDocument();
        ODFConverter odfConverter = ODFConverterCreator.createHTMLConverter();
        odfConverter.setDocument(odfDoc);
        odfConverter.convertDocument(file, false);
        return new File(file);
    }

    public IModelServiceScrollManager getScrollManager() {
        return this.scrollManager;
    }

    public void jumpToNode(Node target) {
        if (target != null) {
            new OOoNavigationThread(target).start();
        }
    }

    public String getCurrentMIMEType() {
        return MIMETYPES_ODF[0];
    }

    private void titleChange(String title) {
        this.title = title;
        this.holder.setEditorTitle(title);
    }

    public Object getAttribute(String name) {
        return null;
    }

    public String getID() {
        return String.valueOf(OOoComposite.class.getName()) + ":" + (Object)((Object)this);
    }

    public String getTitle() {
        return this.title;
    }

    public File saveOriginalDocument(String file) {
        return null;
    }

    public ImagePositionInfo[] getAllImagePosition() {
        return new ImagePositionInfo[0];
    }

    public IModelServiceHolder getModelServiceHolder() {
        return this.holder;
    }

    private class OOoNavigationThread
    extends Thread {
        private Node _targetNode;

        public OOoNavigationThread(Node targetNode) {
            this._targetNode = targetNode;
        }

        public void run() {
            try {
                OOoComposite.this._oOoWindowComposite.getOooNavigation().jumpToProblemPosition(this._targetNode);
            }
            catch (ODFException odfe) {
                odfe.printStackTrace();
            }
        }
    }
}

