/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.util.converter.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.eclipse.actf.model.dom.odf.ODFConstants;
import org.eclipse.actf.model.dom.odf.ODFException;
import org.eclipse.actf.model.dom.odf.base.ContentBaseElement;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFElement;
import org.eclipse.actf.model.dom.odf.base.impl.ODFElementImpl;
import org.eclipse.actf.model.dom.odf.content.IEditable;
import org.eclipse.actf.model.dom.odf.draw.FrameElement;
import org.eclipse.actf.model.dom.odf.draw.ImageElement;
import org.eclipse.actf.model.dom.odf.draw.PageElement;
import org.eclipse.actf.model.dom.odf.draw.TextBoxElement;
import org.eclipse.actf.model.dom.odf.office.BodyElement;
import org.eclipse.actf.model.dom.odf.office.DocumentContentElement;
import org.eclipse.actf.model.dom.odf.office.PresentationElement;
import org.eclipse.actf.model.dom.odf.office.SpreadSheetElement;
import org.eclipse.actf.model.dom.odf.office.TextElement;
import org.eclipse.actf.model.dom.odf.presentation.NotesElement;
import org.eclipse.actf.model.dom.odf.range.ITextElementContainer;
import org.eclipse.actf.model.dom.odf.style.DefaultStyleElement;
import org.eclipse.actf.model.dom.odf.style.FontFaceElement;
import org.eclipse.actf.model.dom.odf.style.GraphicPropertiesElement;
import org.eclipse.actf.model.dom.odf.style.ParagraphPropertiesElement;
import org.eclipse.actf.model.dom.odf.style.StyleElement;
import org.eclipse.actf.model.dom.odf.style.TableCellPropertiesElement;
import org.eclipse.actf.model.dom.odf.style.TableColumnPropertiesElement;
import org.eclipse.actf.model.dom.odf.style.TablePropertiesElement;
import org.eclipse.actf.model.dom.odf.style.TextPropertiesElement;
import org.eclipse.actf.model.dom.odf.table.TableCellElement;
import org.eclipse.actf.model.dom.odf.table.TableColumnElement;
import org.eclipse.actf.model.dom.odf.table.TableColumnsElement;
import org.eclipse.actf.model.dom.odf.table.TableElement;
import org.eclipse.actf.model.dom.odf.table.TableHeaderRowsElement;
import org.eclipse.actf.model.dom.odf.table.TableRowElement;
import org.eclipse.actf.model.dom.odf.text.AElement;
import org.eclipse.actf.model.dom.odf.text.ChangeElement;
import org.eclipse.actf.model.dom.odf.text.ChangeEndElement;
import org.eclipse.actf.model.dom.odf.text.ChangeStartElement;
import org.eclipse.actf.model.dom.odf.text.HElement;
import org.eclipse.actf.model.dom.odf.text.ListElement;
import org.eclipse.actf.model.dom.odf.text.ListItemElement;
import org.eclipse.actf.model.dom.odf.text.ListLevelStyleBulletElement;
import org.eclipse.actf.model.dom.odf.text.ListLevelStyleNumberElement;
import org.eclipse.actf.model.dom.odf.text.ListStyleElement;
import org.eclipse.actf.model.dom.odf.text.PElement;
import org.eclipse.actf.model.dom.odf.text.SElement;
import org.eclipse.actf.model.dom.odf.text.SequenceElement;
import org.eclipse.actf.model.dom.odf.text.SpanElement;
import org.eclipse.actf.model.dom.odf.text.TabElement;
import org.eclipse.actf.model.dom.odf.util.converter.ODFConverter;
import org.eclipse.actf.model.dom.odf.util.converter.impl.TextExtractorImpl;
import org.eclipse.actf.util.xpath.XPathService;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTMLConverter
implements ODFConverter {
    private static final String HTML_ENCODING = "UTF8";
    private static final String ODF_CSS_FILE = "ODF.css";
    private static final String HTML_HEADER = "<html><head><META http-equiv='Content-Type' content='text/html; charset=UTF-8'/><meta content='text/html; charset=UTF-8' http-equiv='Content-type'/><title></title><link rel='stylesheet' type='text/css' href='ODF.css'/></head>";
    private double odfVersion = -1.0;
    private ODFElement curElem = null;
    private TextExtractorImpl textExtractor = new TextExtractorImpl();
    private static final XPathService xpathService = XPathServiceFactory.newService();
    private static final Object EXP1 = xpathService.compile(".//*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:style:1.0' and local-name()='default-style']");
    private static final Object EXP2 = xpathService.compile(".//*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:style:1.0' and local-name()='style']");
    private static final Object EXP3 = xpathService.compile(".//*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='list-style']");

    public void setDocument(ODFDocument document) {
        this.curElem = (ODFElement)document.getDocumentElement();
        this.textExtractor.setDocument(document, this);
    }

    public void setOdfVersion(double odfVersion) {
        this.odfVersion = odfVersion;
        this.textExtractor.setOdfVersion(odfVersion);
    }

    private String getHTMLTagName(ODFElement elem) {
        if (elem instanceof ImageElement) {
            return "img";
        }
        if (elem instanceof HElement) {
            int level = ((HElement)elem).getAttrTextOutlineLevel();
            if (level > 6) {
                level = 6;
            }
            return "h" + level;
        }
        if (elem instanceof ListElement) {
            StyleElement style = ((ListElement)elem).getListLevelStyleElement();
            if (style != null) {
                if (style instanceof ListLevelStyleBulletElement) {
                    return "ul";
                }
                if (style instanceof ListLevelStyleNumberElement) {
                    return "ol";
                }
            }
        } else if (elem instanceof TableCellElement) {
            Node parent = elem.getParentNode();
            Node gparent = null;
            if (parent != null) {
                gparent = parent.getParentNode();
            }
            if (parent != null && parent instanceof TableRowElement && gparent != null && gparent instanceof TableHeaderRowsElement) {
                return "th";
            }
            return "td";
        }
        String tagName = null;
        if (elem instanceof PElement) {
            tagName = "p";
        }
        if (elem instanceof AElement) {
            tagName = "a";
        }
        if (elem instanceof SpanElement) {
            tagName = "span";
        }
        if (elem instanceof TabElement) {
            tagName = "span";
        }
        if (elem instanceof SequenceElement) {
            tagName = "span";
        }
        if (elem instanceof SElement) {
            tagName = "span";
        }
        if (elem instanceof ListItemElement) {
            tagName = "li";
        }
        if (elem instanceof TableElement) {
            tagName = "table";
        }
        if (elem instanceof TableHeaderRowsElement) {
            tagName = "thead";
        }
        if (elem instanceof TableRowElement) {
            tagName = "tr";
        }
        if (elem instanceof TableColumnsElement) {
            tagName = "colgroup";
        }
        if (elem instanceof TableColumnElement) {
            tagName = "col";
        }
        if (elem instanceof ChangeElement) {
            tagName = "span";
        }
        if (elem instanceof ChangeStartElement) {
            tagName = "span";
        }
        if (elem instanceof ChangeEndElement) {
            tagName = "span";
        }
        if (tagName == null) {
            tagName = "div";
        }
        return tagName;
    }

    private String getStyleClassName(ODFElement elem) {
        String styleClassName = null;
        if (elem instanceof ListElement) {
            ListElement topListElem = ((ListElement)elem).getTopLevelListElement();
            long level = ((ListElement)elem).getListLevel();
            styleClassName = String.valueOf(topListElem.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "style-name")) + level;
        } else {
            NamedNodeMap attrs = elem.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                Node attr = attrs.item(i);
                if ("style-name".equals(attr.getLocalName())) {
                    styleClassName = styleClassName == null ? new String() : String.valueOf(styleClassName) + " ";
                    styleClassName = String.valueOf(styleClassName) + attr.getNodeValue();
                }
                ++i;
            }
        }
        return styleClassName;
    }

    public boolean extractContent(Writer writer, File dir, ODFElement elem, boolean enableStyle) {
        String htmlTag = this.getHTMLTagName(elem);
        if (htmlTag != null) {
            String styleClassName;
            try {
                writer.write("<" + htmlTag + " " + "odf-tagname" + "='" + elem.getTagName() + "' id='" + elem.getAttribute("actf-odf-content-id") + "' name='" + elem.getAttribute("actf-odf-content-id") + "' " + "actf-odf-content-id" + "='" + elem.getAttribute("actf-odf-content-id") + "'");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (enableStyle && (styleClassName = this.getStyleClassName(elem)) != null) {
                try {
                    writer.write(" class='" + styleClassName + "'");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (elem instanceof ImageElement) {
                String href = ((ImageElement)elem).getAttrXlinkHref();
                if (!(href.startsWith("http://") || href.startsWith("https://") || href.startsWith("file://") || href.startsWith("chrome://"))) {
                    this.textExtractor.extractEmbedFile(elem, dir, href);
                }
                try {
                    writer.write(" src='" + href + "'");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ODFElement odfElem = null;
                odfElem = this.odfVersion != -1.0 ? ((ImageElement)elem).getShortDescElement(this.odfVersion) : ((ImageElement)elem).getShortDescElement();
                if (odfElem != null) {
                    String altText = (String)((IEditable)((Object)odfElem)).getValue();
                    if (altText != null) {
                        try {
                            writer.write(" alt='" + altText + "'");
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    FrameElement frameElem = ((ImageElement)elem).getFrameElement();
                    if (frameElem != null) {
                        String height;
                        String width;
                        String captionText;
                        TextBoxElement captionElem = null;
                        captionElem = this.odfVersion != -1.0 ? frameElem.getBoundCaptionTextBoxElement(this.odfVersion) : frameElem.getBoundCaptionTextBoxElement();
                        if (captionElem != null && (captionText = captionElem.getTextContent()) != null) {
                            try {
                                writer.write(" alt=''");
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if ((width = frameElem.getAttrSvgWidth()) == null) {
                            width = "auto";
                        }
                        if ((height = frameElem.getAttrSvgHeight()) == null) {
                            height = "auto";
                        }
                        try {
                            writer.write(" style='width:" + width + ";height:" + height + ";'");
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else if (elem instanceof AElement) {
                String type = ((AElement)elem).getType();
                if ("simple".equals(type)) {
                    String href = ((AElement)elem).getHref();
                    if (href.startsWith("#")) {
                        ODFElement linkElem = ((AElement)elem).getHrefElement();
                        if (linkElem != null) {
                            try {
                                writer.write(" href='#" + linkElem.getAttribute("actf-odf-content-id") + "'");
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    } else {
                        try {
                            writer.write(" href='" + href + "'");
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else if (elem instanceof TableColumnElement) {
                int repeat = ((TableColumnElement)elem).getAttrTableNumberColumnsRepeated();
                if (repeat > 1) {
                    try {
                        writer.write(">");
                        writer.write("</" + htmlTag + ">\n");
                        int i = 1;
                        while (i < repeat) {
                            writer.write("<" + htmlTag + "/>\n");
                            ++i;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return false;
                }
            } else if (elem instanceof TableCellElement) {
                int repeat;
                int span = ((TableCellElement)elem).getAttrTableNumberColumnsSpanned();
                if (span > 1) {
                    try {
                        writer.write(" colspan='" + span + "'");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if ((repeat = ((TableCellElement)elem).getAttrTableNumberColumnsRepeated()) > 1) {
                    try {
                        writer.write(">");
                        writer.write("</" + htmlTag + ">\n");
                        int i = 1;
                        while (i < repeat) {
                            writer.write("<" + htmlTag + "/>\n");
                            ++i;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return false;
                }
            }
            try {
                writer.write(">");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        boolean addedTextContent = this.textExtractor.extractContent(writer, dir, elem, enableStyle);
        if (htmlTag != null) {
            try {
                writer.write("</" + htmlTag + ">\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return addedTextContent;
    }

    private void convertTextDoc(PrintWriter writer, File dir, TextElement textElem, boolean enableStyle) {
        Iterator<ITextElementContainer> iter = textElem.getChildIterator();
        while (iter.hasNext()) {
            ODFElement child = iter.next();
            this.extractContent(writer, dir, child, enableStyle);
        }
    }

    private void convertSpreadsheetDoc(PrintWriter writer, File dir, SpreadSheetElement spreadElem, boolean enableStyle) {
        int i = 0;
        while ((long)i < spreadElem.getTableSize()) {
            TableElement table = spreadElem.getTable(i);
            writer.write("<h1>" + table.getAttrTableName() + "</h1>");
            this.extractContent(writer, dir, table, enableStyle);
            ++i;
        }
    }

    private void convertPresentationDoc(PrintWriter writer, File dir, PresentationElement presenElem, boolean enableStyle) {
        int i = 0;
        while ((long)i < presenElem.getPageSize()) {
            PageElement page = presenElem.getPage(i);
            writer.write("<div odf-tagname='" + page.getTagName() + "' id='" + page.getAttribute("actf-odf-content-id") + "' name='" + page.getAttribute("actf-odf-content-id") + "' " + "actf-odf-content-id" + "='" + page.getAttribute("actf-odf-content-id") + "'><h1>Page " + (i + 1) + "</h1>");
            List<ODFElement> children = page.getChildNodesInNavOrder();
            int j = 0;
            while (j < children.size()) {
                Node child = children.get(j);
                if (child instanceof ODFElement && !(child instanceof NotesElement)) {
                    this.extractContent(writer, dir, (ODFElement)child, enableStyle);
                }
                ++j;
            }
            NotesElement notesElem = page.getPresentationNotesElement();
            if (notesElem != null) {
                writer.write("<h2>Notes of Page " + (i + 1) + "</h2>");
                this.extractContent(writer, dir, notesElem, enableStyle);
            }
            writer.write("</div>");
            ++i;
        }
    }

    private void convertDocument(PrintWriter writer, File dir, boolean enableStyle) {
        if (this.curElem == null) {
            return;
        }
        Element root = this.curElem.getOwnerDocument().getDocumentElement();
        if (root instanceof DocumentContentElement) {
            writer.write(HTML_HEADER);
            writer.write("<body>");
            BodyElement body = ((DocumentContentElement)root).getBodyElement();
            ContentBaseElement content = body.getContent();
            ODFConstants.ContentType type = content.getContentType();
            if (type.equals((Object)ODFConstants.ContentType.WRITE) && content instanceof TextElement) {
                this.convertTextDoc(writer, dir, (TextElement)content, enableStyle);
            } else if (type.equals((Object)ODFConstants.ContentType.SPREADSHEET) && content instanceof SpreadSheetElement) {
                this.convertSpreadsheetDoc(writer, dir, (SpreadSheetElement)content, enableStyle);
            } else if (type.equals((Object)ODFConstants.ContentType.PRESENTATION) && content instanceof PresentationElement) {
                this.convertPresentationDoc(writer, dir, (PresentationElement)content, enableStyle);
            } else {
                new ODFException("invalid content element").printStackTrace();
            }
            writer.write("</body></html>");
        } else {
            new ODFException("invalid odf document").printStackTrace();
        }
    }

    private void writeCssValueByTextPropertiesElement(PrintWriter writer, StyleElement styleElem) {
        NodeList textProps = styleElem.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-properties");
        int i = 0;
        while (i < textProps.getLength()) {
            String[] textPositionVals;
            String textPosition;
            String underLineStyle;
            String fontStyle;
            String fontWeight;
            String backgroundColor;
            String fontColor;
            String fontSize;
            TextPropertiesElement prop = (TextPropertiesElement)textProps.item(i);
            String fontName = prop.getAttrStyleFontName();
            if (fontName != null) {
                ODFElement fontFaceElem = ((ODFElementImpl)((Object)styleElem)).findElementByAttrValue("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "font-face", "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name", fontName);
                if (fontFaceElem == null) {
                    fontFaceElem = ((ODFElementImpl)((Object)styleElem)).findElementByAttrValueFromStyleDoc("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "font-face", "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name", fontName);
                }
                if (fontFaceElem != null) {
                    String fontFamily = ((FontFaceElement)fontFaceElem).getAttrSvgFontFamily();
                    writer.write("font-family:" + fontFamily + ";");
                }
            }
            if ((fontSize = prop.getAttrFormatFontSize()) != null) {
                writer.write("font-size:" + fontSize + ";");
            }
            if ((fontColor = prop.getAttrFormatColor()) != null) {
                writer.write("color:" + fontColor + ";");
            }
            if ((backgroundColor = prop.getAttrFormatBackgroundColor()) != null) {
                writer.write("background-color:" + backgroundColor + ";");
            }
            if ((fontWeight = prop.getAttrFormatFontWeight()) != null && fontWeight.equals("bold")) {
                writer.write("font-weight:bold;");
            }
            if ((fontStyle = prop.getAttrFormatFontStyle()) != null && fontStyle.equals("italic")) {
                writer.write("font-style:italic;");
            }
            if ((underLineStyle = prop.getAttrStyleTextUnderlineStyle()) != null && underLineStyle.equals("solid")) {
                writer.write("text-decoration:underline;");
            }
            if ((textPosition = prop.getAttrStyleTextPosition()) != null && (textPositionVals = textPosition.split(" ")).length == 2) {
                if (textPositionVals[0].equals("super")) {
                    writer.write("vertical-align:super;");
                } else if (textPositionVals[0].equals("sub")) {
                    writer.write("vertical-align:sub;");
                }
                writer.write("font-size:" + textPositionVals[1] + ";");
            }
            ++i;
        }
    }

    private void writeCssValueByParagraphPropertiesElement(PrintWriter writer, StyleElement styleElem) {
        NodeList paraProps = styleElem.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "paragraph-properties");
        int i = 0;
        while (i < paraProps.getLength()) {
            String marginBottom;
            String marginTop;
            String marginRight;
            String marginLeft;
            String verticalAlign;
            String textAlign;
            ParagraphPropertiesElement prop = (ParagraphPropertiesElement)paraProps.item(i);
            String backgroundColor = prop.getAttrFormatBackgroundColor();
            if (backgroundColor != null) {
                writer.write("background-color:" + backgroundColor + ";");
            }
            if ((textAlign = prop.getAttrFormatTextAlign()) != null) {
                writer.write("text-align:" + textAlign + ";");
            }
            if ((verticalAlign = prop.getAttrStyleVerticalAlign()) != null) {
                writer.write("vertical-align:" + verticalAlign + ";");
            }
            if ((marginLeft = prop.getAttrFormatMarginLeft()) != null) {
                writer.write("margin-left:" + marginLeft + ";");
            }
            if ((marginRight = prop.getAttrFormatMarginRight()) != null) {
                writer.write("margin-right:" + marginRight + ";");
            }
            if ((marginTop = prop.getAttrFormatMarginTop()) != null) {
                writer.write("margin-top:" + marginTop + ";");
            }
            if ((marginBottom = prop.getAttrFormatMarginBottom()) != null) {
                writer.write("margin-bottom:" + marginBottom + ";");
            }
            ++i;
        }
    }

    private void writeCssValueByGraphicPropertiesElement(PrintWriter writer, StyleElement styleElem) {
        NodeList graphicProps = styleElem.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "graphic-properties");
        int i = 0;
        while (i < graphicProps.getLength()) {
            GraphicPropertiesElement prop = (GraphicPropertiesElement)graphicProps.item(i);
            String horizontalPos = prop.getAttrStyleHorizontalPos();
            if (horizontalPos != null) {
                if (horizontalPos.equals("left")) {
                    writer.write("text-align:left;");
                } else if (horizontalPos.equals("center")) {
                    writer.write("text-align:center;");
                } else if (horizontalPos.equals("right")) {
                    writer.write("text-align:right;");
                }
            }
            ++i;
        }
    }

    private void writeCssValueByTablePropertiesElement(PrintWriter writer, StyleElement styleElem) {
        NodeList tableProps = styleElem.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "table-properties");
        int i = 0;
        while (i < tableProps.getLength()) {
            String borderModel;
            TablePropertiesElement prop = (TablePropertiesElement)tableProps.item(i);
            String width = prop.getAttrStyleWidth();
            if (width != null) {
                writer.write("width:" + width + ";");
            }
            if ((borderModel = prop.getAttrTableBorderModel()) != null) {
                if (borderModel.equals("collapsing")) {
                    writer.write("border-collapse:collapse;");
                } else if (borderModel.equals("separating")) {
                    writer.write("border-collapse:separate;");
                }
            }
            ++i;
        }
    }

    private void writeCssValueByTableColumnPropertiesElement(PrintWriter writer, StyleElement styleElem) {
        NodeList tableColProps = styleElem.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "table-column-properties");
        int i = 0;
        while (i < tableColProps.getLength()) {
            TableColumnPropertiesElement prop = (TableColumnPropertiesElement)tableColProps.item(i);
            String width = prop.getAttrStyleColumnWidth();
            if (width != null) {
                writer.write("width:" + width + ";");
            }
            ++i;
        }
    }

    private void writeCssValueByTableCellPropertiesElement(PrintWriter writer, StyleElement styleElem) {
        NodeList tableCellProps = styleElem.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "table-cell-properties");
        int i = 0;
        while (i < tableCellProps.getLength()) {
            String padding;
            String backgroundColor;
            String borderBottom;
            String borderTop;
            String borderRight;
            String borderLeft;
            TableCellPropertiesElement prop = (TableCellPropertiesElement)tableCellProps.item(i);
            String border = prop.getAttrFormatBorder();
            if (border != null) {
                writer.write("border:" + border + ";");
            }
            if ((borderLeft = prop.getAttrFormatBorderLeft()) != null) {
                writer.write("border-left:" + borderLeft + ";");
            }
            if ((borderRight = prop.getAttrFormatBorderRight()) != null) {
                writer.write("border-right:" + borderRight + ";");
            }
            if ((borderTop = prop.getAttrFormatBorderTop()) != null) {
                writer.write("border-top:" + borderTop + ";");
            }
            if ((borderBottom = prop.getAttrFormatBorderBottom()) != null) {
                writer.write("border-bottom:" + borderBottom + ";");
            }
            if ((backgroundColor = prop.getAttrFormatBackgroundColor()) != null) {
                writer.write("background-color:" + backgroundColor + ";");
            }
            if ((padding = prop.getAttrFormatPadding()) != null) {
                writer.write("padding:" + padding + ";");
            }
            ++i;
        }
    }

    private void writeCssValueByStyleStyleElement(PrintWriter writer, StyleElement styleElem) {
        String parentStyleName = styleElem.getAttrStyleParentStyleName();
        if (parentStyleName != null) {
            ODFElement parentStyle = ((ODFElementImpl)((Object)styleElem)).findElementByAttrValue("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name", parentStyleName);
            if (parentStyle == null) {
                parentStyle = ((ODFElementImpl)((Object)styleElem)).findElementByAttrValueFromStyleDoc("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name", parentStyleName);
            }
            if (parentStyle != null) {
                this.writeCssValueByStyleStyleElement(writer, (StyleElement)parentStyle);
            }
        }
        this.writeCssValueByTextPropertiesElement(writer, styleElem);
        this.writeCssValueByParagraphPropertiesElement(writer, styleElem);
        this.writeCssValueByGraphicPropertiesElement(writer, styleElem);
        this.writeCssValueByTablePropertiesElement(writer, styleElem);
        this.writeCssValueByTableColumnPropertiesElement(writer, styleElem);
        this.writeCssValueByTableCellPropertiesElement(writer, styleElem);
    }

    private void writeCssByStyleDefaultStyleElement(PrintWriter writer, ODFDocument doc) {
        Element root = doc.getDocumentElement();
        NodeList styleDefaultStyleList = xpathService.evalForNodeList(EXP1, (Node)root);
        int i = 0;
        while (i < styleDefaultStyleList.getLength()) {
            DefaultStyleElement styleElem = (DefaultStyleElement)styleDefaultStyleList.item(i);
            String styleFamily = styleElem.getAttrStyleFamily();
            if (styleFamily != null) {
                if (styleFamily.equals("paragraph")) {
                    writer.write("p {");
                } else if (styleFamily.equals("table")) {
                    writer.write("table {");
                } else if (styleFamily.equals("table-row")) {
                    writer.write("tr {");
                } else {
                    writer.write("." + styleFamily + " {");
                }
                this.writeCssValueByStyleStyleElement(writer, styleElem);
                writer.write("}\n");
            }
            ++i;
        }
    }

    private void writeCssByStyleStyleElement(PrintWriter writer, ODFDocument doc) {
        Element root = doc.getDocumentElement();
        NodeList styleStyleList = xpathService.evalForNodeList(EXP2, (Node)root);
        int i = 0;
        while (i < styleStyleList.getLength()) {
            StyleElement styleElem = (StyleElement)styleStyleList.item(i);
            String styleName = styleElem.getName();
            styleName = styleName.replaceAll("\\.", "\\\\\\.");
            writer.write("." + styleName + " {");
            this.writeCssValueByStyleStyleElement(writer, styleElem);
            writer.write("}\n");
            ++i;
        }
    }

    private void writeCssByListStyleElement(PrintWriter writer, ODFDocument doc) {
        Element root = doc.getDocumentElement();
        NodeList listStyleList = xpathService.evalForNodeList(EXP3, (Node)root);
        int i = 0;
        while (i < listStyleList.getLength()) {
            ListStyleElement styleElem = (ListStyleElement)listStyleList.item(i);
            String styleName = styleElem.getName();
            styleName = styleName.replaceAll("\\.", "\\\\\\.");
            NodeList nl = styleElem.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "list-level-style-number");
            int j = 0;
            while (j < nl.getLength()) {
                ListLevelStyleNumberElement styleNumElem = (ListLevelStyleNumberElement)nl.item(j);
                writer.write("." + styleName + styleNumElem.getAttrLevel() + " {");
                String format = styleNumElem.getAttrNumFormat();
                if (format.equals("1")) {
                    writer.write("list-style-type:decimal;");
                } else if (format.equals("i")) {
                    writer.write("list-style-type:lower-roman;");
                } else if (format.equals("I")) {
                    writer.write("list-style-type:upper-roman;");
                } else if (format.equals("a")) {
                    writer.write("list-style-type:lower-alpha;");
                } else if (format.equals("A")) {
                    writer.write("list-style-type:upper-alpha;");
                }
                writer.write("}\n");
                ++j;
            }
            ++i;
        }
    }

    private void writeCssFile(String fileName) {
        File file = new File(fileName);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, HTML_ENCODING);
            PrintWriter pw = new PrintWriter(osw);
            ODFDocument styleDoc = ((ODFDocument)this.curElem.getOwnerDocument()).getStyleDocument();
            this.writeCssByStyleDefaultStyleElement(pw, styleDoc);
            this.writeCssByStyleStyleElement(pw, styleDoc);
            ODFDocument contentDoc = (ODFDocument)this.curElem.getOwnerDocument();
            this.writeCssByStyleStyleElement(pw, (ODFDocument)this.curElem.getOwnerDocument());
            this.writeCssByListStyleElement(pw, contentDoc);
            pw.flush();
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void convertDocument(String fileName, boolean enableStyle) {
        File file = new File(fileName);
        String dirName = file.getParent();
        File dir = new File(dirName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (enableStyle) {
            String cssFileName = String.valueOf(dirName) + System.getProperty("file.separator") + ODF_CSS_FILE;
            this.writeCssFile(cssFileName);
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, HTML_ENCODING);
            PrintWriter pw = new PrintWriter(osw);
            this.convertDocument(pw, dir, enableStyle);
            pw.flush();
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

