/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.table.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.actf.model.dom.odf.ODFException;
import org.eclipse.actf.model.dom.odf.base.ContentBaseElement;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.impl.ODFStylableElementImpl;
import org.eclipse.actf.model.dom.odf.office.BodyElement;
import org.eclipse.actf.model.dom.odf.office.DocumentContentElement;
import org.eclipse.actf.model.dom.odf.range.ITextElementContainer;
import org.eclipse.actf.model.dom.odf.range.impl.ITextElementContainerUtil;
import org.eclipse.actf.model.dom.odf.table.TableCellElement;
import org.eclipse.actf.model.dom.odf.table.TableColumnElement;
import org.eclipse.actf.model.dom.odf.table.TableElement;
import org.eclipse.actf.model.dom.odf.table.TableHeaderColumnsElement;
import org.eclipse.actf.model.dom.odf.table.TableHeaderRowsElement;
import org.eclipse.actf.model.dom.odf.table.TableRowElement;
import org.eclipse.actf.model.dom.odf.table.TableRowsElement;
import org.eclipse.actf.model.dom.odf.text.SequenceElement;
import org.eclipse.actf.util.xpath.XPathService;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TableElementImpl
extends ODFStylableElementImpl
implements TableElement {
    private static final long serialVersionUID = -1072814785496953249L;
    private static final XPathService xpathService = XPathServiceFactory.newService();
    private static final Object EXP1 = xpathService.compile("./*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:table:1.0' and local-name()='table-header-columns']");
    private static final Object EXP2 = xpathService.compile("./*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:table:1.0' and local-name()='table-header-rows']");
    private static final Object EXP3 = xpathService.compile("following-sibling::*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='p'][1]/*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='sequence']");
    private static final Object EXP4 = xpathService.compile("preceding-sibling::*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='p'][1]/*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='sequence']");

    protected TableElementImpl(ODFDocument odfDoc, Element element) {
        super(odfDoc, element);
    }

    @Override
    public String getAttrTableName() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "name")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "name");
        }
        return null;
    }

    @Override
    public String getAttrTableStyleName() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
        }
        return null;
    }

    @Override
    public boolean getAttrTableAttrPrint() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "attr-print")) {
            return new Boolean(this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "attr-print"));
        }
        return false;
    }

    @Override
    public boolean getAttrTableProtected() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "protected")) {
            return new Boolean(this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "protected"));
        }
        return false;
    }

    @Override
    public int getTableIndex() {
        NodeList list = this.getContent().getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table");
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).equals(this)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public TableColumnElement getTableColumnChild(int column) {
        NodeList children = this.getChildNodes();
        if (children != null) {
            int i = 0;
            int count = 0;
            while (i < children.getLength()) {
                if (children.item(i) instanceof TableColumnElement) {
                    if (count == column) {
                        return (TableColumnElement)children.item(i);
                    }
                    ++count;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public TableRowElement getTableRowChild(int row) {
        NodeList children = this.getChildNodes();
        if (children != null) {
            int i = 0;
            int count = 0;
            while (i < children.getLength()) {
                if (children.item(i) instanceof TableRowElement) {
                    if (count == row) {
                        return (TableRowElement)children.item(i);
                    }
                    ++count;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public int getTableColumnSize() {
        int size = 0;
        NodeList children = this.getChildNodes();
        if (children != null) {
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child instanceof TableColumnElement) {
                    int len = ((TableColumnElement)child).getAttrTableNumberColumnsRepeated();
                    size = len > 0 ? (size += len) : ++size;
                } else if (child instanceof TableHeaderColumnsElement || child instanceof TableColumnElement) {
                    NodeList grandChildren = child.getChildNodes();
                    int j = 0;
                    while (j < grandChildren.getLength()) {
                        Node grandChild = grandChildren.item(j);
                        if (grandChild instanceof TableColumnElement) {
                            int len = ((TableColumnElement)grandChild).getAttrTableNumberColumnsRepeated();
                            size = len > 0 ? (size += len) : ++size;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return size;
    }

    @Override
    public List<TableColumnElement> getTableColumnChildren() {
        Vector<TableColumnElement> colList = null;
        NodeList children = this.getChildNodes();
        if (children != null) {
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child instanceof TableColumnElement) {
                    if (colList == null) {
                        colList = new Vector<TableColumnElement>();
                    }
                    colList.add((TableColumnElement)child);
                } else if (child instanceof TableHeaderColumnsElement || child instanceof TableColumnElement) {
                    NodeList grandChildren = child.getChildNodes();
                    int j = 0;
                    while (j < grandChildren.getLength()) {
                        Node grandChild = grandChildren.item(j);
                        if (grandChild instanceof TableColumnElement) {
                            if (colList == null) {
                                colList = new Vector();
                            }
                            colList.add((TableColumnElement)grandChild);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return colList;
    }

    @Override
    public int getTableRowSize() {
        int size = 0;
        NodeList children = this.getChildNodes();
        if (children != null) {
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child instanceof TableRowElement) {
                    int len = ((TableRowElement)child).getAttrTableNumberRowsRepeated();
                    size = len > 0 ? (size += len) : ++size;
                } else if (child instanceof TableHeaderRowsElement || child instanceof TableRowElement) {
                    NodeList grandChildren = child.getChildNodes();
                    int j = 0;
                    while (j < grandChildren.getLength()) {
                        Node grandChild = grandChildren.item(j);
                        if (grandChild instanceof TableRowElement) {
                            int len = ((TableRowElement)grandChild).getAttrTableNumberRowsRepeated();
                            size = len > 0 ? (size += len) : ++size;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return size;
    }

    @Override
    public List<TableRowElement> getTableRowChildren() {
        Vector<TableRowElement> rowList = null;
        NodeList children = this.getChildNodes();
        if (children != null) {
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i) instanceof TableRowElement) {
                    if (rowList == null) {
                        rowList = new Vector<TableRowElement>();
                    }
                    rowList.add((TableRowElement)children.item(i));
                } else if (children.item(i) instanceof TableHeaderRowsElement || children.item(i) instanceof TableRowsElement) {
                    NodeList grandChildren = children.item(i).getChildNodes();
                    int j = 0;
                    while (j < grandChildren.getLength()) {
                        if (grandChildren.item(j) instanceof TableRowElement) {
                            if (rowList == null) {
                                rowList = new Vector();
                            }
                            rowList.add((TableRowElement)grandChildren.item(j));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return rowList;
    }

    @Override
    public ContentBaseElement getContent() {
        if (this.odfDoc == null) {
            return null;
        }
        ContentBaseElement contentElement = null;
        Element root = this.odfDoc.getDocumentElement();
        if (root instanceof DocumentContentElement) {
            BodyElement body = ((DocumentContentElement)root).getBodyElement();
            contentElement = body.getContent();
        }
        return contentElement;
    }

    @Override
    public boolean hasTableCellStyle(int column, int row) {
        TableRowElement rowElement = this.getTableRowChild(row);
        List<TableCellElement> cellElems = rowElement.getTableCellChildren();
        int i = 0;
        int colCount = 0;
        while (i < cellElems.size()) {
            TableCellElement cellElem = cellElems.get(i);
            colCount = cellElem.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-columns-repeated") ? (colCount += cellElem.getAttrTableNumberColumnsRepeated()) : ++colCount;
            if (colCount - 1 >= column) {
                return cellElem.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
            }
            ++i;
        }
        return false;
    }

    @Override
    public TableRowElement appendNewTableRowElement() {
        String tablePrefix = this.lookupPrefix("urn:oasis:names:tc:opendocument:xmlns:table:1.0");
        TableRowElement rowElement = (TableRowElement)this.getOwnerDocument().createElement(String.valueOf(tablePrefix) + ":" + "table-row");
        return (TableRowElement)this.appendChild(rowElement);
    }

    @Override
    public NodeList getTableHeaderColumns() {
        return xpathService.evalForNodeList(EXP1, (Node)this);
    }

    @Override
    public NodeList getTableHeaderRows() {
        return xpathService.evalForNodeList(EXP2, (Node)this);
    }

    @Override
    public SequenceElement getTextSequenceElement() {
        NodeList pnl;
        NodeList fnl = xpathService.evalForNodeList(EXP3, (Node)this);
        if (fnl != null && fnl.getLength() == 1) {
            return (SequenceElement)fnl.item(0);
        }
        if (fnl != null && fnl.getLength() > 1) {
            new ODFException("draw:image has more than one text:sequence elements.").printStackTrace();
        }
        if ((pnl = xpathService.evalForNodeList(EXP4, (Node)this)) != null && pnl.getLength() == 1) {
            return (SequenceElement)pnl.item(0);
        }
        if (pnl != null && pnl.getLength() > 1) {
            new ODFException("draw:image has more than one text:sequence elements.").printStackTrace();
        }
        return null;
    }

    @Override
    public long getContentSize() {
        return ITextElementContainerUtil.getContentSize(this);
    }

    @Override
    public Iterator<ITextElementContainer> getChildIterator() {
        return ITextElementContainerUtil.getChildIterator(this);
    }
}

