/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.draw.impl;

import org.eclipse.actf.model.dom.odf.ODFConstants;
import org.eclipse.actf.model.dom.odf.ODFParser;
import org.eclipse.actf.model.dom.odf.base.ContentBaseElement;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.impl.EmbedDrawingObjectElementImpl;
import org.eclipse.actf.model.dom.odf.draw.ObjectElement;
import org.eclipse.actf.model.dom.odf.office.BodyElement;
import org.eclipse.actf.model.dom.odf.office.DocumentContentElement;
import org.w3c.dom.Element;

class ObjectElementImpl
extends EmbedDrawingObjectElementImpl
implements ObjectElement {
    private static final long serialVersionUID = 3713511152465032919L;

    protected ObjectElementImpl(ODFDocument odfDoc, Element element) {
        super(odfDoc, element);
    }

    public void setAttrXlinkHref(String href) {
        if (href == null) {
            this.removeAttributeNS("http://www.w3.org/1999/xlink", "href");
            return;
        }
        this.setAttributeNS("http://www.w3.org/1999/xlink", "href", href.trim());
    }

    public String getAttrDrawNotifyOnUpdateOfRanges() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "notify-on-update-of-ranges")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "notify-on-update-of-ranges");
        }
        return null;
    }

    public String getAttrXlinkHref() {
        if (this.hasAttributeNS("http://www.w3.org/1999/xlink", "href")) {
            return this.getAttributeNS("http://www.w3.org/1999/xlink", "href");
        }
        return null;
    }

    public String getAttrXlinkType() {
        if (this.hasAttributeNS("http://www.w3.org/1999/xlink", "type")) {
            return this.getAttributeNS("http://www.w3.org/1999/xlink", "type");
        }
        return null;
    }

    public String getAttrXlinkShow() {
        if (this.hasAttributeNS("http://www.w3.org/1999/xlink", "show")) {
            return this.getAttributeNS("http://www.w3.org/1999/xlink", "show");
        }
        return null;
    }

    public String getAttrXlinkActuate() {
        if (this.hasAttributeNS("http://www.w3.org/1999/xlink", "actuate")) {
            return this.getAttributeNS("http://www.w3.org/1999/xlink", "actuate");
        }
        return null;
    }

    public boolean isPresentationTable() {
        ODFParser parser;
        ODFDocument objDoc;
        ODFDocument doc = (ODFDocument)this.getOwnerDocument();
        DocumentContentElement content = (DocumentContentElement)doc.getDocumentElement();
        ODFConstants.ContentType type = content.getBodyElement().getContent().getContentType();
        if (type != ODFConstants.ContentType.PRESENTATION) {
            return false;
        }
        String fileUrl = doc.getURL();
        String objUrl = this.getAttrXlinkHref();
        if (objUrl.startsWith("./")) {
            objUrl = objUrl.substring(2);
        }
        if ((objDoc = (parser = new ODFParser()).getDocument(fileUrl, objUrl = String.valueOf(objUrl) + "/" + "content.xml")) == null) {
            return false;
        }
        Element objRoot = objDoc.getDocumentElement();
        if (!(objRoot instanceof DocumentContentElement)) {
            return false;
        }
        BodyElement objBody = ((DocumentContentElement)objRoot).getBodyElement();
        if (objBody == null) {
            return false;
        }
        ContentBaseElement objContentBase = objBody.getContent();
        return objContentBase != null && objContentBase.getContentType() == ODFConstants.ContentType.SPREADSHEET;
    }
}

