/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.base.impl;

import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFNode;
import org.eclipse.actf.model.dom.odf.base.impl.ODFDocumentImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFNamedNodeMapImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFNodeListImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

class ODFNodeImpl
implements ODFNode {
    protected ODFDocumentImpl odfDoc = null;
    protected Node iNode = null;

    protected ODFNodeImpl(Node iNode) {
        this.odfDoc = (ODFDocumentImpl)this;
        this.iNode = iNode;
    }

    protected ODFNodeImpl(ODFDocument odfDoc, Node iNode) {
        this.odfDoc = (ODFDocumentImpl)odfDoc;
        this.iNode = iNode;
    }

    protected Node getInternalNode() {
        return this.iNode;
    }

    public Node appendChild(Node newChild) throws DOMException {
        if (newChild instanceof ODFNodeImpl) {
            Node iNewChild = ((ODFNodeImpl)newChild).getInternalNode();
            Node iResultNode = this.iNode.appendChild(iNewChild);
            return new ODFNodeImpl(this.odfDoc, iResultNode);
        }
        return null;
    }

    public Node cloneNode(boolean deep) {
        if (this.odfDoc == null) {
            return null;
        }
        Node iCloneNode = this.iNode.cloneNode(deep);
        if (iCloneNode == null) {
            return null;
        }
        return this.odfDoc.getODFNode(iCloneNode);
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        if (other instanceof ODFNodeImpl) {
            Node iOther = ((ODFNodeImpl)other).getInternalNode();
            return this.iNode.compareDocumentPosition(iOther);
        }
        return 0;
    }

    public NamedNodeMap getAttributes() {
        if (this.odfDoc == null) {
            return null;
        }
        NamedNodeMap iAttrs = this.iNode.getAttributes();
        if (iAttrs == null) {
            return null;
        }
        return new ODFNamedNodeMapImpl(this.odfDoc, iAttrs);
    }

    public String getBaseURI() {
        return this.iNode.getBaseURI();
    }

    public NodeList getChildNodes() {
        return new ODFNodeListImpl(this.odfDoc, this.iNode.getChildNodes());
    }

    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException();
    }

    public Node getFirstChild() {
        if (this.odfDoc == null) {
            return null;
        }
        Node iFirstChild = this.iNode.getFirstChild();
        if (iFirstChild == null) {
            return null;
        }
        return this.odfDoc.getODFNode(iFirstChild);
    }

    public Node getLastChild() {
        if (this.odfDoc == null) {
            return null;
        }
        Node iLastChild = this.iNode.getLastChild();
        if (iLastChild == null) {
            return null;
        }
        return this.odfDoc.getODFNode(iLastChild);
    }

    public String getLocalName() {
        return this.iNode.getLocalName();
    }

    public String getNamespaceURI() {
        return this.iNode.getNamespaceURI();
    }

    public Node getNextSibling() {
        if (this.odfDoc == null) {
            return null;
        }
        Node iNextSibling = this.iNode.getNextSibling();
        if (iNextSibling == null) {
            return null;
        }
        return this.odfDoc.getODFNode(iNextSibling);
    }

    public String getNodeName() {
        return this.iNode.getNodeName();
    }

    public short getNodeType() {
        return this.iNode.getNodeType();
    }

    public String getNodeValue() throws DOMException {
        return this.iNode.getNodeValue();
    }

    public Document getOwnerDocument() {
        return this.odfDoc;
    }

    public Node getParentNode() {
        Node iParent = this.iNode.getParentNode();
        if (iParent == null) {
            return null;
        }
        return this.odfDoc.getODFNode(iParent);
    }

    public String getPrefix() {
        return this.iNode.getPrefix();
    }

    public Node getPreviousSibling() {
        if (this.odfDoc == null) {
            return null;
        }
        Node iPreviousSibling = this.iNode.getPreviousSibling();
        if (iPreviousSibling == null) {
            return null;
        }
        return this.odfDoc.getODFNode(iPreviousSibling);
    }

    public String getTextContent() throws DOMException {
        return this.iNode.getTextContent();
    }

    public Object getUserData(String key) {
        return this.iNode.getUserData(key);
    }

    public boolean hasAttributes() {
        return this.iNode.hasAttributes();
    }

    public boolean hasChildNodes() {
        return this.iNode.hasChildNodes();
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (this.odfDoc == null) {
            return null;
        }
        if (newChild instanceof ODFNodeImpl && refChild instanceof ODFNodeImpl) {
            Node iRefChild;
            Node iNewChild = ((ODFNodeImpl)newChild).getInternalNode();
            Node iInsertedChild = this.iNode.insertBefore(iNewChild, iRefChild = ((ODFNodeImpl)refChild).getInternalNode());
            if (iInsertedChild == null) {
                return null;
            }
            return this.odfDoc.getODFNode(iInsertedChild);
        }
        return null;
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return this.iNode.isDefaultNamespace(namespaceURI);
    }

    public boolean isEqualNode(Node arg) {
        if (arg instanceof ODFNodeImpl) {
            Node iarg = ((ODFNodeImpl)arg).getInternalNode();
            return this.iNode.isEqualNode(iarg);
        }
        return false;
    }

    public boolean isSameNode(Node other) {
        if (other instanceof ODFNodeImpl) {
            Node iother = ((ODFNodeImpl)other).getInternalNode();
            return this.iNode.isSameNode(iother);
        }
        return false;
    }

    public boolean isSupported(String feature, String version) {
        return this.iNode.isSupported(feature, version);
    }

    public String lookupNamespaceURI(String prefix) {
        return this.iNode.lookupNamespaceURI(prefix);
    }

    public String lookupPrefix(String namespaceURI) {
        return this.iNode.lookupPrefix(namespaceURI);
    }

    public void normalize() {
    }

    public Node removeChild(Node oldChild) throws DOMException {
        if (this.odfDoc == null) {
            return null;
        }
        if (oldChild instanceof ODFNodeImpl) {
            Node iOldChild = ((ODFNodeImpl)oldChild).getInternalNode();
            Node iRemovedChild = this.iNode.removeChild(iOldChild);
            return this.odfDoc.getODFNode(iRemovedChild);
        }
        return null;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (this.odfDoc == null) {
            return null;
        }
        if (newChild instanceof ODFNodeImpl && oldChild instanceof ODFNodeImpl) {
            Node iNewChild = ((ODFNodeImpl)newChild).getInternalNode();
            Node iOldChild = ((ODFNodeImpl)oldChild).getInternalNode();
            Node iReplacedChild = this.iNode.replaceChild(iNewChild, iOldChild);
            return this.odfDoc.getODFNode(iReplacedChild);
        }
        return null;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.iNode.setNodeValue(nodeValue);
    }

    public void setPrefix(String prefix) throws DOMException {
        this.iNode.setPrefix(prefix);
    }

    public void setTextContent(String textContent) throws DOMException {
        this.iNode.setTextContent(textContent);
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return null;
    }
}

