/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ui.util.timer;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.WeakHashMap;
import org.eclipse.actf.ui.util.timer.SyncEventListener;
import org.eclipse.swt.widgets.Display;

public class WeakSyncTimer
extends Thread {
    private ArrayList<WeakReference<SyncEventListener>> listeners = new ArrayList();
    private WeakHashMap<SyncEventListener, Long> entries = new WeakHashMap();
    private long nextWakeup = Long.MAX_VALUE;
    private Display display;
    private static WeakSyncTimer instance;

    public synchronized void run() {
        block2: while (true) {
            long ctime;
            if (this.nextWakeup > (ctime = System.currentTimeMillis())) {
                try {
                    long timeout = this.nextWakeup - System.currentTimeMillis() - 1L;
                    if (timeout > 0L) {
                        this.wait(timeout);
                    } else {
                        this.wait(1L);
                    }
                }
                catch (InterruptedException interruptedException) {}
                ctime = System.currentTimeMillis();
            }
            Iterator<WeakReference<SyncEventListener>> it = this.listeners.iterator();
            this.nextWakeup = Long.MAX_VALUE;
            while (true) {
                if (!it.hasNext()) continue block2;
                SyncEventListener listener = (SyncEventListener)it.next().get();
                if (listener == null) {
                    it.remove();
                    continue;
                }
                Long timeObj = this.entries.get(listener);
                if (timeObj == null) {
                    it.remove();
                    continue;
                }
                long time = timeObj;
                if (time <= ctime) {
                    if (!this.display.isDisposed()) {
                        this.display.asyncExec((Runnable)listener);
                        this.manage(listener);
                        continue;
                    }
                    it.remove();
                    continue;
                }
                if (this.nextWakeup <= time) continue;
                this.nextWakeup = time;
            }
            break;
        }
    }

    private void manage(SyncEventListener listener) {
        long interval = (long)(listener.getInterval() * 1000.0);
        if (interval > 0L) {
            long time = System.currentTimeMillis() + interval;
            this.entries.put(listener, time);
            if (time < this.nextWakeup) {
                this.nextWakeup = time;
            }
        } else {
            this.entries.remove(listener);
        }
    }

    public synchronized void addEventListener(SyncEventListener listener) {
        this.listeners.add(new WeakReference<SyncEventListener>(listener));
        this.manage(listener);
        this.notify();
    }

    public synchronized void removeEventListener(SyncEventListener listener) {
        this.entries.remove(listener);
    }

    public static WeakSyncTimer getTimer() {
        if (instance == null) {
            instance = new WeakSyncTimer(Display.getCurrent());
            instance.start();
        }
        return instance;
    }

    private WeakSyncTimer(Display display) {
        super("WeakSyncTimer-scheduler");
        this.display = display;
    }
}

