/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ui.util.timer;

import org.eclipse.actf.ui.util.timer.SyncEventListener;
import org.eclipse.actf.ui.util.timer.WaitExecSyncEventHandler;
import org.eclipse.actf.ui.util.timer.WeakSyncTimer;

public class WaitExecSyncEventListener
implements SyncEventListener {
    private WeakSyncTimer timer = WeakSyncTimer.getTimer();
    private WaitExecSyncEventHandler handler;
    private long start;
    private double interval;

    public WaitExecSyncEventListener(WaitExecSyncEventHandler handler) {
        this.handler = handler;
        this.startListener();
    }

    private void startListener() {
        this.start = System.currentTimeMillis();
        this.interval = this.handler.getInterval();
        this.timer.addEventListener(this);
    }

    private void stopListener() {
        this.interval = 0.0;
        this.timer.removeEventListener(this);
    }

    public double getInterval() {
        return this.interval;
    }

    public void run() {
        if (0.0 != this.interval && this.handler.canRun((double)(System.currentTimeMillis() - this.start) / 1000.0)) {
            this.stopListener();
            this.handler.run();
        }
    }
}

