/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ui.util;

import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;

public class ProgressContribution
extends ControlContribution {
    public static final String PROGRESS_CONTRIBUTION_ID = "actf.progress";
    private ProgressBar progressBar;
    private Label label;
    private String text;
    private int value;

    public ProgressContribution(String id) {
        super(id);
    }

    protected Control createControl(Composite parent) {
        StatusLineLayoutData data = new StatusLineLayoutData();
        data.heightHint = 12;
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)data);
        RowLayout rl = new RowLayout();
        rl.wrap = false;
        c.setLayout((Layout)rl);
        new Label(c, 2);
        this.label = new Label(c, 0);
        if (this.text != null) {
            this.label.setText(this.text);
        }
        this.progressBar = new ProgressBar(c, 65792);
        RowData r = new RowData();
        r.width = 150;
        r.height = 16;
        this.progressBar.setLayoutData((Object)r);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setSelection(this.value);
        return c;
    }

    public void setText(String text) {
        this.text = text;
        if (text != null) {
            this.label.setText(text);
        } else {
            this.label.setText("");
        }
    }

    public void setValue(int percent) {
        this.value = percent;
        if (this.progressBar != null) {
            this.progressBar.setSelection(percent);
            this.progressBar.redraw();
        }
    }
}

