/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editors.ie;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.actf.model.dom.dombycom.IElementEx;
import org.eclipse.actf.model.dom.dombycom.IStyle;
import org.eclipse.actf.model.ui.editor.browser.ICurrentStyles;
import org.eclipse.actf.util.dom.TreeWalkerImpl;
import org.eclipse.actf.util.xpath.XPathCreator;
import org.eclipse.swt.graphics.Rectangle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.NodeFilter;

public class CurrentStylesImpl
implements ICurrentStyles {
    private static final String A_VISIBILITY = "visibility";
    private static final String A_TEXT_DECORATION = "textDecoration";
    private static final String A_TEXT_ALIGN = "textAlign";
    private static final String A_POSITION = "position";
    private static final String A_LINE_HEIGHT = "lineHeight";
    private static final String A_LETTER_SPACING = "letterSpacing";
    private static final String A_FONT_VARIANT = "fontVariant";
    private static final String A_FONT_STYLE = "fontStyle";
    private static final String A_FONT_SIZE = "fontSize";
    private static final String A_FONT_FAMILY = "fontFamily";
    private static final String A_DISPLAY = "display";
    private static final String A_COLOR = "color";
    private static final String A_BACKGROUND_REPEAT = "backgroundRepeat";
    private static final String A_BACKGROUND_COLOR = "backgroundColor";
    private static final String A_BACKGROUND_IMAGE = "backgroundImage";
    private static final String HREF = "href";
    private static final String TAG_A = "A";
    private final String xpath;
    private final String tagName;
    private final Rectangle rect;
    private final String backgroundColor;
    private final String backgroundRepeat;
    private final String backgroundImage;
    private final String color;
    private final String fontFamily;
    private final String fontSize;
    private final String fontStyle;
    private final String fontVariant;
    private final String lineHeight;
    private final String textAlign;
    private final String visibility;
    private final String display;
    private final String position;
    private final String textDecoration;
    private final String letterSpacing;
    private boolean isLink;
    private URL target = null;
    private String cascadeColor;
    private String cascadeBackgroundColor;
    private String cascadeBackgroundImage;
    private final boolean hasChildText;
    private String[] childTexts = new String[0];
    private String[] descendantTextsWithBGImage = new String[0];
    private boolean hasDescendantTextWithBGImage = false;
    private Element element;

    public CurrentStylesImpl(IElementEx element, URL baseUrl) {
        String type;
        String href;
        this.element = element;
        this.rect = element.getLocation();
        this.xpath = XPathCreator.childPathSequence((Node)element);
        this.tagName = element.getTagName();
        this.isLink = false;
        if (TAG_A.equalsIgnoreCase(this.tagName) && (href = element.getAttribute(HREF)) != null) {
            if (baseUrl != null) {
                try {
                    this.target = new URL(baseUrl, href);
                    this.isLink = true;
                }
                catch (Exception exception) {
                    try {
                        this.target = new URL(href);
                        this.isLink = true;
                    }
                    catch (Exception exception2) {}
                }
            } else {
                try {
                    this.target = new URL(href);
                    this.isLink = true;
                }
                catch (Exception exception) {}
            }
        }
        IStyle style = element.getStyle();
        this.backgroundImage = (String)style.get(A_BACKGROUND_IMAGE);
        this.backgroundRepeat = (String)style.get(A_BACKGROUND_REPEAT);
        this.backgroundColor = (String)style.get(A_BACKGROUND_COLOR);
        this.cascadeColor = this.color = (String)style.get(A_COLOR);
        this.cascadeBackgroundColor = this.backgroundColor;
        this.cascadeBackgroundImage = this.backgroundImage;
        this.display = (String)style.get(A_DISPLAY);
        this.fontFamily = (String)style.get(A_FONT_FAMILY);
        this.fontSize = (String)style.get(A_FONT_SIZE);
        this.fontStyle = (String)style.get(A_FONT_STYLE);
        this.fontVariant = (String)style.get(A_FONT_VARIANT);
        this.letterSpacing = (String)style.get(A_LETTER_SPACING);
        this.lineHeight = (String)style.get(A_LINE_HEIGHT);
        this.position = (String)style.get(A_POSITION);
        this.textAlign = (String)style.get(A_TEXT_ALIGN);
        this.textDecoration = (String)style.get(A_TEXT_DECORATION);
        this.visibility = (String)style.get(A_VISIBILITY);
        boolean fgFlag = "transparent".equalsIgnoreCase(this.cascadeColor);
        boolean bgFlag = "transparent".equalsIgnoreCase(this.cascadeBackgroundColor);
        boolean bgImgFlag = bgFlag && "none".equalsIgnoreCase(this.cascadeBackgroundImage);
        Node tmpN = element.getParentNode();
        if (tmpN != null && !(tmpN instanceof Document) && (fgFlag || bgFlag)) {
            try {
                if (tmpN instanceof IElementEx) {
                    String tmpStr;
                    IElementEx tmpE = (IElementEx)tmpN;
                    if (fgFlag && (tmpStr = (String)tmpE.getStyle().get(A_COLOR)) != null && !tmpStr.equalsIgnoreCase("transparent")) {
                        this.cascadeColor = tmpStr;
                        fgFlag = false;
                    }
                    if (bgImgFlag && (tmpStr = (String)tmpE.getStyle().get(A_BACKGROUND_IMAGE)) != null && !tmpStr.equalsIgnoreCase("none")) {
                        this.cascadeBackgroundImage = tmpStr;
                        bgImgFlag = false;
                    }
                    if (bgFlag && (tmpStr = (String)tmpE.getStyle().get(A_BACKGROUND_COLOR)) != null && !tmpStr.equalsIgnoreCase("transparent")) {
                        this.cascadeBackgroundColor = tmpStr;
                        bgFlag = false;
                        bgImgFlag = false;
                    }
                }
            }
            catch (Exception exception) {}
            tmpN = tmpN.getParentNode();
        }
        ArrayList<String> childs = new ArrayList<String>();
        boolean flag = false;
        NodeList tmpNL = element.getChildNodes();
        int i = 0;
        while (i < tmpNL.getLength()) {
            Node tmpN2 = tmpNL.item(i);
            if (tmpN2 instanceof Text && tmpN2.getNodeValue().trim().length() > 0) {
                flag = true;
                childs.add(tmpN2.getNodeValue());
            }
            ++i;
        }
        if (!flag && "input".equalsIgnoreCase(element.getTagName()) && (type = element.getAttribute("type")) != null && type.matches("(button)|(submit)|(reset)") && element.getText().trim().length() > 0) {
            flag = true;
            childs.add(element.getText());
        }
        this.hasChildText = flag;
        this.childTexts = new String[childs.size()];
        childs.toArray(this.childTexts);
        if (this.backgroundImage != null && !"none".equalsIgnoreCase(this.backgroundImage)) {
            NodeFilter tmpNF = new NodeFilter(){

                public short acceptNode(Node n) {
                    IStyle tmpStyle;
                    if (n instanceof Text) {
                        if (n.getNodeValue().trim().length() > 0) {
                            return 1;
                        }
                        return 3;
                    }
                    if (!(!(n instanceof IElementEx) || (tmpStyle = ((IElementEx)n).getStyle()) == null || "none".equalsIgnoreCase((String)tmpStyle.get(CurrentStylesImpl.A_BACKGROUND_IMAGE)) && "transparent".equalsIgnoreCase((String)tmpStyle.get(CurrentStylesImpl.A_BACKGROUND_COLOR)))) {
                        return 2;
                    }
                    return 3;
                }
            };
            ArrayList<String> descendants = new ArrayList<String>();
            TreeWalkerImpl twi = new TreeWalkerImpl((Node)element, -1, tmpNF, false);
            Node tmpText = twi.nextNode();
            this.hasDescendantTextWithBGImage = tmpText != null;
            while (tmpText != null) {
                descendants.add(tmpText.getNodeValue());
                tmpText = twi.nextNode();
            }
            this.descendantTextsWithBGImage = new String[descendants.size()];
            descendants.toArray(this.descendantTextsWithBGImage);
        }
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getBackgroundRepeat() {
        return this.backgroundRepeat;
    }

    public String getBackgroundImage() {
        return this.backgroundImage;
    }

    public String getColor() {
        return this.color;
    }

    public String getDisplay() {
        return this.display;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public String getFontVariant() {
        return this.fontVariant;
    }

    public String getLetterSpacing() {
        return this.letterSpacing;
    }

    public String getLineHeight() {
        return this.lineHeight;
    }

    public String getPosition() {
        return this.position;
    }

    public String getTextAlign() {
        return this.textAlign;
    }

    public String getTextDecoration() {
        return this.textDecoration;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getXPath() {
        return this.xpath;
    }

    public Rectangle getRectangle() {
        return this.rect;
    }

    public URL getLinkURL() {
        return this.target;
    }

    public boolean isLink() {
        return this.isLink;
    }

    public Element getElement() {
        return this.element;
    }

    public String getComputedColor() {
        return this.cascadeColor;
    }

    public String getComputedBackgroundColor() {
        return this.cascadeBackgroundColor;
    }

    public String getComputedBackgroundImage() {
        return this.cascadeBackgroundImage;
    }

    public boolean hasChildText() {
        return this.hasChildText;
    }

    public boolean hasDescendantTextWithBGImage() {
        return this.hasDescendantTextWithBGImage;
    }

    public String[] getChildTexts() {
        return this.childTexts;
    }

    public String[] getDescendantTextsWithBGImage() {
        return this.descendantTextsWithBGImage;
    }
}

