/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.voicebrowser;

import org.eclipse.actf.visualization.internal.engines.voicebrowser.Context;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.IElementRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.MessageCollection;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.OutLoud;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.Packet;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.PacketCollection;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StaticARenderer
implements IElementRenderer {
    public PacketCollection getPacketCollectionIn(Element element, Context curContext, String url, MessageCollection mc) {
        this.setContextIn(element, curContext);
        try {
            NamedNodeMap attrs = element.getAttributes();
            Node hrefNode = attrs.getNamedItem("href");
            String result = null;
            if (hrefNode == null) {
                curContext.setLinkTag(false);
            } else {
                String link = hrefNode.getNodeValue();
                result = link != null && link.length() > 0 && link.charAt(0) == '#' ? OutLoud.buildResultString(mc, url, element, "internallink", null) : OutLoud.buildResultString(mc, url, element, null, null);
                if (result != null) {
                    result = result.trim();
                }
            }
            return new PacketCollection(new Packet(element, result, curContext, true));
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public PacketCollection getPacketCollectionOut(Element element, Context curContext, String url, MessageCollection mc) {
        this.setContextOut(element, curContext);
        return new PacketCollection(new Packet(element, "", curContext, true));
    }

    public void setContextIn(Element element, Context curContext) {
        curContext.setInsideAnchor(true);
        curContext.setGoChild(true);
        curContext.setLineDelimiter(false);
        curContext.setLinkTag(true);
    }

    public void setContextOut(Element element, Context curContext) {
        curContext.setInsideAnchor(false);
        curContext.setGoChild(true);
        curContext.setLineDelimiter(false);
        curContext.setLinkTag(false);
    }
}

