/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.voicebrowser;

import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.Message;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.MessageCollection;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class OutLoud {
    private static final String DEFAULT = "default";
    private static final String GREATER = ">";
    private static final String ATTRIBUTE_EQUAL = "<attribute=";
    private static final String VAR = "<var>";
    public static int jwat_mode = 1;
    public static boolean hprDefltMsg = true;
    public static String name = "default";
    public static String description = null;
    public static String topofpage = null;
    public static String endofpage = null;
    public static String nocurlink = null;
    public static String noprevlink = null;
    public static String nonextlink = null;
    public static String nostring = null;
    public static String notonalink = null;

    public static MessageCollection createMessageCollection(int mode, String xmlpath) {
        MessageCollection mc = null;
        if (xmlpath != null && xmlpath.length() > 0) {
            mc = OutLoud.createSiteMessageCollection(xmlpath);
            mc = OutLoud.createApplMessageCollection(mc, mode, xmlpath);
        }
        return mc;
    }

    private static MessageCollection createSiteMessageCollection(String xmlpath) {
        MessageCollection mc = new MessageCollection();
        String path = String.valueOf(xmlpath) + File.separator;
        String uriPrefix = null;
        try {
            File dir = new File(xmlpath);
            String[] ls = dir.list();
            int i = 0;
            while (i < ls.length) {
                if (ls[i].toLowerCase().startsWith("jwat_site_") && ls[i].toLowerCase().endsWith(".xml")) {
                    String f = String.valueOf(path) + ls[i];
                    InputSource inputSource = new InputSource(new FileReader(f));
                    DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = dbfactory.newDocumentBuilder();
                    Document document = builder.parse(inputSource);
                    Node curReadNode = document;
                    while (curReadNode != null) {
                        if (curReadNode.getNodeType() == 1) {
                            int num;
                            if (curReadNode.getNodeName().toLowerCase().equals("outloud-message")) {
                                num = curReadNode.getAttributes().getLength();
                                if (num > 0) {
                                    Attr attribute = (Attr)curReadNode.getAttributes().item(0);
                                    uriPrefix = attribute.getNodeValue();
                                }
                            } else if (curReadNode.getNodeName().toLowerCase().equals("tag") && curReadNode.getAttributes() != null && curReadNode.getAttributes().getLength() > 0) {
                                num = curReadNode.getAttributes().getLength();
                                int j = 0;
                                while (j < num) {
                                    Attr attribute = (Attr)curReadNode.getAttributes().item(j);
                                    if (attribute.getNodeName().toLowerCase().equals("name")) {
                                        MessageCollection tmp = OutLoud.buildMessageCollection(curReadNode, uriPrefix);
                                        if (tmp == null) break;
                                        mc.addAll(tmp);
                                        break;
                                    }
                                    ++j;
                                }
                            }
                        }
                        curReadNode = OutLoud.goNext(curReadNode);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
        return mc;
    }

    private static MessageCollection createApplMessageCollection(MessageCollection result, int mode, String xmlpath) {
        Document document;
        block31: {
            String path = String.valueOf(xmlpath) + File.separator;
            try {
                String dtdpath = String.valueOf(path) + "jwat.dtd";
                if (mode == 1) {
                    path = String.valueOf(path) + "jwat_hpr.xml";
                } else if (mode == 2) {
                    path = String.valueOf(path) + "jwat_jaws.xml";
                }
                File f = new File(path);
                File d = new File(dtdpath);
                if (f.exists() && d.exists()) {
                    InputSource inputSource = new InputSource(new FileReader(path));
                    DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = dbfactory.newDocumentBuilder();
                    document = builder.parse(inputSource);
                    break block31;
                }
                name = DEFAULT;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                name = DEFAULT;
                return null;
            }
        }
        jwat_mode = mode;
        Node curReadNode = document;
        hprDefltMsg = true;
        while (curReadNode != null) {
            if (curReadNode.getNodeType() == 1) {
                if (curReadNode.getNodeName().toLowerCase().equals("name")) {
                    curReadNode = OutLoud.goNext(curReadNode);
                    name = OutLoud.getString(curReadNode);
                } else if (curReadNode.getNodeName().toLowerCase().equals("description")) {
                    curReadNode = OutLoud.goNext(curReadNode);
                    description = OutLoud.getString(curReadNode);
                } else if (curReadNode.getNodeName().equals("disableDefaultMessage")) {
                    hprDefltMsg = false;
                } else if (curReadNode.getNodeName().equals("TopOfPage")) {
                    curReadNode = OutLoud.goNext(curReadNode);
                    topofpage = OutLoud.getString(curReadNode);
                } else if (curReadNode.getNodeName().equals("EndOfPage")) {
                    curReadNode = OutLoud.goNext(curReadNode);
                    endofpage = OutLoud.getString(curReadNode);
                } else if (curReadNode.getNodeName().equals("NoCurLink")) {
                    curReadNode = OutLoud.goNext(curReadNode);
                    nocurlink = OutLoud.getString(curReadNode);
                } else if (curReadNode.getNodeName().equals("NoPrevLink")) {
                    curReadNode = OutLoud.goNext(curReadNode);
                    noprevlink = OutLoud.getString(curReadNode);
                } else if (curReadNode.getNodeName().equals("NoNextLink")) {
                    curReadNode = OutLoud.goNext(curReadNode);
                    nonextlink = OutLoud.getString(curReadNode);
                } else if (curReadNode.getNodeName().equals("NoString")) {
                    curReadNode = OutLoud.goNext(curReadNode);
                    nostring = OutLoud.getString(curReadNode);
                } else if (curReadNode.getNodeName().equals("NotOnALink")) {
                    curReadNode = OutLoud.goNext(curReadNode);
                    notonalink = OutLoud.getString(curReadNode);
                } else if (curReadNode.getNodeName().toLowerCase().equals("tag") && curReadNode.getAttributes() != null && curReadNode.getAttributes().getLength() > 0) {
                    int num = curReadNode.getAttributes().getLength();
                    int i = 0;
                    while (i < num) {
                        Attr attribute = (Attr)curReadNode.getAttributes().item(i);
                        if (attribute.getNodeName().toLowerCase().equals("name")) {
                            MessageCollection tmp = OutLoud.buildMessageCollection(curReadNode, null);
                            if (tmp == null) break;
                            result.addAll(tmp);
                            break;
                        }
                        ++i;
                    }
                }
            }
            curReadNode = OutLoud.goNext(curReadNode);
        }
        return result;
    }

    private static String getString(Node node) {
        String str = null;
        if (node.getNodeType() == 3) {
            str = node.getNodeValue();
        }
        return str;
    }

    private static MessageCollection buildMessageCollection(Node node, String uri) {
        String tagName = null;
        String tagType = null;
        String tagState = null;
        int num = node.getAttributes().getLength();
        int i = 0;
        while (i < num) {
            Attr attribute = (Attr)node.getAttributes().item(i);
            if (attribute.getNodeName().toLowerCase().equals("name")) {
                tagName = attribute.getNodeValue();
            } else if (attribute.getNodeName().toLowerCase().equals("type")) {
                tagType = attribute.getNodeValue();
            } else if (attribute.getNodeName().toLowerCase().equals("state")) {
                tagState = attribute.getNodeValue();
            }
            ++i;
        }
        ArrayList<String> msgs = new ArrayList<String>();
        ArrayList<String> conditions = new ArrayList<String>();
        node = OutLoud.goNext(node);
        while (node != null) {
            if (node.getNodeType() == 1) {
                if (node.getNodeName().toLowerCase().equals("condition")) {
                    conditions.add(uri);
                    node = OutLoud.goNext(node);
                    while (node != null) {
                        if (node.getNodeType() != 1 || !node.getNodeName().toLowerCase().equals("msg")) {
                            String t;
                            Attr attribute;
                            String s;
                            if (node.getNodeType() == 1 && node.getNodeName().toLowerCase().equals("attribute") && (num = node.getAttributes().getLength()) == 1 && (s = (attribute = (Attr)node.getAttributes().item(0)).getNodeValue()) != null && s.length() > 0 && (node = OutLoud.goNext(node)).getNodeType() == 3 && (t = node.getNodeValue().trim()) != null && t.length() > 0) {
                                String r = String.valueOf(s) + "=" + t;
                                conditions.add(r);
                            }
                            node = OutLoud.goNext(node);
                            continue;
                        }
                        break;
                    }
                } else if (node.getNodeName().toLowerCase().equals("msg")) {
                    node = OutLoud.goNext(node);
                    while (node != null) {
                        if (node.getNodeType() == 1) {
                            if (node.getNodeName().toLowerCase().equals("msg")) break;
                            if (node.getNodeName().toLowerCase().equals("var")) {
                                String s = VAR;
                                num = node.getAttributes().getLength();
                                int i2 = 0;
                                while (i2 < num) {
                                    Attr attribute = (Attr)node.getAttributes().item(i2);
                                    String value = attribute.getNodeValue();
                                    s = String.valueOf(s) + ",<" + attribute.getNodeName().toLowerCase() + "=" + value + GREATER;
                                    ++i2;
                                }
                                if (s.length() > 0) {
                                    msgs.add(s);
                                }
                            }
                        } else if (node.getNodeType() == 3) {
                            String t = node.getNodeValue();
                            if (t.length() > 0) {
                                msgs.add(t);
                            }
                            if (node.getNextSibling() == null) break;
                        }
                        node = OutLoud.goNext(node);
                    }
                } else if (node.getNodeName().toLowerCase().equals("tag")) break;
            }
            if (node.getNodeName().toLowerCase().equals("msg")) continue;
            node = OutLoud.goNext(node);
        }
        return new MessageCollection(new Message(tagName, conditions, tagType, tagState, msgs));
    }

    private static Node goNext(Node curReadNode) {
        if (curReadNode == null) {
            return null;
        }
        if (curReadNode.hasChildNodes()) {
            return curReadNode.getFirstChild();
        }
        if (curReadNode.getNextSibling() != null) {
            return curReadNode.getNextSibling();
        }
        if (curReadNode.getParentNode() != null) {
            Node node = curReadNode.getParentNode();
            curReadNode = node.getNextSibling();
        } else {
            curReadNode = null;
        }
        return curReadNode;
    }

    public static void dumpMessages(MessageCollection mc) {
        if (mc == null) {
            return;
        }
        System.out.println("Mode name is [" + name + "]");
        System.out.println("Mode description [" + description + "]");
        System.out.println("\tTopOfPage is [" + topofpage + "]");
        System.out.println("\tEndOfPage is [" + endofpage + "]");
        System.out.println("\tNoCurLink is [" + nocurlink + "]");
        System.out.println("\tNoPrevLink is [" + noprevlink + "]");
        System.out.println("\tNoNextLink is [" + nonextlink + "]");
        System.out.println("\tNoString is [" + nostring + "]");
        System.out.println("\tNotOnALink is [" + notonalink + "]");
        if (mc.size() > 0) {
            int i = 0;
            while (i < mc.size()) {
                String n = ((Message)mc.get(i)).getTagName();
                String t = ((Message)mc.get(i)).getTagType();
                String s = ((Message)mc.get(i)).getTagState();
                System.out.println("tag[" + n + "] - type[" + t + "]  - state[" + s + "]");
                ArrayList<String> conditions = ((Message)mc.get(i)).getConditions();
                int j = 0;
                while (j < conditions.size()) {
                    System.out.println(" C[" + conditions.get(j) + "]");
                    ++j;
                }
                ArrayList<String> msgs = ((Message)mc.get(i)).getMessages();
                int j2 = 0;
                while (j2 < msgs.size()) {
                    System.out.println(" T[" + msgs.get(j2) + "]");
                    ++j2;
                }
                ++i;
            }
        }
    }

    public static String buildResultString(MessageCollection mc, String url, Element element, String type, String state) {
        String nodeName = element.getNodeName().toLowerCase();
        String result = null;
        ArrayList<String> msgs = null;
        ArrayList<String> conditions = null;
        if (mc == null) {
            return null;
        }
        result = OutLoud.getSiteSpecificMessage(mc, element, url);
        if (result != null && result.length() > 0) {
            return result;
        }
        Message msg = mc.getMessage(mc, nodeName, type, state);
        if (msg != null) {
            msgs = msg.getMessages();
            conditions = msg.getConditions();
        }
        if (msg != null) {
            String s = null;
            int i = 0;
            while (i < msgs.size()) {
                if (conditions.size() <= 0) {
                    s = msgs.get(i);
                    if (s.startsWith(VAR)) {
                        String pattern0 = ATTRIBUTE_EQUAL;
                        int pos = s.lastIndexOf(pattern0);
                        if (pos > 0) {
                            s = s.substring(pos + pattern0.length());
                            if ((s = s.substring(0, s.indexOf(GREATER))).length() > 0) {
                                NamedNodeMap attrs = element.getAttributes();
                                String value = null;
                                Node altNode = attrs.getNamedItem(s);
                                value = altNode.getNodeValue();
                                if (value != null && value.length() > 0) {
                                    result = result == null ? value : String.valueOf(result) + value;
                                }
                            }
                        }
                    } else {
                        result = result == null ? s : String.valueOf(result) + s;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public static String buildResultString(MessageCollection mc, String url, Element element, String type, String state, String pattern1, String replstr1) {
        String nodeName = element.getNodeName().toLowerCase();
        String result = null;
        ArrayList<String> msgs = null;
        ArrayList<String> conditions = null;
        if (mc == null) {
            return null;
        }
        result = OutLoud.getSiteSpecificMessage(mc, element, url);
        if (result != null && result.length() > 0) {
            return result;
        }
        Message msg = mc.getMessage(mc, nodeName, type, state);
        if (msg != null) {
            msgs = msg.getMessages();
            conditions = msg.getConditions();
        }
        if (msg != null) {
            String s = null;
            int i = 0;
            while (i < msgs.size()) {
                if (conditions.size() <= 0) {
                    s = msgs.get(i);
                    if (s.startsWith(VAR)) {
                        String pattern0 = ATTRIBUTE_EQUAL;
                        int pos = s.lastIndexOf(pattern0);
                        if (pos > 0) {
                            s = s.substring(pos + pattern0.length());
                            if ((s = s.substring(0, s.indexOf(GREATER))).length() > 0) {
                                NamedNodeMap attrs = element.getAttributes();
                                String value = null;
                                Node altNode = attrs.getNamedItem(s);
                                value = altNode.getNodeValue();
                                if (value != null && value.length() > 0) {
                                    result = result == null ? value : String.valueOf(result) + value;
                                }
                            }
                        }
                        if ((pos = s.lastIndexOf(pattern1)) > 0) {
                            result = result == null ? replstr1 : String.valueOf(result) + replstr1;
                        }
                    } else {
                        result = result == null ? s : String.valueOf(result) + s;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public static String buildResultString(MessageCollection mc, String url, Element element, String type, String state, String pattern1, String replstr1, String pattern2, String replstr2) {
        String nodeName = element.getNodeName().toLowerCase();
        String result = null;
        ArrayList<String> msgs = null;
        ArrayList<String> conditions = null;
        if (mc == null) {
            return null;
        }
        result = OutLoud.getSiteSpecificMessage(mc, element, url);
        if (result != null && result.length() > 0) {
            return result;
        }
        Message msg = mc.getMessage(mc, nodeName, type, state);
        if (msg != null) {
            msgs = msg.getMessages();
            conditions = msg.getConditions();
        }
        if (msg != null) {
            String s = null;
            int i = 0;
            while (i < msgs.size()) {
                if (conditions.size() <= 0) {
                    s = msgs.get(i);
                    if (s.startsWith(VAR)) {
                        String pattern0 = ATTRIBUTE_EQUAL;
                        int pos = s.lastIndexOf(pattern0);
                        if (pos > 0) {
                            s = s.substring(pos + pattern0.length());
                            if ((s = s.substring(0, s.indexOf(GREATER))).length() > 0) {
                                NamedNodeMap attrs = element.getAttributes();
                                String value = null;
                                Node altNode = attrs.getNamedItem(s);
                                value = altNode.getNodeValue();
                                if (value != null && value.length() > 0) {
                                    result = result == null ? value : String.valueOf(result) + value;
                                }
                            }
                        }
                        if ((pos = s.lastIndexOf(pattern1)) > 0) {
                            result = result == null ? replstr1 : String.valueOf(result) + replstr1;
                        }
                        if ((pos = s.lastIndexOf(pattern2)) > 0) {
                            result = result == null ? replstr2 : String.valueOf(result) + replstr2;
                        }
                    } else {
                        result = result == null ? s : String.valueOf(result) + s;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public static String buildResultString(MessageCollection mc, String url, Element element, String type, String state, String pattern1, String replstr1, String pattern2, String replstr2, String pattern3, String replstr3) {
        String nodeName = element.getNodeName().toLowerCase();
        String result = null;
        ArrayList<String> msgs = null;
        ArrayList<String> conditions = null;
        if (mc == null) {
            return null;
        }
        result = OutLoud.getSiteSpecificMessage(mc, element, url);
        if (result != null && result.length() > 0) {
            return result;
        }
        Message msg = mc.getMessage(mc, nodeName, type, state);
        if (msg != null) {
            msgs = msg.getMessages();
            conditions = msg.getConditions();
        }
        if (msg != null) {
            String s = null;
            int i = 0;
            while (i < msgs.size()) {
                if (conditions.size() <= 0) {
                    s = msgs.get(i);
                    if (s.startsWith(VAR)) {
                        String pattern0 = ATTRIBUTE_EQUAL;
                        int pos = s.lastIndexOf(pattern0);
                        if (pos > 0) {
                            s = s.substring(pos + pattern0.length());
                            if ((s = s.substring(0, s.indexOf(GREATER))).length() > 0) {
                                NamedNodeMap attrs = element.getAttributes();
                                String value = null;
                                Node altNode = attrs.getNamedItem(s);
                                value = altNode.getNodeValue();
                                if (value != null && value.length() > 0) {
                                    result = result == null ? value : String.valueOf(result) + value;
                                }
                            }
                        }
                        if ((pos = s.lastIndexOf(pattern1)) > 0) {
                            result = result == null ? replstr1 : String.valueOf(result) + replstr1;
                        }
                        if ((pos = s.lastIndexOf(pattern2)) > 0) {
                            result = result == null ? replstr2 : String.valueOf(result) + replstr2;
                        }
                        if ((pos = s.lastIndexOf(pattern3)) > 0) {
                            result = result == null ? replstr3 : String.valueOf(result) + replstr3;
                        }
                    } else {
                        result = result == null ? s : String.valueOf(result) + s;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    private static String getSiteSpecificMessage(MessageCollection mc, Element element, String url) {
        String result = null;
        Message msg = null;
        if (mc != null && mc.size() > 0) {
            int i = 0;
            while (i < mc.size()) {
                msg = (Message)mc.get(i);
                String nodename = null;
                if (element != null && element.getNodeType() == 1) {
                    nodename = element.getNodeName().toLowerCase();
                }
                if (nodename != null && nodename.equals(msg.getTagName())) {
                    ArrayList<String> conditions = msg.getConditions();
                    ArrayList<String> msgs = msg.getMessages();
                    if (conditions != null && conditions.size() > 0) {
                        boolean found = false;
                        if (url.equals(conditions.get(0))) {
                            int k = 1;
                            while (k < conditions.size()) {
                                String attname = null;
                                String value = null;
                                String a = null;
                                String v = null;
                                found = false;
                                String s = conditions.get(k);
                                attname = s.substring(0, s.indexOf("="));
                                value = s.substring(s.indexOf("=") + 1, s.length());
                                int num = element.getAttributes().getLength();
                                if (num > 0) {
                                    int m = 0;
                                    while (m < num) {
                                        Attr attribute = (Attr)element.getAttributes().item(m);
                                        v = attribute.getNodeValue();
                                        a = attribute.getNodeName();
                                        if (attname.equals(a) && value.equals(v)) {
                                            found = true;
                                            break;
                                        }
                                        ++m;
                                    }
                                }
                                ++k;
                            }
                            if (found) {
                                int j = 0;
                                while (j < msgs.size()) {
                                    result = j == 0 ? msgs.get(j) : String.valueOf(result) + msgs.get(j);
                                    ++j;
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        }
        return result;
    }
}

