/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.views;

import java.util.Vector;
import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.MSAA;
import org.eclipse.actf.util.win32.HighlightComposite;
import org.eclipse.actf.visualization.gui.IGuiViewIDs;
import org.eclipse.actf.visualization.gui.internal.util.GuiImages;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAListView;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAOutlineView;
import org.eclipse.actf.visualization.gui.ui.views.MSAATreeContentProvider;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class MSAAListView
extends ViewPart
implements IMSAAListView {
    private static final String[] HEADINGS = new String[]{"#", Messages.msaa_name, Messages.msaa_role, Messages.msaa_state, "X", "Y", "W", "H"};
    private static final int[] WEIGHTS = new int[]{1, 5, 5, 5, 1, 1, 1, 1};
    private static final int[] ALIGNMENTS = new int[]{131072, 16384, 16384, 16384, 131072, 131072, 131072, 131072};
    private TableViewer viewer;
    private MSAASiblingViewerSorter sorter = new MSAASiblingViewerSorter();
    private boolean suppressHilight = false;
    private Action refreshAction;
    private AccessibleObject objectOnAppear = null;
    private static final MSAATreeContentProvider provider = MSAATreeContentProvider.getDefault();
    private static final Color GRAY_COLOR = Display.getCurrent().getSystemColor(15);

    public void createPartControl(Composite parent) {
        Table table = new Table(parent, 68356);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        int i = 0;
        while (i < HEADINGS.length) {
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(WEIGHTS[i]));
            TableColumn tc = new TableColumn(table, 0);
            tc.setText(HEADINGS[i]);
            tc.setAlignment(ALIGNMENTS[i]);
            tc.setResizable(true);
            final int newSortingColumn = i + 1;
            tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((MSAAListView)MSAAListView.this).sorter.sortingColumn = newSortingColumn == ((MSAAListView)MSAAListView.this).sorter.sortingColumn ? -newSortingColumn : newSortingColumn;
                    MSAAListView.this.viewer.refresh();
                }
            });
            ++i;
        }
        this.viewer = new TableViewer(table);
        MSAASiblingContentAndLabelProvider provider = new MSAASiblingContentAndLabelProvider();
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)provider);
        this.viewer.setSorter((ViewerSorter)this.sorter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedElement;
                if (MSAAListView.this.suppressHilight) {
                    return;
                }
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof AccessibleObject) {
                    AccessibleObject object = (AccessibleObject)selectedElement;
                    IMSAAOutlineView outlineView = (IMSAAOutlineView)MSAAViewRegistory.findView(IGuiViewIDs.ID_OUTLINEVIEW);
                    if (outlineView != null) {
                        outlineView.setSelection(object);
                    } else {
                        HighlightComposite.flashRectangle((Rectangle)object.getAccLocation());
                    }
                }
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        if (MSAAViewRegistory.outlineObject != null) {
            this.setSelection(MSAAViewRegistory.outlineObject);
        }
        HighlightComposite.initOverlayWindow();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
        if (this.objectOnAppear != null) {
            this.setSelection(this.objectOnAppear);
        }
    }

    public void setSelection(AccessibleObject object) {
        AccessibleObject oldInput;
        if (!this.viewer.getControl().isVisible()) {
            this.objectOnAppear = object;
            return;
        }
        this.objectOnAppear = null;
        this.suppressHilight = true;
        AccessibleObject newInput = object.getCachedParent();
        if (newInput != null && (oldInput = (AccessibleObject)this.viewer.getInput()) != newInput) {
            this.viewer.setInput((Object)newInput);
        }
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)object), true);
        this.suppressHilight = false;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MSAAListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.refreshAction);
    }

    private void makeActions() {
        this.refreshAction = new Action(Messages.msaa_refresh){

            public void run() {
                MSAAListView.this.viewer.refresh();
            }
        };
        this.refreshAction.setToolTipText(Messages.msaa_refresh);
        this.refreshAction.setImageDescriptor(GuiImages.IMAGE_REFRESH);
    }

    private class MSAASiblingContentAndLabelProvider
    extends LabelProvider
    implements IStructuredContentProvider,
    IPropertyChangeListener,
    ITableLabelProvider,
    ITableColorProvider {
        private Object[] lastElements;

        public Object[] getElements(Object inputElement) {
            this.lastElements = null;
            if (inputElement instanceof AccessibleObject) {
                Object[] accChildren = provider.getElements(inputElement);
                Vector<Object> childList = new Vector<Object>();
                int i = 0;
                while (i < accChildren.length) {
                    try {
                        int visibleState = ((AccessibleObject)accChildren[i]).getAccState() & 0x18000;
                        if (32768 != visibleState) {
                            childList.add(accChildren[i]);
                        }
                    }
                    catch (Exception exception) {}
                    ++i;
                }
                this.lastElements = childList.toArray();
            }
            return this.lastElements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void propertyChange(PropertyChangeEvent event) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof AccessibleObject) {
                switch (columnIndex) {
                    case 0: {
                        if (this.lastElements != null) {
                            int i = 0;
                            while (i < this.lastElements.length) {
                                if (element.equals(this.lastElements[i])) {
                                    return Integer.toString(i + 1);
                                }
                                ++i;
                            }
                        }
                        return "";
                    }
                    case 1: {
                        return ((AccessibleObject)element).getAccName();
                    }
                    case 2: {
                        return ((AccessibleObject)element).getRoleText();
                    }
                    case 3: {
                        return MSAA.getStateText(((AccessibleObject)element).getAccState());
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        Rectangle location = ((AccessibleObject)element).getAccLocation();
                        if (location == null) {
                            return "";
                        }
                        switch (columnIndex - 4) {
                            case 0: {
                                return Integer.toString(location.x);
                            }
                            case 1: {
                                return Integer.toString(location.y);
                            }
                            case 2: {
                                return Integer.toString(location.width);
                            }
                            case 3: {
                                return Integer.toString(location.height);
                            }
                        }
                    }
                }
                return "?";
            }
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            int accState;
            if (element instanceof AccessibleObject && ((accState = ((AccessibleObject)element).getAccState()) & 0x8000) != 0) {
                return GRAY_COLOR;
            }
            return null;
        }
    }

    private class MSAASiblingViewerSorter
    extends ViewerSorter {
        public int sortingColumn = 0;

        private MSAASiblingViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IBaseLabelProvider labelProvider;
            if (this.sortingColumn != 0 && viewer instanceof TableViewer && (labelProvider = ((TableViewer)viewer).getLabelProvider()) instanceof ITableLabelProvider) {
                int columnIndex = Math.abs(this.sortingColumn) - 1;
                String s1 = ((ITableLabelProvider)labelProvider).getColumnText(e1, columnIndex);
                String s2 = ((ITableLabelProvider)labelProvider).getColumnText(e2, columnIndex);
                int result = 0;
                switch (columnIndex) {
                    default: {
                        try {
                            result = Integer.parseInt(s1) - Integer.parseInt(s2);
                            break;
                        }
                        catch (Exception exception) {}
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        result = this.collator.compare(s1, s2);
                    }
                }
                return this.sortingColumn > 0 ? result : -result;
            }
            return 0;
        }
    }
}

