/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.views;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.AccessibleObjectFactory;
import org.eclipse.actf.accservice.swtbridge.MSAA;
import org.eclipse.actf.accservice.swtbridge.event.IAccessibleEventListener;
import org.eclipse.actf.accservice.swtbridge.event.IAccessibleEventMonitor;
import org.eclipse.actf.accservice.swtbridge.ia2.Accessible2;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleText;
import org.eclipse.actf.accservice.swtbridge.ia2.TextSegment;
import org.eclipse.actf.ai.voice.VoiceUtil;
import org.eclipse.actf.util.win32.WindowUtil;
import org.eclipse.actf.visualization.gui.IGuiViewIDs;
import org.eclipse.actf.visualization.gui.internal.GuiPlugin;
import org.eclipse.actf.visualization.gui.internal.util.GuiImages;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.internal.util.ScreenReaderRenderer;
import org.eclipse.actf.visualization.gui.internal.util.TTSMonitor;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAEventView;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAOutlineView;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSAAEventView
extends ViewPart
implements IMSAAEventView,
IAccessibleEventListener {
    private StyledText text;
    private Action clearAction;
    private Action speakEventAction;
    private Action openPreferencesAction;
    private Action eventFilterAction;
    private Action showTTSEventAction;
    private boolean showRawEvent = false;
    private IPreferenceStore preferenceStore = GuiPlugin.getDefault().getPreferenceStore();
    private static final int[] SUPPORTED_EVENTS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 32768, 32769, 32770, 32771, 32772, 32773, 32774, 32775, 32776, 32777, 32778, 32779, 32780, 32781, 32782, 32783, 32784, 32785, 32786, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290};
    private static final int[] DEFAULT_EVENTS = new int[]{32773};
    private IAccessibleEventMonitor monitor = null;
    private boolean refreshing = false;
    private Map<Integer, Boolean> filters = this.getDefaultFilters();
    private long lastTime = 0L;

    public void createPartControl(Composite parent) {
        this.text = new StyledText(parent, 832);
        this.text.setEditable(false);
        this.text.setLayout((Layout)new GridLayout());
        this.text.setLayoutData((Object)new GridData());
        this.resetFont();
        this.preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("MSAAEventView_Font".equals(event.getProperty())) {
                    MSAAEventView.this.resetFont();
                }
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.reset();
        TTSMonitor.startThread(this);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MSAAEventView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.text);
        this.text.setMenu(menu);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.eventFilterAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.speakEventAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.openPreferencesAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.clearAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.clearAction);
    }

    private void makeActions() {
        this.clearAction = new Action(){

            public void run() {
                MSAAEventView.this.text.setText("");
            }
        };
        this.clearAction.setText(Messages.msaa_clear);
        this.clearAction.setToolTipText(Messages.msaa_clear_tip);
        this.clearAction.setImageDescriptor(GuiImages.IMAGE_CLEAR);
        this.speakEventAction = new Action(Messages.msaa_speak_event, 2){

            public void run() {
            }
        };
        final Shell shell = this.getViewSite().getShell();
        this.openPreferencesAction = new Action(Messages.msaa_preferences){

            public void run() {
                PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.actf.visualization.gui.preferences.GuiPreferencePage", null, null).open();
            }
        };
        this.showTTSEventAction = new Action(Messages.msaa_showTTSEvents, 2){

            public void run() {
            }
        };
        this.showTTSEventAction.setChecked(true);
        this.eventFilterAction = new Action(Messages.msaa_filters_menu){

            public void run() {
                EventFiltersDialog dialog = new EventFiltersDialog(shell, MSAAEventView.this.intArrayToObjectArray(SUPPORTED_EVENTS), MSAAEventView.this.showRawEvent);
                if (dialog.open() == 0) {
                    MSAAEventView.this.filters.clear();
                    Object[] result = dialog.getResult();
                    int i = 0;
                    while (i < result.length) {
                        MSAAEventView.this.filters.put((Integer)result[i], Boolean.TRUE);
                        ++i;
                    }
                    MSAAEventView.this.showRawEvent = dialog.getShowDetails();
                    if (MSAAEventView.this.monitor != null) {
                        MSAAEventView.this.monitor.installEventHook(MSAAEventView.this, MSAAEventView.this.getFilter());
                    }
                }
            }
        };
    }

    private Integer[] intArrayToObjectArray(int[] intArray) {
        Integer[] objArray = new Integer[intArray.length];
        int i = 0;
        while (i < intArray.length) {
            objArray[i] = new Integer(intArray[i]);
            ++i;
        }
        return objArray;
    }

    private void resetFont() {
        FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)this.preferenceStore, (String)"MSAAEventView_Font");
        this.text.setFont(new Font((Device)this.text.getDisplay(), fontData));
    }

    public void setFocus() {
        this.text.setFocus();
    }

    public void dispose() {
        super.dispose();
        TTSMonitor.stopThread();
        if (this.monitor != null) {
            this.monitor.removeEventHook();
            this.monitor = null;
        }
    }

    private void showEventInfo(int event, int hwnd, int idObject, int idChild, AccessibleObject accObject) {
        if (this.text.isDisposed() || this.text.isFocusControl()) {
            return;
        }
        boolean release = false;
        if (accObject == null) {
            accObject = AccessibleObjectFactory.getAccessibleObjectFromEvent(hwnd, idObject, idChild);
            release = true;
        }
        if (accObject != null) {
            boolean ignore;
            int accRole = accObject.getAccRole();
            int accState = accObject.getAccState();
            boolean bl = ignore = (accState & 0x8000) != 0;
            if (!ignore) {
                switch (event) {
                    case 32773: {
                        IMSAAOutlineView outlineView;
                        Accessible2 accExt = accObject.getAccessible2();
                        if (accExt == null || (outlineView = (IMSAAOutlineView)MSAAViewRegistory.findView(IGuiViewIDs.ID_OUTLINEVIEW)) == null) break;
                        AccessibleObject accTarget = MSAAEventView.getCachedChildFromUID(MSAAViewRegistory.rootObject, accExt.getUniqueID());
                        outlineView.setSelection(accTarget);
                        if (accTarget != null) break;
                        release = !MSAAViewRegistory.showProperties(accObject);
                        break;
                    }
                    case 32780: {
                        break;
                    }
                    case 32778: 
                    case 32782: {
                        ignore = (4 & accState) == 0;
                        break;
                    }
                    case 32768: {
                        if (16 == accRole && (MSAAEventView.validate(MSAAViewRegistory.rootObject, 5, 10) || this.delayedRefresh(2000))) break;
                        ignore = true;
                    }
                }
            }
            if (!ignore && this.getFilterEnabled(event)) {
                ScreenReaderRenderer renderer;
                this.checkInterval();
                int buttonIndex = -1;
                if (43 == accRole) {
                    buttonIndex = MSAAEventView.getChildIndex(accObject);
                }
                if (this.showRawEvent) {
                    this.text.append("event=" + MSAA.getEventTypeText(event) + ",  " + "accName=" + accObject.getAccName() + ",  " + "accRole=" + accObject.getRoleText() + ",  " + "accState=" + MSAA.getStateText(accState) + "(0x" + Integer.toHexString(accState) + ")\n");
                }
                String str = null;
                boolean doRender = true;
                switch (event) {
                    case 283: {
                        AccessibleText accText = accObject.getAccessibleText();
                        if (accText != null) {
                            Point selection = accText.getSelection(0);
                            if (selection != null) {
                                str = accText.getTextRange(selection.x, selection.y);
                            } else {
                                TextSegment ts = accText.getTextAtIndex(accText.getCaretPosition(), 0);
                                if (ts != null) {
                                    str = ts.text;
                                }
                            }
                            if (str != null) {
                                this.text.append(" ");
                                StyleRange range = new StyleRange();
                                range.background = Display.getCurrent().getSystemColor(7);
                                range.start = this.text.getCharCount();
                                range.length = str.length();
                                this.text.append(str);
                                this.text.setStyleRange(range);
                            }
                        }
                        doRender = false;
                        break;
                    }
                    case 289: {
                        doRender = false;
                    }
                }
                if (doRender && (str = (renderer = new ScreenReaderRenderer(this.text, null)).renderEvent(event)).length() == 0) {
                    str = renderer.renderItem(accObject, false, buttonIndex);
                }
                this.text.setSelection(this.text.getCharCount());
                if (this.speakEventAction.isChecked() && str != null && str.length() > 0) {
                    VoiceUtil.getVoice().speak(str, true);
                }
            }
            if (release) {
                AccessibleObject parent = accObject.getCachedParent();
                try {
                    if (parent != null) {
                        parent.dispose();
                    } else {
                        accObject.dispose();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean delayedRefresh(int delayMS) {
        if (this.refreshing) {
            return false;
        }
        this.refreshing = true;
        this.text.getDisplay().timerExec(delayMS, new Runnable(){

            public void run() {
                try {
                    if (!MSAAEventView.this.text.isDisposed()) {
                        MSAAViewRegistory.refreshRootObject();
                    }
                }
                finally {
                    MSAAEventView.this.refreshing = false;
                }
            }
        });
        return true;
    }

    private Map<Integer, Boolean> getDefaultFilters() {
        HashMap<Integer, Boolean> defaultFilters = new HashMap<Integer, Boolean>();
        int i = 0;
        while (i < DEFAULT_EVENTS.length) {
            defaultFilters.put(new Integer(DEFAULT_EVENTS[i]), Boolean.TRUE);
            ++i;
        }
        return defaultFilters;
    }

    public boolean getFilterEnabled(int event) {
        Integer key = new Integer(event);
        Boolean enabled = this.filters.get(key);
        if (enabled == null) {
            enabled = Boolean.FALSE;
            this.filters.put(key, enabled);
        }
        return enabled;
    }

    @Override
    public void setTTSText(final String speakText) {
        if (speakText != null && speakText.length() > 0) {
            this.text.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (MSAAEventView.this.text.isFocusControl() || !MSAAEventView.this.showTTSEventAction.isChecked()) {
                        return;
                    }
                    MSAAEventView.this.checkInterval();
                    StyleRange range = new StyleRange();
                    range.foreground = Display.getCurrent().getSystemColor(6);
                    range.start = MSAAEventView.this.text.getCharCount();
                    range.length = speakText.length();
                    MSAAEventView.this.text.append(speakText);
                    MSAAEventView.this.text.setStyleRange(range);
                    MSAAEventView.this.text.setSelection(MSAAEventView.this.text.getCharCount());
                    if (MSAAEventView.this.speakEventAction.isChecked()) {
                        VoiceUtil.getVoice().speak(speakText, true);
                    }
                }
            });
        }
    }

    private void checkInterval() {
        long currentTime = System.currentTimeMillis();
        if (0L != this.lastTime) {
            try {
                long passed = Math.abs(currentTime - this.lastTime);
                if (passed > 1000L) {
                    String separatorString = MessageFormat.format((String)Messages.msaa_ns_passed, (Object[])new Object[]{new Float((float)passed / 1000.0f)});
                    StyleRange range = new StyleRange();
                    range.foreground = Display.getCurrent().getSystemColor(15);
                    range.start = this.text.getCharCount();
                    int lastPos = range.start - 1;
                    if (lastPos > 0 && !"\n".equals(this.text.getText(lastPos, lastPos))) {
                        this.text.append("\n");
                    }
                    this.text.append(separatorString);
                    this.text.append("\n");
                    range.length = this.text.getCharCount() - range.start;
                    this.text.setStyleRange(range);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.lastTime = currentTime;
    }

    @Override
    public void handleEvent(final int event, final int hwnd, final int idObject, final int idChild, final AccessibleObject accObject) {
        if (this.checkShowInfo(event, hwnd)) {
            this.text.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MSAAEventView.this.showEventInfo(event, hwnd, idObject, idChild, accObject);
                }
            });
        }
    }

    private Set<Integer> getFilter() {
        HashSet<Integer> enabledSet = new HashSet<Integer>();
        for (Integer key : this.filters.keySet()) {
            Boolean enabled = this.filters.get(key);
            if (enabled == null || !enabled.booleanValue()) continue;
            enabledSet.add(key);
        }
        enabledSet.add(new Integer(32768));
        return enabledSet;
    }

    private boolean checkShowInfo(int event, int hwnd) {
        int hwndRoot;
        boolean showInfo = false;
        if (MSAAViewRegistory.getUpdateRef() == 0 && MSAAViewRegistory.rootObject != null && MSAA.getEventTypeText(event) != null && (hwndRoot = MSAAViewRegistory.rootObject.getWindow()) != 0) {
            showInfo = 32773 == event && WindowUtil.isPopupMenu((int)hwnd);
            int hwndParent = hwnd;
            while (!showInfo && hwndParent != 0) {
                showInfo = hwndRoot == hwndParent;
                hwndParent = WindowUtil.GetParentWindow((int)hwndParent);
            }
        }
        return showInfo;
    }

    private static AccessibleObject getCachedChildFromUID(AccessibleObject root, int uid) {
        Accessible2 accessible2 = root.getAccessible2();
        if (accessible2 != null && uid == accessible2.getUniqueID()) {
            return root;
        }
        AccessibleObject[] cachedChildren = root.getCachedChildren();
        int i = 0;
        while (i < cachedChildren.length) {
            AccessibleObject accObj = MSAAEventView.getCachedChildFromUID(cachedChildren[i], uid);
            if (accObj != null) {
                return accObj;
            }
            ++i;
        }
        return null;
    }

    private static int getChildIndex(AccessibleObject accObject) {
        AccessibleObject disposeLater = null;
        try {
            AccessibleObject parent = accObject.getCachedParent();
            if (parent == null && (parent = (disposeLater = accObject.getAccParent())) == null) {
                return 0;
            }
            AccessibleObject[] children = parent.getChildren();
            Rectangle myRect = accObject.getAccLocation();
            if (myRect != null) {
                int i = 0;
                while (i < children.length) {
                    if (accObject.equals(children[i]) || myRect.equals((Object)children[i].getAccLocation())) {
                        int n = i;
                        return n;
                    }
                    ++i;
                }
            }
        }
        finally {
            if (disposeLater != null) {
                try {
                    disposeLater.dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return 0;
    }

    private static boolean validate(AccessibleObject accValidate, int depth, int bound) {
        if (accValidate.getAccName() == null && accValidate.getAccLocation() == null && accValidate.getAccKeyboardShortcut() == null) {
            return false;
        }
        AccessibleObject parent = accValidate.getCachedParent();
        AccessibleObject[] children = accValidate.getCachedChildren();
        if (parent == null && children.length == 0) {
            return false;
        }
        if (depth-- > 0) {
            AccessibleObject ao;
            int max = children.length;
            int len = Math.min(max, bound);
            int i = 0;
            while (i < len) {
                ao = children[i];
                if (ao != null && !MSAAEventView.validate(ao, depth, bound)) {
                    return false;
                }
                ++i;
            }
            if ((len = max - len) > 0) {
                i = 0;
                while (i < len) {
                    ao = children[max - 1 - i];
                    if (ao != null && !MSAAEventView.validate(ao, depth, bound)) {
                        return false;
                    }
                    ++i;
                }
            }
        }
        return true;
    }

    @Override
    public void reset() {
        if (this.monitor != null) {
            this.monitor.removeEventHook();
            this.monitor = null;
        }
        this.monitor = AccessibleObjectFactory.getAccessibleEventMonitor();
        if (this.monitor != null) {
            this.monitor.installEventHook(this, this.getFilter());
        }
    }

    class EventFiltersContentProvider
    implements IStructuredContentProvider {
        EventFiltersContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof Integer[]) {
                return (Object[])input;
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object a, Object b) {
        }

        public void dispose() {
        }
    }

    class EventFiltersDialog
    extends ListSelectionDialog {
        private boolean showDetails;
        private Button showDetailsButton;

        public EventFiltersDialog(Shell parentShell, Integer[] input, boolean showDetails) {
            super(parentShell, (Object)input, (IStructuredContentProvider)new EventFiltersContentProvider(), (ILabelProvider)new EventFiltersLabelProvider(), Messages.msaa_filters_message);
            this.setTitle(Messages.msaa_filters_title);
            ArrayList<Integer> initialSelection = new ArrayList<Integer>();
            int i = 0;
            while (i < input.length) {
                if (MSAAEventView.this.getFilterEnabled(input[i])) {
                    initialSelection.add(input[i]);
                }
                ++i;
            }
            this.setInitialElementSelections(initialSelection);
            this.showDetails = showDetails;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Control[] children = composite.getChildren();
            Composite buttonComposite = (Composite)children[children.length - 1];
            Button defaultButton = new Button(buttonComposite, 8);
            defaultButton.setText(Messages.msaa_filters_default);
            defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EventFiltersDialog.this.getViewer().setCheckedElements((Object[])MSAAEventView.this.intArrayToObjectArray(DEFAULT_EVENTS));
                    EventFiltersDialog.this.showDetailsButton.setSelection(false);
                }
            });
            this.showDetailsButton = new Button(composite, 32);
            this.showDetailsButton.setText(Messages.msaa_showRawEvents);
            this.showDetailsButton.setSelection(this.showDetails);
            this.showDetailsButton.setFont(parent.getFont());
            this.showDetailsButton.moveAbove((Control)buttonComposite);
            ++((GridLayout)buttonComposite.getLayout()).numColumns;
            defaultButton.moveAbove(null);
            return composite;
        }

        protected void okPressed() {
            this.showDetails = this.showDetailsButton.getSelection();
            super.okPressed();
        }

        public boolean getShowDetails() {
            return this.showDetails;
        }
    }

    class EventFiltersLabelProvider
    extends LabelProvider {
        EventFiltersLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Integer) {
                return MSAA.getEventTypeText((Integer)element);
            }
            return null;
        }
    }
}

