/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.actions;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import org.eclipse.actf.util.win32.HighlightComposite;
import org.eclipse.actf.util.win32.WindowUtil;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.internal.util.TargetWindow;
import org.eclipse.actf.visualization.gui.internal.util.TargetWindowDataCollector;
import org.eclipse.actf.visualization.gui.preferences.GuiPreferenceManager;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.PlatformUI;

public class WindowListAction
implements IWorkbenchWindowPulldownDelegate2 {
    private boolean switchPerspective = true;
    private IWorkbenchWindow window;
    private MenuListener menuListener = new MenuAdapter(){

        public void menuShown(MenuEvent e) {
            Menu menu = (Menu)e.getSource();
            MenuItem[] items = menu.getItems();
            int i = 0;
            while (i < items.length) {
                items[i].dispose();
                ++i;
            }
            String defaultID = TargetWindow.getID();
            boolean hasEmbedBrowser = false;
            TargetWindowDataCollector collector = new TargetWindowDataCollector();
            String[] categories = collector.getCategories(new CategoryComparator());
            int c = 0;
            while (c < categories.length) {
                String category = categories[c];
                Menu submenu = menu;
                if (category != null) {
                    MenuItem item = new MenuItem(menu, 64);
                    item.setText(category);
                    submenu = new Menu(item);
                    item.setMenu(submenu);
                }
                Object[] elements = collector.getElements(category);
                int i2 = 0;
                while (i2 < elements.length) {
                    Object element = elements[i2];
                    String title = TargetWindow.getTitle(element);
                    if (title != null) {
                        hasEmbedBrowser |= TargetWindow.isEmbeddedBrowser(element);
                        MenuItem item = new MenuItem(submenu, 16);
                        item.setText(title);
                        item.setData(element);
                        if (TargetWindow.getID(element).equals(defaultID)) {
                            item.setSelection(true);
                        }
                        item.addArmListener(WindowListAction.this.armListener);
                        item.addSelectionListener(WindowListAction.this.selectionListener);
                    }
                    ++i2;
                }
                ++c;
            }
            if (categories.length > 0) {
                new MenuItem(menu, 2);
            }
            final MenuItem bringTopItem = new MenuItem(menu, 32);
            bringTopItem.setText(Messages.msaa_bringToTop);
            bringTopItem.setSelection(GuiPreferenceManager.getPreferenceBoolean("AlwaysOnTop"));
            if (TargetWindow.isEmbeddedBrowser()) {
                bringTopItem.setEnabled(false);
            }
            bringTopItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GuiPreferenceManager.setPreference("AlwaysOnTop", bringTopItem.getSelection());
                }
            });
            if (hasEmbedBrowser) {
                final MenuItem switchItem = new MenuItem(menu, 32);
                switchItem.setText(Messages.msaa_switchPerspective);
                switchItem.setSelection(WindowListAction.this.switchPerspective);
                switchItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        WindowListAction.this.switchPerspective = switchItem.getSelection();
                        if (!WindowListAction.this.switchPerspective) {
                            WindowListAction.this.showInternalViewer(true);
                        }
                    }
                });
            }
        }
    };
    private ArmListener armListener = new ArmListener(){

        public void widgetArmed(ArmEvent e) {
            Object element = ((MenuItem)e.getSource()).getData();
            if (element != null) {
                int hwnd = TargetWindow.getRootWindow(element);
                HighlightComposite.flashRectangle((Rectangle)WindowUtil.GetWindowRectangle((int)hwnd));
            }
        }
    };
    private SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            TargetWindow.setCurrentElement(((MenuItem)event.getSource()).getData());
            int hwnd = TargetWindow.getWindowHandle();
            boolean isEmbedded = TargetWindow.isEmbeddedBrowser();
            try {
                if (WindowListAction.setWindowOrder(GuiPreferenceManager.getPreferenceBoolean("AlwaysOnTop"))) {
                    WindowUtil.BringWindowToTop((int)hwnd);
                    WindowUtil.BringWindowToTop((int)hwnd);
                }
                if (WindowListAction.this.switchPerspective) {
                    WindowListAction.this.showInternalViewer(isEmbedded);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            MSAAViewRegistory.refreshRootObject();
        }
    };
    private static final String CATEGORY_BROWSER = Messages.msaa_external_browsers;
    private static final String CATEGORY_WINDOW = Messages.msaa_external_windows;

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
        HighlightComposite.initOverlayWindow();
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        menu.addMenuListener(this.menuListener);
        return menu;
    }

    private void showInternalViewer(boolean bShow) {
        try {
            this.window.getActivePage().setEditorAreaVisible(bShow);
        }
        catch (Exception exception) {}
    }

    public static boolean setWindowOrder(boolean topMost) {
        if (topMost && TargetWindow.isEmbeddedBrowser()) {
            topMost = false;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        WindowUtil.SetWindowPos((int)window.getShell().handle, (int)(topMost ? -1 : -2), (int)0, (int)0, (int)0, (int)0, (int)3);
        return topMost;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CategoryComparator
    implements Comparator<Object> {
        private Collator collator = Collator.getInstance();

        private CategoryComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            int w = this.getWeight(o1);
            int rc = w - this.getWeight(o2);
            return rc == 0 && w == 0 ? this.collator.compare(o1, o2) : rc;
        }

        public int getWeight(Object o) {
            if (o == null) {
                return -1;
            }
            if (CATEGORY_BROWSER.equals(o)) {
                return 1;
            }
            if (CATEGORY_WINDOW.equals(o)) {
                return 2;
            }
            return 0;
        }
    }
}

