/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.msaa.properties.fields;

import org.eclipse.actf.visualization.gui.msaa.properties.fields.AbstractStringField;

public class TextField
extends AbstractStringField {
    private String currValue;
    public int miniLength;
    public int maxLength;

    public TextField(String labelText, String initValue, int miniLength, int maxLength) {
        super(labelText);
        this.currValue = initValue;
        this.miniLength = miniLength;
        this.maxLength = maxLength;
    }

    public TextField(String labelText, String initValue, int miniLength) {
        this(labelText, initValue, miniLength, Integer.MAX_VALUE);
    }

    public TextField(String labelText, String initValue) {
        this(labelText, initValue, 0, Integer.MAX_VALUE);
    }

    public String getStringValue() {
        return this.currValue;
    }

    protected boolean validateControl() {
        String text = this.getText();
        if (text != null) {
            try {
                int length = text.length();
                return length >= this.miniLength && length <= this.maxLength;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public boolean update() {
        if (this.validateControl()) {
            try {
                this.currValue = this.getText();
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }
}

