/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.msaa.properties;

import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.MSAA;
import org.eclipse.actf.visualization.gui.msaa.properties.AbstractPropertyInvokeSource;
import org.eclipse.actf.visualization.gui.msaa.properties.methods.ia1.MsaaDoDefaultActionMethod;
import org.eclipse.actf.visualization.gui.msaa.properties.methods.ia1.MsaaSelectMethod;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class Accessible1PropertySource
extends AbstractPropertyInvokeSource
implements IPropertySource {
    private AccessibleObject accObject;
    private static final String PID_HANDLE = "HANDLE";
    private static final String PID_PARENT = "PARENT";
    private static final String PID_NAME = "NAME";
    private static final String PID_ROLE = "ROLE";
    private static final String PID_STATE = "STATE";
    private static final String PID_VALUE = "VALUE";
    private static final String PID_DESCRIPTION = "DESCRIPTION";
    private static final String PID_CHILDREN = "CHILDREN";
    private static final String PID_DEFAULTACTION = "DEFAULTACTION";
    private static final String PID_LOCATION = "LOCATION";
    private static final String PID_KEYBOARDSHORTCUT = "KEYBOARDSHORTCUT";
    private static final String PID_HELP = "HELP";
    private static final String PID_HELPTOPIC = "HELPTOPIC";
    private static final String PID_DO_DEFAULTACTION = "DO_DEFAULTACTION";
    private static final String PID_SELECT = "SELECT";
    private static final IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"HANDLE", "Window Handle"), new PropertyDescriptor((Object)"PARENT", "Parent"), new PropertyDescriptor((Object)"NAME", "Name"), new PropertyDescriptor((Object)"ROLE", "Role"), new PropertyDescriptor((Object)"STATE", "State"), new PropertyDescriptor((Object)"VALUE", "Value"), new PropertyDescriptor((Object)"DESCRIPTION", "Description"), new PropertyDescriptor((Object)"CHILDREN", "Children"), new PropertyDescriptor((Object)"DEFAULTACTION", "DefaultAction"), new PropertyDescriptor((Object)"LOCATION", "Location"), new PropertyDescriptor((Object)"KEYBOARDSHORTCUT", "Keyboard Shortcut"), new PropertyDescriptor((Object)"HELP", "Help"), new PropertyDescriptor((Object)"HELPTOPIC", "Help Topic")};
    private static final IPropertyDescriptor[] descriptorsEx = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"DO_DEFAULTACTION", "accDoDefaultAction"), new PropertyDescriptor((Object)"SELECT", "accSelect")};

    public Accessible1PropertySource(AccessibleObject input) {
        this.accObject = input;
        this.addMethodData(PID_SELECT, new MsaaSelectMethod(this.accObject));
        this.addMethodData(PID_DO_DEFAULTACTION, new MsaaDoDefaultActionMethod(this.accObject));
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    public IPropertyDescriptor[] getPropertyDescriptorsExtra() {
        return descriptorsEx;
    }

    public Object getPropertyValue(Object id) {
        String[] pFile;
        int[] pIndex;
        Object result = super.getPropertyValue(id);
        if (result != null) {
            return result;
        }
        String strValue = null;
        if (PID_HANDLE.equals(id)) {
            strValue = "0x" + Integer.toHexString(this.accObject.getWindow());
            String wndClass = this.accObject.getClassName();
            if (wndClass != null && wndClass.length() > 0) {
                strValue = String.valueOf(strValue) + " [" + wndClass + "]";
            }
        } else if (PID_PARENT.equals(id)) {
            AccessibleObject pa = this.accObject.getCachedParent();
            if (pa != null) {
                strValue = pa.getAccName();
            }
        } else if (PID_NAME.equals(id)) {
            strValue = this.accObject.getAccName();
        } else if (PID_ROLE.equals(id)) {
            int accRole = this.accObject.getRealAccRole();
            strValue = this.accObject.getRealRoleText();
            if (strValue != null) {
                strValue = String.valueOf(strValue) + " (0x" + Integer.toHexString(accRole) + ")";
            }
        } else if (PID_STATE.equals(id)) {
            int accState = this.accObject.getAccState();
            strValue = MSAA.getStateText(accState);
            if (strValue != null) {
                strValue = String.valueOf(strValue) + " (0x" + Integer.toHexString(accState) + ")";
            }
        } else if (PID_VALUE.equals(id)) {
            strValue = this.accObject.getAccValue();
        } else if (PID_DESCRIPTION.equals(id)) {
            strValue = this.accObject.getAccDescription();
        } else if (PID_CHILDREN.equals(id)) {
            strValue = Integer.toString(this.accObject.getChildCount());
        } else if (PID_DEFAULTACTION.equals(id)) {
            strValue = this.accObject.getAccDefaultAction();
        } else if (PID_LOCATION.equals(id)) {
            Rectangle rect = this.accObject.getAccLocation();
            if (rect != null) {
                strValue = String.valueOf(rect.x) + ", " + rect.y + ", " + (rect.x + rect.width) + ", " + (rect.y + rect.height) + " (width=" + rect.width + ", height=" + rect.height + ")";
            }
        } else if (PID_KEYBOARDSHORTCUT.equals(id)) {
            strValue = this.accObject.getAccKeyboardShortcut();
        } else if (PID_HELP.equals(id)) {
            strValue = this.accObject.getAccHelp();
        } else if (PID_HELPTOPIC.equals(id) && this.accObject.getAccHelpTopic(pIndex = new int[1], pFile = new String[1])) {
            strValue = "Help Topic: Topic #" + pIndex[0];
            if (pFile[0] != null) {
                strValue = String.valueOf(strValue) + " in " + pFile[0];
            }
        }
        return strValue == null ? "null" : strValue;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

