/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.msaa.checker;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.model.flash.util.FlashMSAAUtil;
import org.eclipse.actf.visualization.gui.msaa.checker.MSAAProblem;
import org.eclipse.actf.visualization.gui.msaa.checker.MSAAProblemConst;
import org.eclipse.actf.visualization.gui.ui.views.MSAATreeContentProvider;

public class MSAAProblemChecker
implements MSAAProblemConst {
    private AccessibleObject rootObject;
    private static final MSAATreeContentProvider provider = new MSAATreeContentProvider();

    public MSAAProblemChecker(AccessibleObject accObject) {
        this.rootObject = accObject;
    }

    public MSAAProblem[] getProblems() {
        provider.setShowOffscreen(true);
        provider.setHideHtml(MSAATreeContentProvider.getDefault().isHideHtml());
        return this.getProblem(provider.getElements(this.rootObject), false);
    }

    public MSAAProblem[] getProblem(Object[] children, boolean isFlash) {
        ArrayList<MSAAProblem> problems = new ArrayList<MSAAProblem>();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                AccessibleObject ao = (AccessibleObject)children[i];
                if (ao != null && ((ao.getAccState() & 0x8000) == 0 || (ao.getAccState() & 0x10000) != 0)) {
                    String accName = ao.getAccName();
                    int role = ao.getAccRole();
                    switch (role) {
                        case 9: {
                            if (!FlashMSAAUtil.isFlash((int)ao.getPtr())) break;
                            isFlash = true;
                            break;
                        }
                        case 1: 
                        case 4: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 29: 
                        case 33: 
                        case 35: 
                        case 41: 
                        case 42: 
                        case 60: 
                        case 1054: {
                            break;
                        }
                        case 10: {
                            if (!FlashMSAAUtil.isInvisibleFlash((int)ao.getPtr())) break;
                            problems.add(new MSAAProblem(1, 8, ao));
                            isFlash = true;
                            break;
                        }
                        default: {
                            if (accName != null && accName.length() != 0) break;
                            if (role == 43) {
                                problems.add(new MSAAProblem(1, 0, ao));
                                break;
                            }
                            if (role == 40) {
                                if (isFlash) {
                                    problems.add(new MSAAProblem(1, 9, ao));
                                    break;
                                }
                                problems.add(new MSAAProblem(2, 1, ao));
                                break;
                            }
                            if (role == 46) {
                                problems.add(new MSAAProblem(1, 4, ao));
                                break;
                            }
                            if (role == 24) {
                                problems.add(new MSAAProblem(3, 5, ao));
                                break;
                            }
                            if (role == 30) {
                                String value = ao.getAccValue();
                                if (value == null || value.length() <= 0) break;
                                if (ao.getChildCount() == 0) {
                                    problems.add(new MSAAProblem(1, 6, ao));
                                    break;
                                }
                                AccessibleObject ao1 = ao.getChildren()[0];
                                if (ao1.getAccRole() != 40 || ao1.getAccName() != null && ao1.getAccName().length() != 0) break;
                                problems.add(new MSAAProblem(1, 6, ao));
                                break;
                            }
                            String defaultAction = ao.getAccDefaultAction();
                            if (defaultAction == null || defaultAction.length() == 0) {
                                if (role == 16) {
                                    problems.add(new MSAAProblem(2, 7, ao));
                                    break;
                                }
                                problems.add(new MSAAProblem(2, 3, ao));
                                break;
                            }
                            problems.add(new MSAAProblem(1, 2, ao));
                        }
                    }
                    problems.addAll(Arrays.asList(this.getProblem(provider.getChildren(ao), isFlash)));
                }
                ++i;
            }
        }
        return problems.toArray(new MSAAProblem[problems.size()]);
    }
}

