/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.internal.util;

import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.util.win32.WindowUtil;
import org.eclipse.actf.visualization.gui.TargetWindowDataProvider;
import org.eclipse.actf.visualization.gui.internal.GuiTargetWindowData;
import org.eclipse.actf.visualization.gui.internal.util.TargetWindowDataCollector;
import org.eclipse.actf.visualization.gui.internal.util.WebBrowserUtil;
import org.eclipse.swt.widgets.Composite;

public class TargetWindow {
    private static Object currentElement = null;

    public static void setCurrentElement(Object element) {
        currentElement = element;
    }

    private static void update() {
        if (currentElement == null) {
            TargetWindow.setCurrentElement(TargetWindowDataCollector.getDefaultElement());
        }
    }

    public static boolean isEmbeddedBrowser() {
        TargetWindow.update();
        return TargetWindow.isEmbeddedBrowser(currentElement);
    }

    public static int getWindowHandle() {
        TargetWindow.update();
        return TargetWindow.getWindowHandle(currentElement);
    }

    public static String getID() {
        TargetWindow.update();
        return TargetWindow.getID(currentElement);
    }

    public static int getRootWindow() {
        TargetWindow.update();
        return TargetWindow.getRootWindow(currentElement);
    }

    private static IModelService getModelService(Object element) {
        if (element instanceof IModelService) {
            return (IModelService)element;
        }
        if (element instanceof TargetWindowDataProvider) {
            return ((TargetWindowDataProvider)element).getActiveModelService();
        }
        return null;
    }

    private static int getWindowHandle(Object element) {
        IModelService modelService = TargetWindow.getModelService(element);
        if (modelService != null) {
            Composite composite = modelService.getTargetComposite();
            if (composite != null) {
                return composite.handle;
            }
            Object objHandle = modelService.getAttribute("WindowHandle");
            if (objHandle instanceof Integer) {
                return (Integer)objHandle;
            }
        }
        return 0;
    }

    public static boolean isEmbeddedBrowser(Object element) {
        IModelService modelService = TargetWindow.getModelService(element);
        if (modelService != null) {
            return modelService.getTargetComposite() != null;
        }
        return false;
    }

    private static boolean isBrowser(Object element) {
        IModelService modelService = TargetWindow.getModelService(element);
        if (modelService instanceof GuiTargetWindowData) {
            return ((GuiTargetWindowData)modelService).isBrowser();
        }
        return modelService instanceof IWebBrowserACTF;
    }

    public static String getTitle(Object element) {
        IModelService modelService = TargetWindow.getModelService(element);
        if (modelService != null) {
            return modelService.getTitle();
        }
        return null;
    }

    public static String getID(Object element) {
        IModelService modelService = TargetWindow.getModelService(element);
        if (modelService != null) {
            return modelService.getID();
        }
        return null;
    }

    public static int getRootWindow(Object element) {
        int hwndChild;
        int hwnd = TargetWindow.getWindowHandle(element);
        if (TargetWindow.isBrowser(element) && (hwndChild = TargetWindow.findBrowserChildren(hwnd)) != 0) {
            return hwndChild;
        }
        return hwnd;
    }

    private static int findBrowserChildren(int hwnd) {
        if (hwnd != 0) {
            String className = WindowUtil.GetWindowClassName((int)hwnd);
            if (WebBrowserUtil.isBrowserClass(className)) {
                return hwnd;
            }
            int hwndChild = WindowUtil.GetChildWindow((int)hwnd);
            while (hwndChild != 0) {
                int hwndFound = TargetWindow.findBrowserChildren(hwndChild);
                if (hwndFound != 0) {
                    return hwndFound;
                }
                hwndChild = WindowUtil.GetNextWindow((int)hwndChild);
            }
        }
        return 0;
    }
}

