/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.accservice.swtbridge.internal.ia2;

import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleImage;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleImage;
import org.eclipse.actf.util.win32.NativeIntAccess;
import org.eclipse.actf.util.win32.NativeStringAccess;
import org.eclipse.swt.graphics.Point;

public class InternalAccessibleImage
implements AccessibleImage {
    private IAccessibleImage accessibleImage = null;

    public InternalAccessibleImage(int address) {
        this.accessibleImage = new IAccessibleImage(address);
        this.accessibleImage.AddRef();
    }

    public void dispose() {
        if (this.accessibleImage != null) {
            this.accessibleImage.Release();
            this.accessibleImage = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public String getAccessibleImageDescription() {
        if (this.accessibleImage != null) {
            NativeStringAccess nsa = new NativeStringAccess();
            try {
                if (this.accessibleImage.get_description(nsa.getAddress()) == 0) {
                    String string = nsa.getString();
                    return string;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nsa.dispose();
            }
        }
        return null;
    }

    public Point getAccessibleImagePosition(int coordinateType) {
        if (this.accessibleImage != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleImage.get_imagePosition(coordinateType, nia.getAddress(0), nia.getAddress(1)) == 0) {
                    Point point = new Point(nia.getInt(0), nia.getInt(1));
                    return point;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public Point getAccessibleImageSize() {
        if (this.accessibleImage != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleImage.get_imageSize(nia.getAddress(0), nia.getAddress(1)) == 0) {
                    Point point = new Point(nia.getInt(0), nia.getInt(1));
                    return point;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }
}

