/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.accservice.swtbridge.internal;

import java.util.HashMap;
import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.IAccessible;
import org.eclipse.actf.accservice.swtbridge.IServiceProvider;
import org.eclipse.actf.accservice.swtbridge.MSAA;
import org.eclipse.actf.accservice.swtbridge.ia2.Accessible2;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleAction;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleApplication;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleComponent;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleEditableText;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleHyperlink;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleHypertext;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleImage;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleTable;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleText;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleValue;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessible2;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleAction;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleApplication;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleComponent;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleEditableText;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleHyperlink;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleHypertext;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleImage;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleTable;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleText;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleValue;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessible2;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleAction;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleApplication;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleComponent;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleEditableText;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleHyperlink;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleHypertext;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleImage;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleTable;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleText;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleValue;
import org.eclipse.actf.util.win32.NativeIntAccess;
import org.eclipse.actf.util.win32.NativeStringAccess;
import org.eclipse.actf.util.win32.NativeVariantAccess;
import org.eclipse.actf.util.win32.WindowUtil;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.ole.win32.Variant;

public class InternalAccessibleObject
implements AccessibleObject {
    private InternalAccessibleObject parent = null;
    private Variant varChildIndex = null;
    private IAccessible iAccessible = null;
    private Accessible2 accessible2 = null;
    private AccessibleAction accessibleAction = null;
    private AccessibleApplication accessibleApplication = null;
    private AccessibleComponent accessibleComponent = null;
    private AccessibleEditableText accessibleEditableText = null;
    private AccessibleHyperlink accessibleHyperlink = null;
    private AccessibleHypertext accessibleHypertext = null;
    private AccessibleImage accessibleImage = null;
    private AccessibleTable accessibleTable = null;
    private AccessibleText accessibleText = null;
    private AccessibleValue accessibleValue = null;
    private HashMap<String, InternalAccessibleObject> childMap = new HashMap();
    private InternalAccessibleObject[] cachedChildren = new InternalAccessibleObject[0];
    private boolean disposed = false;
    private int accRole;
    private int ia1Role;
    private int ia2Role;
    private int accWindow;
    private String strClassName;
    private static final String STR_NULL = null;

    private InternalAccessibleObject(int address) {
        this(null, new Variant(new IDispatch(address)));
    }

    public InternalAccessibleObject(InternalAccessibleObject parent, Variant varChild) {
        this.parent = parent;
        this.varChildIndex = varChild;
        switch (varChild.getType()) {
            case 3: {
                varChild = parent.getAccChild(varChild);
                if (varChild == null || 9 != varChild.getType()) break;
            }
            case 9: {
                int[] ppvObject = new int[1];
                int[] ppvServiceProvider = new int[1];
                if (varChild.getDispatch().QueryInterface(IServiceProvider.IID, ppvServiceProvider) == 0) {
                    IServiceProvider sp = new IServiceProvider(ppvServiceProvider[0]);
                    try {
                        if (sp.QueryService(IAccessible.IID, IAccessible2.IID, ppvObject) == 0) {
                            this.iAccessible = new IAccessible2(ppvObject[0]);
                            this.iAccessible.AddRef();
                            this.accessible2 = new InternalAccessible2((IAccessible2)this.iAccessible);
                            if (sp.QueryService(IAccessible.IID, IAccessibleAction.IID, ppvObject) == 0) {
                                this.accessibleAction = new InternalAccessibleAction(ppvObject[0]);
                            }
                            if (sp.QueryService(IAccessible.IID, IAccessibleApplication.IID, ppvObject) == 0) {
                                this.accessibleApplication = new InternalAccessibleApplication(ppvObject[0]);
                            }
                            if (sp.QueryService(IAccessible.IID, IAccessibleComponent.IID, ppvObject) == 0) {
                                this.accessibleComponent = new InternalAccessibleComponent(ppvObject[0]);
                            }
                            if (sp.QueryService(IAccessible.IID, IAccessibleEditableText.IID, ppvObject) == 0) {
                                this.accessibleEditableText = new InternalAccessibleEditableText(ppvObject[0]);
                            }
                            if (sp.QueryService(IAccessible.IID, IAccessibleHyperlink.IID, ppvObject) == 0) {
                                this.accessibleHyperlink = new InternalAccessibleHyperlink(ppvObject[0]);
                            }
                            if (sp.QueryService(IAccessible.IID, IAccessibleHypertext.IID, ppvObject) == 0) {
                                this.accessibleHypertext = new InternalAccessibleHypertext(ppvObject[0]);
                            }
                            if (sp.QueryService(IAccessible.IID, IAccessibleImage.IID, ppvObject) == 0) {
                                this.accessibleImage = new InternalAccessibleImage(ppvObject[0]);
                            }
                            if (sp.QueryService(IAccessible.IID, IAccessibleTable.IID, ppvObject) == 0) {
                                this.accessibleTable = new InternalAccessibleTable(ppvObject[0]);
                            }
                            if (sp.QueryService(IAccessible.IID, IAccessibleText.IID, ppvObject) == 0) {
                                this.accessibleText = new InternalAccessibleText(ppvObject[0]);
                            }
                            if (sp.QueryService(IAccessible.IID, IAccessibleValue.IID, ppvObject) == 0) {
                                this.accessibleValue = new InternalAccessibleValue(ppvObject[0]);
                            }
                        } else if (sp.QueryService(IAccessible.IID, IAccessible.IID, ppvObject) == 0) {
                            this.iAccessible = new IAccessible(ppvObject[0]);
                            this.iAccessible.AddRef();
                        }
                    }
                    finally {
                        sp.Release();
                    }
                }
                if (this.iAccessible == null) {
                    if (varChild.getDispatch().QueryInterface(IAccessible.IID, ppvObject) == 0) {
                        this.iAccessible = new IAccessible(ppvObject[0]);
                        this.iAccessible.AddRef();
                    } else {
                        System.out.println("Error: Can not get IAccessible");
                    }
                }
                this.varChildIndex = new Variant(0);
                varChild.dispose();
            }
        }
        this.reset();
    }

    public void reset() {
        this.disposeChildren();
        NativeVariantAccess nva = new NativeVariantAccess();
        try {
            if (this.getIAccessible().get_accRole(3, 0, this.varChildIndex.getInt(), 0, nva.getAddress()) == 0) {
                this.accRole = nva.getInt();
            }
        }
        finally {
            nva.dispose();
        }
        this.accWindow = -1;
        this.strClassName = null;
        this.ia1Role = this.accRole;
        this.ia2Role = -1;
        Accessible2 ia2 = this.getAccessible2();
        if (ia2 != null) {
            this.ia2Role = this.accRole = ia2.getAccessibleRole();
        }
    }

    public void dispose() throws Exception {
        if (this.disposed) {
            throw new Exception("Already disposed");
        }
        this.disposed = true;
        this.disposeChildren();
        if (this.iAccessible != null) {
            this.iAccessible.Release();
            this.iAccessible = null;
        }
        if (this.accessible2 != null) {
            this.accessible2.dispose();
            this.accessible2 = null;
        }
        if (this.accessibleAction != null) {
            this.accessibleAction.dispose();
            this.accessibleAction = null;
        }
        if (this.accessibleApplication != null) {
            this.accessibleApplication.dispose();
            this.accessibleApplication = null;
        }
        if (this.accessibleComponent != null) {
            this.accessibleComponent.dispose();
            this.accessibleComponent = null;
        }
        if (this.accessibleEditableText != null) {
            this.accessibleEditableText.dispose();
            this.accessibleEditableText = null;
        }
        if (this.accessibleHyperlink != null) {
            this.accessibleHyperlink.dispose();
            this.accessibleHyperlink = null;
        }
        if (this.accessibleHypertext != null) {
            this.accessibleHypertext.dispose();
            this.accessibleHypertext = null;
        }
        if (this.accessibleImage != null) {
            this.accessibleImage.dispose();
            this.accessibleImage = null;
        }
        if (this.accessibleTable != null) {
            this.accessibleTable.dispose();
            this.accessibleTable = null;
        }
        if (this.accessibleText != null) {
            this.accessibleText.dispose();
            this.accessibleText = null;
        }
        if (this.accessibleValue != null) {
            this.accessibleValue.dispose();
            this.accessibleValue = null;
        }
        if (this.varChildIndex != null) {
            this.varChildIndex.dispose();
            this.varChildIndex = null;
        }
        if (this.parent != null) {
            this.parent.removeChildObject(this);
        }
    }

    private void disposeChildren() {
        this.cachedChildren = new InternalAccessibleObject[0];
        InternalAccessibleObject[] children = this.childMap.values().toArray(new InternalAccessibleObject[this.childMap.size()]);
        int i = 0;
        while (i < children.length) {
            try {
                children[i].dispose();
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    public static AccessibleObject getAccessibleObjectFromPoint(Point point) {
        int[] pChild = new int[1];
        int address = MSAA.getAccessibleObjectFromPoint(point, pChild);
        return InternalAccessibleObject.newInstance(address, pChild[0]);
    }

    public static AccessibleObject getAccessibleObjectFromWindow(int hwnd) {
        int address = MSAA.AccessibleObjectFromWindow(hwnd);
        return InternalAccessibleObject.newInstance(address);
    }

    public static AccessibleObject getAccessibleObjectFromEvent(int hwnd, int dwId, int dwChildId) {
        int[] pChild = new int[1];
        int address = MSAA.getAccessibleObjectFromEvent(hwnd, dwId, dwChildId, pChild);
        return InternalAccessibleObject.newInstance(address, pChild[0]);
    }

    public static AccessibleObject newInstance(int address) {
        if (address == 0) {
            return null;
        }
        return new InternalAccessibleObject(address);
    }

    private static AccessibleObject newInstance(int address, int childId) {
        AccessibleObject accObject = InternalAccessibleObject.newInstance(address);
        if (accObject != null && childId != 0) {
            return ((InternalAccessibleObject)accObject).getChildObject(new Variant(childId));
        }
        return accObject;
    }

    public AccessibleObject getCachedParent() {
        return this.parent;
    }

    public AccessibleObject[] getCachedChildren() {
        return this.cachedChildren;
    }

    public AccessibleObject[] getChildren() {
        int childCount = Math.max(0, this.getChildCount());
        if (childCount == this.cachedChildren.length) {
            return this.cachedChildren;
        }
        if (childCount > 32768) {
            System.err.println("Too many children(" + childCount + "), we don't fectch.");
            if (this.accessibleTable != null) {
                int nRows = this.accessibleTable.getAccessibleRowCount();
                int nCols = this.accessibleTable.getAccessibleColumnCount();
                if (65536 == nRows && 256 == nCols) {
                    if (256 == this.cachedChildren.length) {
                        return this.cachedChildren;
                    }
                    this.cachedChildren = new InternalAccessibleObject[256];
                    int row = 0;
                    while (row < 16) {
                        int col = 0;
                        while (col < 16) {
                            InternalAccessibleObject cell = (InternalAccessibleObject)this.accessibleTable.getAccessibleCellAt(row, col);
                            cell.parent = this;
                            this.cachedChildren[row * 16 + col] = cell;
                            ++col;
                        }
                        ++row;
                    }
                    System.err.println("getChildren() returned 256(16x16) table cells.");
                    return this.cachedChildren;
                }
            }
            return new InternalAccessibleObject[0];
        }
        this.cachedChildren = new InternalAccessibleObject[childCount];
        if (childCount > 0) {
            Variant[] varChildren = new Variant[childCount];
            MSAA.getAccessibleChildren(this.getIAccessible().getAddress(), varChildren);
            int i = 0;
            while (i < childCount) {
                if (varChildren[i] != null) {
                    this.cachedChildren[i] = this.getChildObject(varChildren[i]);
                }
                ++i;
            }
        }
        return this.cachedChildren;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getChildCount() {
        try {
            if (this.varChildIndex.getInt() != 0) return 0;
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.getIAccessible().get_accChildCount(nia.getAddress()) != 0) return 0;
                int n = nia.getInt();
                return n;
            }
            finally {
                nia.dispose();
            }
        }
        catch (Exception exception) {}
        return 0;
    }

    public int getWindow() {
        if (-1 == this.accWindow) {
            try {
                this.accWindow = MSAA.WindowFromAccessibleObject(this.getIAccessible().getAddress());
            }
            catch (Exception exception) {
                this.accWindow = 0;
            }
        }
        return this.accWindow;
    }

    public int getAccRole() {
        return this.accRole;
    }

    public String getRoleText() {
        block5: {
            if (-1 == this.accRole) {
                NativeVariantAccess nva = new NativeVariantAccess();
                try {
                    if (this.getIAccessible().get_accRole(3, 0, this.varChildIndex.getInt(), 0, nva.getAddress()) == 0) {
                        String string = nva.getString();
                        return string;
                    }
                    break block5;
                }
                finally {
                    nva.dispose();
                }
            }
            return MSAA.getRoleText(this.accRole);
        }
        return STR_NULL;
    }

    public String getClassName() {
        if (this.strClassName == null) {
            int hwnd = this.getWindow();
            this.strClassName = STR_NULL;
            if (hwnd != 0) {
                this.strClassName = WindowUtil.GetWindowClassName((int)hwnd);
            }
        }
        return this.strClassName;
    }

    public int getAccState() {
        NativeVariantAccess nva = new NativeVariantAccess();
        try {
            if (this.getIAccessible().get_accState(3, 0, this.varChildIndex.getInt(), 0, nva.getAddress()) == 0) {
                int n = nva.getInt();
                return n;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nva.dispose();
        }
        return 0;
    }

    public String getAccName() {
        NativeStringAccess nsa = new NativeStringAccess();
        try {
            if (this.getIAccessible().get_accName(3, 0, this.varChildIndex.getInt(), 0, nsa.getAddress()) == 0) {
                String string = nsa.getString();
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nsa.dispose();
        }
        return STR_NULL;
    }

    public String getAccValue() {
        NativeStringAccess nsa = new NativeStringAccess();
        try {
            if (this.getIAccessible().get_accValue(3, 0, this.varChildIndex.getInt(), 0, nsa.getAddress()) == 0) {
                String string = nsa.getString();
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nsa.dispose();
        }
        return STR_NULL;
    }

    public String getAccDescription() {
        NativeStringAccess nsa = new NativeStringAccess();
        try {
            if (this.getIAccessible().get_accDescription(3, 0, this.varChildIndex.getInt(), 0, nsa.getAddress()) == 0) {
                String string = nsa.getString();
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nsa.dispose();
        }
        return STR_NULL;
    }

    public String getAccHelp() {
        NativeStringAccess nsa = new NativeStringAccess();
        try {
            if (this.getIAccessible().get_accHelp(3, 0, this.varChildIndex.getInt(), 0, nsa.getAddress()) == 0) {
                String string = nsa.getString();
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nsa.dispose();
        }
        return STR_NULL;
    }

    public String getAccKeyboardShortcut() {
        NativeStringAccess nsa = new NativeStringAccess();
        try {
            if (this.getIAccessible().get_accKeyboardShortcut(3, 0, this.varChildIndex.getInt(), 0, nsa.getAddress()) == 0) {
                String string = nsa.getString();
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nsa.dispose();
        }
        return STR_NULL;
    }

    public String getAccDefaultAction() {
        NativeStringAccess nsa = new NativeStringAccess();
        try {
            if (this.getIAccessible().get_accDefaultAction(3, 0, this.varChildIndex.getInt(), 0, nsa.getAddress()) == 0) {
                String string = nsa.getString();
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nsa.dispose();
        }
        return STR_NULL;
    }

    public boolean getAccHelpTopic(int[] pTopicIndex, String[] pHelpFile) {
        NativeStringAccess nsa = new NativeStringAccess();
        NativeIntAccess nia = new NativeIntAccess();
        try {
            if (this.getIAccessible().get_accHelpTopic(nsa.getAddress(), 3, 0, this.varChildIndex.getInt(), 0, nia.getAddress()) == 0) {
                pTopicIndex[0] = nia.getInt();
                pHelpFile[0] = nsa.getString();
                return true;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nia.dispose();
            nsa.dispose();
        }
        return false;
    }

    public Rectangle getAccLocation() {
        if (this.disposed) {
            return null;
        }
        NativeIntAccess nia = new NativeIntAccess(4);
        try {
            if (this.getIAccessible().accLocation(nia.getAddress(0), nia.getAddress(1), nia.getAddress(2), nia.getAddress(3), 3, 0, this.varChildIndex.getInt(), 0) == 0) {
                Rectangle rectangle = new Rectangle(nia.getInt(0), nia.getInt(1), nia.getInt(2), nia.getInt(3));
                return rectangle;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nia.dispose();
        }
        return null;
    }

    public boolean doDefaultAction() {
        return this.getIAccessible().accDoDefaultAction(3, 0, this.varChildIndex.getInt(), 0) == 0;
    }

    public boolean select(int flagsSelect) {
        return this.getIAccessible().accSelect(flagsSelect, 3, 0, this.varChildIndex.getInt(), 0) == 0;
    }

    public boolean setAccName(String strName) {
        NativeStringAccess nsa = new NativeStringAccess();
        try {
            nsa.setString(strName);
            boolean bl = this.getIAccessible().put_accName(3, 0, this.varChildIndex.getInt(), 0, nsa.getAddress()) == 0;
            return bl;
        }
        finally {
            nsa.dispose();
        }
    }

    public boolean setAccValue(String strValue) {
        NativeStringAccess nsa = new NativeStringAccess();
        try {
            nsa.setString(strValue);
            boolean bl = this.getIAccessible().put_accValue(3, 0, this.varChildIndex.getInt(), 0, nsa.getAddress()) == 0;
            return bl;
        }
        finally {
            nsa.dispose();
        }
    }

    public AccessibleObject getAccParent() {
        NativeIntAccess nia = new NativeIntAccess();
        try {
            if (this.getIAccessible().get_accParent(nia.getAddress()) == 0) {
                AccessibleObject accessibleObject = InternalAccessibleObject.newInstance(nia.getInt());
                return accessibleObject;
            }
        }
        finally {
            nia.dispose();
        }
        return null;
    }

    private Variant getAccChild(Variant varChild) {
        NativeIntAccess nia = new NativeIntAccess();
        try {
            if (this.getIAccessible().get_accChild(3, 0, varChild.getInt(), 0, nia.getAddress()) == 0) {
                Variant variant = new Variant(new IDispatch(nia.getInt()));
                return variant;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nia.dispose();
        }
        return null;
    }

    public IAccessible getIAccessible() {
        if (this.iAccessible != null) {
            return this.iAccessible;
        }
        if (this.parent != null) {
            return this.parent.getIAccessible();
        }
        return null;
    }

    public Accessible2 getAccessible2() {
        if (this.accessible2 != null) {
            return this.accessible2;
        }
        if (this.parent != null) {
            return this.parent.getAccessible2();
        }
        return null;
    }

    public AccessibleAction getAccessibleAction() {
        if (this.accessibleAction != null) {
            return this.accessibleAction;
        }
        if (this.parent != null) {
            return this.parent.getAccessibleAction();
        }
        return null;
    }

    public AccessibleApplication getAccessibleApplication() {
        if (this.accessibleApplication != null) {
            return this.accessibleApplication;
        }
        if (this.parent != null) {
            return this.parent.getAccessibleApplication();
        }
        return null;
    }

    public AccessibleComponent getAccessibleComponent() {
        if (this.accessibleComponent != null) {
            return this.accessibleComponent;
        }
        if (this.parent != null) {
            return this.parent.getAccessibleComponent();
        }
        return null;
    }

    public AccessibleEditableText getAccessibleEditableText() {
        if (this.accessibleEditableText != null) {
            return this.accessibleEditableText;
        }
        if (this.parent != null) {
            return this.parent.getAccessibleEditableText();
        }
        return null;
    }

    public AccessibleHyperlink getAccessibleHyperlink() {
        if (this.accessibleHyperlink != null) {
            return this.accessibleHyperlink;
        }
        if (this.parent != null) {
            return this.parent.getAccessibleHyperlink();
        }
        return null;
    }

    public AccessibleHypertext getAccessibleHypertext() {
        if (this.accessibleHypertext != null) {
            return this.accessibleHypertext;
        }
        if (this.parent != null) {
            return this.parent.getAccessibleHypertext();
        }
        return null;
    }

    public AccessibleImage getAccessibleImage() {
        if (this.accessibleImage != null) {
            return this.accessibleImage;
        }
        if (this.parent != null) {
            return this.parent.getAccessibleImage();
        }
        return null;
    }

    public AccessibleTable getAccessibleTable() {
        if (this.accessibleTable != null) {
            return this.accessibleTable;
        }
        if (this.parent != null) {
            return this.parent.getAccessibleTable();
        }
        return null;
    }

    public AccessibleText getAccessibleText() {
        if (this.accessibleText != null) {
            return this.accessibleText;
        }
        if (this.parent != null) {
            return this.parent.getAccessibleText();
        }
        return null;
    }

    public AccessibleValue getAccessibleValue() {
        if (this.accessibleValue != null) {
            return this.accessibleValue;
        }
        if (this.parent != null) {
            return this.parent.getAccessibleValue();
        }
        return null;
    }

    private InternalAccessibleObject getChildObject(Variant varChild) {
        String key = varChild.toString();
        InternalAccessibleObject accObject = this.childMap.get(key);
        if (accObject == null) {
            accObject = new InternalAccessibleObject(this, varChild);
            this.childMap.put(key, accObject);
            if (accObject.checkInactiveControl()) {
                accObject.reset();
            }
        }
        return accObject;
    }

    private void removeChildObject(InternalAccessibleObject accObject) {
        for (String key : this.childMap.keySet()) {
            if (accObject != this.childMap.get(key)) continue;
            this.childMap.remove(key);
            break;
        }
    }

    private boolean checkInactiveControl() {
        if ("Inactive Control".equals(this.getAccName()) && 43 == this.getAccRole()) {
            return this.doDefaultAction();
        }
        return false;
    }

    protected void finalize() throws Throwable {
        if (!this.disposed) {
            this.dispose();
        }
        super.finalize();
    }

    public String toString() {
        if (this.disposed) {
            return String.valueOf(super.toString()) + " disposed";
        }
        return "AccessibleObject role=" + this.getRoleText() + ", name=" + this.getAccName() + ", state=" + this.getAccState() + ", location=" + this.getAccLocation();
    }

    public int getRealAccRole() {
        return this.ia1Role;
    }

    public String getRealRoleText() {
        block5: {
            if (-1 == this.ia1Role) {
                NativeVariantAccess nva = new NativeVariantAccess();
                try {
                    if (this.getIAccessible().get_accRole(3, 0, this.varChildIndex.getInt(), 0, nva.getAddress()) == 0) {
                        String string = nva.getString();
                        return string;
                    }
                    break block5;
                }
                finally {
                    nva.dispose();
                }
            }
            return MSAA.getRoleText(this.ia1Role);
        }
        return STR_NULL;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public int getPtr() {
        return this.getIAccessible().getAddress();
    }
}

