/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.accservice.swtbridge;

import org.eclipse.actf.accservice.swtbridge.IA2;
import org.eclipse.actf.util.win32.NativeVariantAccess;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.ole.win32.Variant;

public class MSAA {
    public static final int CHILDID_SELF = 0;
    public static final int ROLE_SYSTEM_TITLEBAR = 1;
    public static final int ROLE_SYSTEM_MENUBAR = 2;
    public static final int ROLE_SYSTEM_SCROLLBAR = 3;
    public static final int ROLE_SYSTEM_GRIP = 4;
    public static final int ROLE_SYSTEM_SOUND = 5;
    public static final int ROLE_SYSTEM_CURSOR = 6;
    public static final int ROLE_SYSTEM_CARET = 7;
    public static final int ROLE_SYSTEM_ALERT = 8;
    public static final int ROLE_SYSTEM_WINDOW = 9;
    public static final int ROLE_SYSTEM_CLIENT = 10;
    public static final int ROLE_SYSTEM_MENUPOPUP = 11;
    public static final int ROLE_SYSTEM_MENUITEM = 12;
    public static final int ROLE_SYSTEM_TOOLTIP = 13;
    public static final int ROLE_SYSTEM_APPLICATION = 14;
    public static final int ROLE_SYSTEM_DOCUMENT = 15;
    public static final int ROLE_SYSTEM_PANE = 16;
    public static final int ROLE_SYSTEM_CHART = 17;
    public static final int ROLE_SYSTEM_DIALOG = 18;
    public static final int ROLE_SYSTEM_BORDER = 19;
    public static final int ROLE_SYSTEM_GROUPING = 20;
    public static final int ROLE_SYSTEM_SEPARATOR = 21;
    public static final int ROLE_SYSTEM_TOOLBAR = 22;
    public static final int ROLE_SYSTEM_STATUSBAR = 23;
    public static final int ROLE_SYSTEM_TABLE = 24;
    public static final int ROLE_SYSTEM_COLUMNHEADER = 25;
    public static final int ROLE_SYSTEM_ROWHEADER = 26;
    public static final int ROLE_SYSTEM_COLUMN = 27;
    public static final int ROLE_SYSTEM_ROW = 28;
    public static final int ROLE_SYSTEM_CELL = 29;
    public static final int ROLE_SYSTEM_LINK = 30;
    public static final int ROLE_SYSTEM_HELPBALLOON = 31;
    public static final int ROLE_SYSTEM_CHARACTER = 32;
    public static final int ROLE_SYSTEM_LIST = 33;
    public static final int ROLE_SYSTEM_LISTITEM = 34;
    public static final int ROLE_SYSTEM_OUTLINE = 35;
    public static final int ROLE_SYSTEM_OUTLINEITEM = 36;
    public static final int ROLE_SYSTEM_PAGETAB = 37;
    public static final int ROLE_SYSTEM_PROPERTYPAGE = 38;
    public static final int ROLE_SYSTEM_INDICATOR = 39;
    public static final int ROLE_SYSTEM_GRAPHIC = 40;
    public static final int ROLE_SYSTEM_STATICTEXT = 41;
    public static final int ROLE_SYSTEM_TEXT = 42;
    public static final int ROLE_SYSTEM_PUSHBUTTON = 43;
    public static final int ROLE_SYSTEM_CHECKBUTTON = 44;
    public static final int ROLE_SYSTEM_RADIOBUTTON = 45;
    public static final int ROLE_SYSTEM_COMBOBOX = 46;
    public static final int ROLE_SYSTEM_DROPLIST = 47;
    public static final int ROLE_SYSTEM_PROGRESSBAR = 48;
    public static final int ROLE_SYSTEM_DIAL = 49;
    public static final int ROLE_SYSTEM_HOTKEYFIELD = 50;
    public static final int ROLE_SYSTEM_SLIDER = 51;
    public static final int ROLE_SYSTEM_SPINBUTTON = 52;
    public static final int ROLE_SYSTEM_DIAGRAM = 53;
    public static final int ROLE_SYSTEM_ANIMATION = 54;
    public static final int ROLE_SYSTEM_EQUATION = 55;
    public static final int ROLE_SYSTEM_BUTTONDROPDOWN = 56;
    public static final int ROLE_SYSTEM_BUTTONMENU = 57;
    public static final int ROLE_SYSTEM_BUTTONDROPDOWNGRID = 58;
    public static final int ROLE_SYSTEM_WHITESPACE = 59;
    public static final int ROLE_SYSTEM_PAGETABLIST = 60;
    public static final int ROLE_SYSTEM_CLOCK = 61;
    public static final int ROLE_SYSTEM_SPLITBUTTON = 62;
    public static final int ROLE_SYSTEM_IPADDRESS = 63;
    public static final int ROLE_SYSTEM_OUTLINEBUTTON = 64;
    public static final int STATE_NORMAL = 0;
    public static final int STATE_SELECTED = 2;
    public static final int STATE_SELECTABLE = 0x200000;
    public static final int STATE_MULTISELECTABLE = 0x1000000;
    public static final int STATE_FOCUSED = 4;
    public static final int STATE_FOCUSABLE = 0x100000;
    public static final int STATE_PRESSED = 8;
    public static final int STATE_CHECKED = 16;
    public static final int STATE_EXPANDED = 512;
    public static final int STATE_COLLAPSED = 1024;
    public static final int STATE_HOTTRACKED = 128;
    public static final int STATE_BUSY = 2048;
    public static final int STATE_READONLY = 64;
    public static final int STATE_INVISIBLE = 32768;
    public static final int STATE_OFFSCREEN = 65536;
    public static final int STATE_SIZEABLE = 131072;
    public static final int STATE_LINKED = 0x400000;
    public static final int STATE_SYSTEM_UNAVAILABLE = 1;
    public static final int EVENT_SYSTEM_SOUND = 1;
    public static final int EVENT_SYSTEM_ALERT = 2;
    public static final int EVENT_SYSTEM_FOREGROUND = 3;
    public static final int EVENT_SYSTEM_MENUSTART = 4;
    public static final int EVENT_SYSTEM_MENUEND = 5;
    public static final int EVENT_SYSTEM_MENUPOPUPSTART = 6;
    public static final int EVENT_SYSTEM_MENUPOPUPEND = 7;
    public static final int EVENT_SYSTEM_CAPTURESTART = 8;
    public static final int EVENT_SYSTEM_CAPTUREEND = 9;
    public static final int EVENT_SYSTEM_MOVESIZESTART = 10;
    public static final int EVENT_SYSTEM_MOVESIZEEND = 11;
    public static final int EVENT_SYSTEM_CONTEXTHELPSTART = 12;
    public static final int EVENT_SYSTEM_CONTEXTHELPEND = 13;
    public static final int EVENT_SYSTEM_DRAGDROPSTART = 14;
    public static final int EVENT_SYSTEM_DRAGDROPEND = 15;
    public static final int EVENT_SYSTEM_DIALOGSTART = 16;
    public static final int EVENT_SYSTEM_DIALOGEND = 17;
    public static final int EVENT_SYSTEM_SCROLLINGSTART = 18;
    public static final int EVENT_SYSTEM_SCROLLINGEND = 19;
    public static final int EVENT_SYSTEM_SWITCHSTART = 20;
    public static final int EVENT_SYSTEM_SWITCHEND = 21;
    public static final int EVENT_SYSTEM_MINIMIZESTART = 22;
    public static final int EVENT_SYSTEM_MINIMIZEEND = 23;
    public static final int EVENT_OBJECT_CREATE = 32768;
    public static final int EVENT_OBJECT_DESTROY = 32769;
    public static final int EVENT_OBJECT_SHOW = 32770;
    public static final int EVENT_OBJECT_HIDE = 32771;
    public static final int EVENT_OBJECT_REORDER = 32772;
    public static final int EVENT_OBJECT_FOCUS = 32773;
    public static final int EVENT_OBJECT_SELECTION = 32774;
    public static final int EVENT_OBJECT_SELECTIONADD = 32775;
    public static final int EVENT_OBJECT_SELECTIONREMOVE = 32776;
    public static final int EVENT_OBJECT_SELECTIONWITHIN = 32777;
    public static final int EVENT_OBJECT_STATECHANGE = 32778;
    public static final int EVENT_OBJECT_LOCATIONCHANGE = 32779;
    public static final int EVENT_OBJECT_NAMECHANGE = 32780;
    public static final int EVENT_OBJECT_DESCRIPTIONCHANGE = 32781;
    public static final int EVENT_OBJECT_VALUECHANGE = 32782;
    public static final int EVENT_OBJECT_PARENTCHANGE = 32783;
    public static final int EVENT_OBJECT_HELPCHANGE = 32784;
    public static final int EVENT_OBJECT_DEFACTIONCHANGE = 32785;
    public static final int EVENT_OBJECT_ACCELERATORCHANGE = 32786;
    public static final int SELFLAG_NONE = 0;
    public static final int SELFLAG_TAKEFOCUS = 1;
    public static final int SELFLAG_TAKESELECTION = 2;
    public static final int SELFLAG_EXTENDSELECTION = 4;
    public static final int SELFLAG_ADDSELECTION = 8;
    public static final int SELFLAG_REMOVESELECTION = 16;
    private static final int SPI_GETSCREENREADER = 70;
    private static final int SPI_SETSCREENREADER = 71;
    private static final int SPIF_UPDATEINIFILE = 1;
    private static final int SPIF_SENDCHANGE = 2;
    private static final int HWND_BROADCAST = 65535;
    private static final int WM_WININICHANGE = 26;

    static {
        try {
            System.loadLibrary("AccessibilityJavaMsaaLibrary");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getAccessibleObjectFromPoint(Point point, int[] pChild) {
        NativeVariantAccess nva = new NativeVariantAccess();
        try {
            int pvObject = MSAA.AccessibleObjectFromPoint(point.x, point.y, nva.getAddress());
            if (3 == nva.getType()) {
                pChild[0] = nva.getInt();
            }
            int n = pvObject;
            return n;
        }
        finally {
            nva.dispose();
        }
    }

    public static int getAccessibleObjectFromEvent(int hwnd, int dwId, int dwChildId, int[] pChild) {
        NativeVariantAccess nva = new NativeVariantAccess();
        try {
            int pvObject = MSAA.AccessibleObjectFromEvent(hwnd, dwId, dwChildId, nva.getAddress());
            if (3 == nva.getType()) {
                pChild[0] = nva.getInt();
            }
            int n = pvObject;
            return n;
        }
        finally {
            nva.dispose();
        }
    }

    public static void getAccessibleChildren(int address, Variant[] pVarResult) {
        int resultLength = pVarResult.length;
        NativeVariantAccess nva = new NativeVariantAccess(resultLength);
        try {
            int count = MSAA.AccessibleChildren(address, 0, resultLength, nva.getAddress());
            int i = 0;
            while (i < count) {
                switch (nva.getType(i)) {
                    case 9: {
                        IDispatch childDispatch = nva.getDispatch(i);
                        childDispatch.AddRef();
                        pVarResult[i] = new Variant(childDispatch);
                        break;
                    }
                    case 3: {
                        pVarResult[i] = new Variant(nva.getInt(i));
                    }
                }
                ++i;
            }
        }
        finally {
            nva.dispose();
        }
    }

    public static int getWindowFromAccessibleObject(int address) {
        return MSAA.WindowFromAccessibleObject(address);
    }

    public static String getRoleText(int role) {
        int size = MSAA.GetRoleText(role, null, 0);
        if (size == 0) {
            return IA2.getRoleText(role);
        }
        TCHAR buffer = new TCHAR(0, size + 1);
        int result = MSAA.GetRoleText(role, buffer.chars, buffer.length());
        return buffer.toString(0, result);
    }

    public static String getStateText(int state) {
        int size = MSAA.GetStateText(state, null, 0);
        if (size == 0) {
            return "";
        }
        TCHAR buffer = new TCHAR(0, size + 1);
        int result = MSAA.GetStateText(state, buffer.chars, buffer.length());
        return buffer.toString(0, result);
    }

    public static final native int AccessibleObjectFromPoint(int var0, int var1, int var2);

    public static final native int AccessibleObjectFromWindow(int var0);

    public static final native int AccessibleChildren(int var0, int var1, int var2, int var3);

    public static final native int WindowFromAccessibleObject(int var0);

    public static final native int GetRoleText(int var0, char[] var1, int var2);

    public static final native int GetStateText(int var0, char[] var1, int var2);

    public static final native int AccessibleObjectFromEvent(int var0, int var1, int var2, int var3);

    public static final native int SetWinEventHook(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    public static final native int UnhookWinEvent(int var0);

    public static final native int HTMLDocumentFromWindow(int var0);

    public static void setScreenReader(boolean set) {
        if (OS.SystemParametersInfo((int)71, (int)(set ? 1 : 0), null, (int)3)) {
            OS.PostMessage((int)65535, (int)26, (int)71, (int)0);
        }
    }

    public static boolean getScreenReader() {
        int[] pResult = new int[1];
        if (OS.SystemParametersInfo((int)70, (int)0, (int[])pResult, (int)0)) {
            return pResult[0] != 0;
        }
        return false;
    }

    public static String getEventTypeText(int event) {
        switch (event) {
            case 1: {
                return "EVENT_SYSTEM_SOUND";
            }
            case 2: {
                return "EVENT_SYSTEM_ALERT";
            }
            case 3: {
                return "EVENT_SYSTEM_FOREGROUND";
            }
            case 8: {
                return "EVENT_SYSTEM_CAPTURESTART";
            }
            case 9: {
                return "EVENT_SYSTEM_CAPTUREEND";
            }
            case 10: {
                return "EVENT_SYSTEM_MOVESIZESTART";
            }
            case 11: {
                return "EVENT_SYSTEM_MOVESIZEEND";
            }
            case 12: {
                return "EVENT_SYSTEM_CONTEXTHELPSTART";
            }
            case 13: {
                return "EVENT_SYSTEM_CONTEXTHELPEND";
            }
            case 14: {
                return "EVENT_SYSTEM_DRAGDROPSTART";
            }
            case 15: {
                return "EVENT_SYSTEM_DRAGDROPEND";
            }
            case 16: {
                return "EVENT_SYSTEM_DIALOGSTART";
            }
            case 17: {
                return "EVENT_SYSTEM_DIALOGEND";
            }
            case 18: {
                return "EVENT_SYSTEM_SCROLLINGSTART";
            }
            case 19: {
                return "EVENT_SYSTEM_SCROLLINGEND";
            }
            case 20: {
                return "EVENT_SYSTEM_SWITCHSTART";
            }
            case 21: {
                return "EVENT_SYSTEM_SWITCHEND";
            }
            case 22: {
                return "EVENT_SYSTEM_MINIMIZESTART";
            }
            case 23: {
                return "EVENT_SYSTEM_MINIMIZEEND";
            }
            case 4: {
                return "EVENT_SYSTEM_MENUSTART";
            }
            case 6: {
                return "EVENT_SYSTEM_MENUPOPUPSTART";
            }
            case 5: {
                return "EVENT_SYSTEM_MENUEND";
            }
            case 7: {
                return "EVENT_SYSTEM_MENUPOPUPEND";
            }
            case 32773: {
                return "EVENT_OBJECT_FOCUS";
            }
            case 32778: {
                return "EVENT_OBJECT_STATECHANGE";
            }
            case 32780: {
                return "EVENT_OBJECT_NAMECHANGE";
            }
            case 32781: {
                return "EVENT_OBJECT_DESCRIPTIONCHANGE";
            }
            case 32782: {
                return "EVENT_OBJECT_VALUECHANGE";
            }
            case 32768: {
                return "EVENT_OBJECT_CREATE";
            }
            case 32769: {
                return "EVENT_OBJECT_DESTROY";
            }
            case 32770: {
                return "EVENT_OBJECT_SHOW";
            }
            case 32771: {
                return "EVENT_OBJECT_HIDE";
            }
            case 32772: {
                return "EVENT_OBJECT_REORDER";
            }
            case 32774: {
                return "EVENT_OBJECT_SELECTION";
            }
            case 32775: {
                return "EVENT_OBJECT_SELECTIONADD";
            }
            case 32776: {
                return "EVENT_OBJECT_SELECTIONREMOVE";
            }
            case 32777: {
                return "EVENT_OBJECT_SELECTIONWITHIN";
            }
            case 32779: {
                return "EVENT_OBJECT_LOCATIONCHANGE";
            }
            case 32783: {
                return "EVENT_OBJECT_PARENTCHANGE";
            }
            case 32784: {
                return "EVENT_OBJECT_HELPCHANGE";
            }
            case 32785: {
                return "EVENT_OBJECT_DEFACTIONCHANGE";
            }
            case 32786: {
                return "EVENT_OBJECT_ACCELERATORCHANGE";
            }
            case 257: {
                return "IA2_EVENT_ACTION_CHANGED";
            }
            case 258: {
                return "IA2_EVENT_ACTIVE_DECENDENT_CHANGED";
            }
            case 259: {
                return "IA2_EVENT_DOCUMENT_ATTRIBUTE_CHANGED";
            }
            case 260: {
                return "IA2_EVENT_DOCUMENT_CONTENT_CHANGED";
            }
            case 261: {
                return "IA2_EVENT_DOCUMENT_LOAD_COMPLETE";
            }
            case 262: {
                return "IA2_EVENT_DOCUMENT_LOAD_STOPPED";
            }
            case 263: {
                return "IA2_EVENT_DOCUMENT_RELOAD";
            }
            case 264: {
                return "IA2_EVENT_HYPERLINK_END_INDEX_CHANGED";
            }
            case 265: {
                return "IA2_EVENT_HYPERLINK_NUMBER_OF_ANCHORS_CHANGED";
            }
            case 266: {
                return "IA2_EVENT_HYPERLINK_SELECTED_LINK_CHANGED";
            }
            case 267: {
                return "IA2_EVENT_HYPERTEXT_LINK_ACTIVATED";
            }
            case 268: {
                return "IA2_EVENT_HYPERTEXT_LINK_SELECTED";
            }
            case 269: {
                return "IA2_EVENT_HYPERLINK_START_INDEX_CHANGED";
            }
            case 270: {
                return "IA2_EVENT_HYPERTEXT_CHANGED";
            }
            case 271: {
                return "IA2_EVENT_HYPERTEXT_NLINKS_CHANGED";
            }
            case 272: {
                return "IA2_EVENT_OBJECT_ATTRIBUTE_CHANGED";
            }
            case 273: {
                return "IA2_EVENT_PAGE_CHANGED";
            }
            case 274: {
                return "IA2_EVENT_SECTION_CHANGED";
            }
            case 275: {
                return "IA2_EVENT_TABLE_CAPTION_CHANGED";
            }
            case 276: {
                return "IA2_EVENT_TABLE_COLUMN_DESCRIPTION_CHANGED";
            }
            case 277: {
                return "IA2_EVENT_TABLE_COLUMN_HEADER_CHANGED";
            }
            case 278: {
                return "IA2_EVENT_TABLE_MODEL_CHANGED";
            }
            case 279: {
                return "IA2_EVENT_TABLE_ROW_DESCRIPTION_CHANGED";
            }
            case 280: {
                return "IA2_EVENT_TABLE_ROW_HEADER_CHANGED";
            }
            case 281: {
                return "IA2_EVENT_TABLE_SUMMARY_CHANGED";
            }
            case 282: {
                return "IA2_EVENT_TEXT_ATTRIBUTE_CHANGED";
            }
            case 283: {
                return "IA2_EVENT_TEXT_CARET_MOVED";
            }
            case 284: {
                return "IA2_EVENT_TEXT_CHANGED";
            }
            case 285: {
                return "IA2_EVENT_TEXT_COLUMN_CHANGED";
            }
            case 286: {
                return "IA2_EVENT_TEXT_INSERTED";
            }
            case 287: {
                return "IA2_EVENT_TEXT_REMOVED";
            }
            case 288: {
                return "IA2_EVENT_TEXT_UPDATED";
            }
            case 289: {
                return "IA2_EVENT_TEXT_SELECTION_CHANGED";
            }
            case 290: {
                return "IA2_EVENT_VISIBLE_DATA_CHANGED";
            }
        }
        return null;
    }
}

