/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.ui.report.srcviewer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import org.eclipse.actf.util.JapaneseEncodingDetector;
import org.eclipse.actf.visualization.internal.ui.report.Messages;
import org.eclipse.actf.visualization.internal.ui.report.srcviewer.DialogTextSearch;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SrcViewer {
    private Composite parentCom;
    private Display display;
    private StyledText styledText;
    private StyledText lineText;
    private Text lineNo;
    private Text columnNo;
    int start;
    int end;
    Color hlFg;
    Color hlBg;
    Vector<Integer> startV;
    Vector<Integer> lenV;
    Vector<Color> fgV;
    Vector<Color> bgV;
    private static Shell searchDlgShell;
    private String highLightedText = "";
    private boolean highlighted = false;
    private Button copyButton;

    public SrcViewer(Composite parent) {
        this.parentCom = parent;
        this.display = parent.getDisplay();
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        Composite composite2 = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(32);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText(Messages.SrcViewer_3);
        gridData = new GridData();
        gridData.horizontalIndent = 5;
        label.setLayoutData((Object)gridData);
        this.lineNo = new Text(composite2, 133120);
        gridData = new GridData();
        gridData.widthHint = 70;
        this.lineNo.setLayoutData((Object)gridData);
        this.lineNo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent arg0) {
                if (arg0.stateMask == 262144 && (arg0.keyCode == 102 || arg0.keyCode == 70)) {
                    SrcViewer.this.openSearchDialog();
                }
            }

            public void keyReleased(KeyEvent arg0) {
                if (arg0.stateMask != 0) {
                    return;
                }
                try {
                    SrcViewer.this.clearHighlight(false);
                    int line = Integer.parseInt(SrcViewer.this.lineNo.getText());
                    int lineCnt = SrcViewer.this.styledText.getLineCount();
                    if (line < 1) {
                        line = 1;
                        SrcViewer.this.lineNo.setText(String.valueOf(line));
                    } else if (line > lineCnt) {
                        line = lineCnt;
                        SrcViewer.this.lineNo.setText(String.valueOf(line));
                    }
                    SrcViewer.this.columnNo.setText("0");
                    SrcViewer.this.highlight(line, 0, line + 1, 0, false);
                }
                catch (NumberFormatException numberFormatException) {
                    SrcViewer.this.lineNo.setText("");
                }
            }
        });
        label = new Label(composite2, 0);
        label.setText(Messages.SrcViewer_6);
        gridData = new GridData();
        gridData.horizontalIndent = 10;
        label.setLayoutData((Object)gridData);
        this.columnNo = new Text(composite2, 133120);
        gridData = new GridData();
        gridData.widthHint = 70;
        this.columnNo.setLayoutData((Object)gridData);
        this.columnNo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent arg0) {
                if (arg0.stateMask == 262144 && (arg0.keyCode == 102 || arg0.keyCode == 70)) {
                    SrcViewer.this.openSearchDialog();
                }
            }

            public void keyReleased(KeyEvent arg0) {
                if (arg0.stateMask != 0) {
                    return;
                }
                try {
                    SrcViewer.this.clearHighlight(false);
                    int line = Integer.parseInt(SrcViewer.this.lineNo.getText());
                    int colCnt = line < SrcViewer.this.styledText.getLineCount() ? SrcViewer.this.styledText.getOffsetAtLine(line) - SrcViewer.this.styledText.getOffsetAtLine(line - 1) - 1 : SrcViewer.this.styledText.getCharCount() - SrcViewer.this.styledText.getOffsetAtLine(line - 1);
                    int column = Integer.parseInt(SrcViewer.this.columnNo.getText());
                    if (column < 0) {
                        column = 0;
                        SrcViewer.this.columnNo.setText(String.valueOf(column));
                    } else if (column >= colCnt) {
                        column = colCnt;
                        SrcViewer.this.columnNo.setText(String.valueOf(column));
                    }
                    SrcViewer.this.highlight(line, column, line + 1, 0, false);
                }
                catch (NumberFormatException numberFormatException) {
                    SrcViewer.this.columnNo.setText("");
                }
            }
        });
        Button searchButton = new Button(composite2, 8);
        searchButton.setText(Messages.SrcViewer_8);
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        searchButton.setLayoutData((Object)gridData);
        searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SrcViewer.this.openSearchDialog();
            }
        });
        this.copyButton = new Button(composite2, 8);
        this.copyButton.setText(Messages.SrcViewer_9);
        gridData = new GridData();
        gridData.horizontalIndent = 10;
        this.copyButton.setLayoutData((Object)gridData);
        this.copyButton.setEnabled(false);
        this.copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SrcViewer.this.copyToClipBoard();
            }
        });
        Composite composite3 = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        composite3.setLayoutData((Object)gridData);
        this.lineText = new StyledText(composite3, 0);
        gridData = new GridData(16);
        gridData.widthHint = 32;
        gridData.grabExcessVerticalSpace = true;
        this.lineText.setLayoutData((Object)gridData);
        this.lineText.setEditable(false);
        this.styledText = new StyledText(composite3, 2816);
        gridData = new GridData(1808);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.styledText.setLayoutData((Object)gridData);
        this.styledText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SrcViewer.this.getSelectionLineCol();
                SrcViewer.this.setCopyButton();
            }
        });
        this.styledText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent arg0) {
                SrcViewer.this.getSelectionLineCol();
            }
        });
        this.styledText.setKeyBinding(0x43 | SWT.MOD1, 0);
        this.styledText.setKeyBinding(0x58 | SWT.MOD1, 0);
        this.styledText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent arg0) {
                if (arg0.keyCode == 0x1000006 || arg0.keyCode == 0x1000005 || arg0.keyCode == 0x1000007 || arg0.keyCode == 0x1000008 || arg0.keyCode == 0x1000002 || arg0.keyCode == 0x1000001 || arg0.keyCode == 0x1000003 || arg0.keyCode == 0x1000004) {
                    SrcViewer.this.getSelectionLineCol();
                    SrcViewer.this.setLineText();
                } else if (arg0.stateMask == 262144) {
                    if (arg0.keyCode == 102 || arg0.keyCode == 70) {
                        SrcViewer.this.openSearchDialog();
                    } else if (arg0.keyCode == 99 || arg0.keyCode == 67) {
                        SrcViewer.this.copyToClipBoard();
                    }
                }
            }
        });
        this.styledText.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SrcViewer.this.setLineText();
            }
        });
        this.parentCom.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent arg0) {
                if (arg0.stateMask == 262144) {
                    if (arg0.keyCode == 102 || arg0.keyCode == 70) {
                        SrcViewer.this.openSearchDialog();
                    } else if (arg0.keyCode == 99 || arg0.keyCode == 67) {
                        SrcViewer.this.copyToClipBoard();
                    }
                }
            }
        });
        this.hlFg = this.styledText.getSelectionForeground();
        this.hlBg = this.styledText.getSelectionBackground();
        this.startV = new Vector();
        this.lenV = new Vector();
        this.fgV = new Vector();
        this.bgV = new Vector();
    }

    private void setCopyButton() {
        String selText = this.styledText.getSelectionText();
        if (selText.equals("") && this.highLightedText.equals("") || !selText.equals("") && this.highlighted) {
            this.copyButton.setEnabled(false);
        } else {
            this.copyButton.setEnabled(true);
        }
    }

    private void copyToClipBoard() {
        if (!this.copyButton.getEnabled()) {
            return;
        }
        String strText = !this.highLightedText.equals("") ? this.highLightedText : this.styledText.getSelectionText();
        Clipboard clipboard = new Clipboard(this.display);
        clipboard.setContents(new Object[]{strText}, new Transfer[]{TextTransfer.getInstance()});
    }

    private void openSearchDialog() {
        if (searchDlgShell == null || searchDlgShell.isDisposed()) {
            searchDlgShell = new Shell(this.parentCom.getShell(), 34912);
            searchDlgShell.setSize(600, 170);
            searchDlgShell.setLayout((Layout)new FillLayout());
            new DialogTextSearch(searchDlgShell, this);
            searchDlgShell.open();
        } else {
            searchDlgShell.forceActive();
        }
    }

    private void setLineText() {
        StringBuffer strBuf = new StringBuffer();
        int len = this.lineText.getBounds().height / this.styledText.getLineHeight();
        int top = this.styledText.getTopIndex();
        int i = 0;
        while (i < len) {
            strBuf.append(String.valueOf(String.valueOf(top + i + 1)) + "\r\n");
            ++i;
        }
        this.lineText.setText(strBuf.toString());
        this.styledText.setTopIndex(top);
    }

    public void setHighlightColor(Color hlFg, Color hlBg) {
        this.hlFg = hlFg;
        this.hlBg = hlBg;
    }

    public void getSelectionLineCol() {
        int pos = this.styledText.getSelectionRange().x;
        int line = this.styledText.getLineAtOffset(pos) + 1;
        this.lineNo.setText(new Integer(line).toString());
        this.columnNo.setText(new Integer(pos - this.styledText.getOffsetAtLine(line - 1)).toString());
    }

    public void openFile(File target) {
        this.styledText.setText("");
        try {
            String encoding = "MS932";
            JapaneseEncodingDetector JED = null;
            InputStreamReader isr = null;
            FileInputStream is = new FileInputStream(target);
            try {
                JED = new JapaneseEncodingDetector((InputStream)is);
                encoding = JED.detect();
                isr = new InputStreamReader(JED.getInputStream(), encoding);
            }
            catch (Exception exception) {}
            BufferedReader br = null;
            br = isr != null ? new BufferedReader(isr) : new BufferedReader(new FileReader(target));
            String line = new String();
            try {
                while ((line = br.readLine()) != null) {
                    this.styledText.append(String.valueOf(line) + "\n");
                }
            }
            catch (Exception exception) {
                try {
                    isr = new InputStreamReader(JED.getInputStream(), "MS932");
                    this.styledText.setText("");
                    br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        this.styledText.append(String.valueOf(line) + "\n");
                    }
                }
                catch (Exception exception2) {
                    this.styledText.setText(String.valueOf(Messages.SrcViewer_0) + target.getName());
                }
            }
            ((InputStream)is).close();
            br.close();
            isr.close();
        }
        catch (Exception exception) {}
        this.setLineText();
        this.initializeColor();
    }

    public void setText(String target) {
        this.styledText.setText(target);
        this.setLineText();
        this.initializeColor();
    }

    private void initializeColor() {
        this.startV.clear();
        this.lenV.clear();
        this.fgV.clear();
        this.bgV.clear();
        this.lineNo.setText("");
        this.columnNo.setText("");
    }

    public void selectByOffset(int start, int len) {
        this.clearHighlight();
        this.styledText.setSelection(start, start + len);
        this.getSelectionLineCol();
        this.setLineText();
    }

    private void setStyleByOffset(int start, int len, Color fgcolor, Color bgcolor) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = start;
        styleRange.length = len;
        styleRange.foreground = fgcolor;
        styleRange.background = bgcolor;
        this.styledText.setStyleRange(styleRange);
    }

    public void clearColor() {
        this.styledText.setStyleRange(null);
        this.initializeColor();
    }

    public void setColor(int startLine, int startPos, int endLine, int endPos, Color fgcolor, Color bgcolor) {
        this.calculateStartEnd(startLine, startPos, endLine, endPos);
        this.setStyleByOffset(this.start, this.end - this.start, fgcolor, bgcolor);
        this.startV.add(new Integer(this.start));
        this.lenV.add(new Integer(this.end - this.start));
        this.fgV.add(fgcolor);
        this.bgV.add(bgcolor);
    }

    public void clearHighlight() {
        this.clearHighlight(true);
        this.highlighted = false;
        this.highLightedText = "";
        this.setCopyButton();
    }

    private void clearHighlight(boolean bUpdate) {
        this.styledText.setStyleRange(null);
        int i = 0;
        while (i < this.startV.size()) {
            StyleRange styleRange = new StyleRange();
            styleRange.start = this.startV.get(i);
            styleRange.length = this.lenV.get(i);
            styleRange.foreground = this.fgV.get(i);
            styleRange.background = this.bgV.get(i);
            this.styledText.setStyleRange(styleRange);
            ++i;
        }
        if (bUpdate) {
            this.lineNo.setText("");
            this.columnNo.setText("");
        }
    }

    public void highlight(int startLine, int startPos, int endLine, int endPos) {
        this.highlight(startLine, startPos, endLine, endPos, true);
    }

    private void highlight(int startLine, int startPos, int endLine, int endPos, boolean bUpdate) {
        this.calculateStartEnd(startLine, startPos, endLine, endPos);
        this.styledText.setSelection(this.styledText.getText().length());
        this.styledText.setSelection(this.start);
        this.setLineText();
        this.setStyleByOffset(this.start, this.end - this.start, this.hlFg, this.hlBg);
        if (this.end > this.start) {
            if (this.highlighted) {
                this.highLightedText = "";
            } else {
                this.highLightedText = this.styledText.getText(this.start, this.end);
                this.highlighted = true;
            }
            this.setCopyButton();
        }
        if (bUpdate) {
            this.lineNo.setText(new Integer(startLine).toString());
            this.columnNo.setText(new Integer(startPos).toString());
        }
    }

    public void highlightLine(int line) {
        this.highlightLines(line, line);
    }

    public void highlightLines(int start, int end) {
        this.highlight(start, 0, end + 1, 0);
    }

    private void calculateStartEnd(int startLine, int startPos, int endLine, int endPos) {
        if (startPos < 0) {
            startPos = 0;
        }
        if (endPos < 0) {
            endPos = 0;
        }
        try {
            this.start = this.styledText.getOffsetAtLine(startLine - 1) + startPos;
        }
        catch (Exception exception) {
            this.start = this.styledText.getCharCount();
        }
        try {
            this.end = this.styledText.getOffsetAtLine(endLine - 1) + endPos;
        }
        catch (Exception exception) {
            this.end = this.styledText.getCharCount();
        }
        if (this.start > this.end) {
            this.start = this.end;
        }
    }

    public StyledText getStyledText() {
        return this.styledText;
    }

    public void closeSearchDlgShell() {
        if (searchDlgShell != null && !searchDlgShell.isDisposed()) {
            searchDlgShell.dispose();
        }
    }
}

