/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.mediator;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.actf.mediator.IACTFReport;
import org.eclipse.actf.mediator.IACTFReportGenerator;
import org.eclipse.actf.mediator.IACTFReportViewer;
import org.eclipse.actf.mediator.IMediatorEventListener;
import org.eclipse.actf.mediator.MediatorEvent;
import org.eclipse.actf.model.ui.IModelServiceHolder;
import org.eclipse.actf.ui.util.AbstractPartListener;
import org.eclipse.actf.ui.util.PlatformUIUtil;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;

public class Mediator {
    private static Mediator instance = new Mediator();
    private IACTFReportGenerator curRepoter;
    private IModelServiceHolder currentModelServiceHolder;
    private HashMap<IACTFReportGenerator, IACTFReport> reportMap = new HashMap();
    private HashSet<IWorkbenchPage> pageSet = new HashSet();
    private Set<IMediatorEventListener> mediatorEventLisnterSet = Collections.synchronizedSet(new HashSet());

    public static Mediator getInstance() {
        return instance;
    }

    private Mediator() {
        this.init();
    }

    public void setReport(IACTFReportGenerator generator, IACTFReport report) {
        this.reportMap.put(generator, report);
        this.reportChanged(new MediatorEvent(this, this.currentModelServiceHolder, generator, report));
    }

    public IACTFReport getReport(IACTFReportGenerator generator) {
        return this.getEvaluationResult(null, generator);
    }

    private IACTFReport getEvaluationResult(IModelServiceHolder holder, IACTFReportGenerator reporter) {
        if (this.reportMap.containsKey(reporter)) {
            return this.reportMap.get(reporter);
        }
        return null;
    }

    private void initPage(IWorkbenchPage page) {
        if (this.pageSet.add(page)) {
            IViewReference[] views = page.getViewReferences();
            int i = 0;
            while (i < views.length) {
                IViewPart tmpViewPart = views[i].getView(false);
                if (tmpViewPart != null && tmpViewPart instanceof IMediatorEventListener) {
                    this.addMediatorEventListener((IMediatorEventListener)tmpViewPart);
                }
                ++i;
            }
            page.addPartListener((IPartListener2)new AbstractPartListener(){

                public void partActivated(IWorkbenchPartReference partRef) {
                    IWorkbenchPart part = partRef.getPart(false);
                    if (part instanceof IACTFReportGenerator && part != Mediator.this.curRepoter) {
                        Mediator.this.curRepoter = (IACTFReportGenerator)part;
                        Mediator.this.reporterViewChanged(new MediatorEvent(Mediator.this, Mediator.this.currentModelServiceHolder, Mediator.this.curRepoter, Mediator.this.getReport(Mediator.this.curRepoter)));
                    }
                    if (part instanceof IModelServiceHolder && part != Mediator.this.currentModelServiceHolder) {
                        Mediator.this.currentModelServiceHolder = (IModelServiceHolder)part;
                        Mediator.this.modelserviceChanged(new MediatorEvent(Mediator.this, Mediator.this.currentModelServiceHolder, Mediator.this.curRepoter, Mediator.this.getReport(Mediator.this.curRepoter)));
                    }
                }

                public void partClosed(IWorkbenchPartReference partRef) {
                    IWorkbenchPart part = partRef.getPart(false);
                    if (part instanceof IMediatorEventListener) {
                        Mediator.this.removeMediatorEventListener((IMediatorEventListener)part);
                    }
                }

                public void partOpened(IWorkbenchPartReference partRef) {
                    IWorkbenchPart part = partRef.getPart(false);
                    if (part instanceof IACTFReportViewer) {
                        IACTFReportViewer viewer = (IACTFReportViewer)part;
                        if (Mediator.this.currentModelServiceHolder != null) {
                            viewer.reportChanged(new MediatorEvent(Mediator.this, Mediator.this.currentModelServiceHolder, Mediator.this.curRepoter, Mediator.this.getReport(Mediator.this.curRepoter)));
                        }
                        Mediator.this.addMediatorEventListener(viewer);
                    } else if (part instanceof IMediatorEventListener) {
                        Mediator.this.addMediatorEventListener((IMediatorEventListener)part);
                    }
                }

                public void partInputChanged(IWorkbenchPartReference partRef) {
                    IWorkbenchPart part = partRef.getPart(false);
                    if (part instanceof IModelServiceHolder) {
                        Mediator.this.currentModelServiceHolder = (IModelServiceHolder)part;
                        Mediator.this.modelserviceInputChanged(new MediatorEvent(Mediator.this, Mediator.this.currentModelServiceHolder, Mediator.this.curRepoter, Mediator.this.getReport(Mediator.this.curRepoter)));
                    }
                }
            });
        }
    }

    private void init() {
        IWorkbenchWindow activeWindow = PlatformUIUtil.getActiveWindow();
        activeWindow.addPageListener(new IPageListener(){

            public void pageActivated(IWorkbenchPage page) {
            }

            public void pageClosed(IWorkbenchPage page) {
                Mediator.this.pageSet.remove(page);
            }

            public void pageOpened(IWorkbenchPage page) {
                Mediator.this.initPage(page);
            }
        });
        IWorkbenchPage activePage = PlatformUIUtil.getActivePage();
        if (activePage != null) {
            this.initPage(activePage);
        }
    }

    public synchronized void addMediatorEventListener(IMediatorEventListener listener) {
        this.mediatorEventLisnterSet.add(listener);
    }

    public synchronized boolean removeMediatorEventListener(IMediatorEventListener listener) {
        return this.mediatorEventLisnterSet.remove(listener);
    }

    private synchronized void modelserviceChanged(MediatorEvent event) {
        IMediatorEventListener[] iMediatorEventListenerArray = this.mediatorEventLisnterSet.toArray(new IMediatorEventListener[this.mediatorEventLisnterSet.size()]);
        int n = iMediatorEventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMediatorEventListener i = iMediatorEventListenerArray[n2];
            i.modelserviceChanged(event);
            ++n2;
        }
    }

    private synchronized void modelserviceInputChanged(MediatorEvent event) {
        IMediatorEventListener[] iMediatorEventListenerArray = this.mediatorEventLisnterSet.toArray(new IMediatorEventListener[this.mediatorEventLisnterSet.size()]);
        int n = iMediatorEventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMediatorEventListener i = iMediatorEventListenerArray[n2];
            i.modelserviceInputChanged(event);
            ++n2;
        }
    }

    private synchronized void reportChanged(MediatorEvent event) {
        IMediatorEventListener[] iMediatorEventListenerArray = this.mediatorEventLisnterSet.toArray(new IMediatorEventListener[this.mediatorEventLisnterSet.size()]);
        int n = iMediatorEventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMediatorEventListener i = iMediatorEventListenerArray[n2];
            i.reportChanged(event);
            ++n2;
        }
    }

    private synchronized void reporterViewChanged(MediatorEvent event) {
        IMediatorEventListener[] iMediatorEventListenerArray = this.mediatorEventLisnterSet.toArray(new IMediatorEventListener[this.mediatorEventLisnterSet.size()]);
        int n = iMediatorEventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMediatorEventListener i = iMediatorEventListenerArray[n2];
            i.reportGeneratorChanged(event);
            ++n2;
        }
    }
}

