/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.visualization.engines.blind.eval.PageEvaluation;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.html.statistics.PageData;
import org.eclipse.actf.visualization.internal.engines.blind.Messages;

public class SummaryEvaluation {
    private static final String SPACE = " ";
    private PageEvaluation pe;
    private PageData pageData;
    private int noImageAltCount;
    private int wrongImageAltCount;
    private int redundantImageAltCount = 0;
    private GuidelineHolder guidelineHolder = GuidelineHolder.getInstance();
    private boolean hasError;

    public SummaryEvaluation(PageEvaluation pe, PageData pd, boolean hasError) {
        this.pe = pe;
        this.pageData = pd;
        this.hasError = hasError;
    }

    public String getOverview() {
        StringBuffer tmpSB = new StringBuffer(512);
        StringBuffer noGoodMetrics = new StringBuffer();
        boolean hasComp = false;
        boolean hasOperable = false;
        boolean hasOther = false;
        String[] metrics = this.pe.getMetrics();
        String[] lMetrics = this.pe.getLocalizedMetrics();
        int[] scores = this.pe.getScores();
        int compTotal = 0;
        int compCount = 0;
        int operable = 100;
        int other = 100;
        int i = 0;
        while (i < metrics.length) {
            int score = scores[i];
            if ((metrics[i].equalsIgnoreCase("perceivable") || metrics[i].equalsIgnoreCase("understandable") || metrics[i].equalsIgnoreCase("robust")) && this.guidelineHolder.isMatchedMetric(metrics[i])) {
                compTotal += score;
                ++compCount;
                hasComp = true;
                if (score != 100) {
                    noGoodMetrics.append(String.valueOf(lMetrics[i]) + ",");
                }
            } else if (metrics[i].equalsIgnoreCase("operable") && this.guidelineHolder.isMatchedMetric(metrics[i])) {
                operable = score;
                compTotal += score;
                ++compCount;
                hasOperable = true;
            } else {
                hasOther = true;
                if (other > score) {
                    other = score;
                }
                if (score != 100) {
                    noGoodMetrics.append(String.valueOf(lMetrics[i]) + ",");
                }
            }
            ++i;
        }
        this.noImageAltCount = this.pageData.getMissingAltNum();
        this.wrongImageAltCount = this.pageData.getWrongAltNum();
        int totalAltError = this.noImageAltCount + this.wrongImageAltCount;
        StringBuffer aboutComp = new StringBuffer();
        StringBuffer aboutNav = new StringBuffer();
        boolean isGood = false;
        if (compCount == 0) {
            return "";
        }
        if (compTotal / compCount >= 75) {
            if (this.hasError) {
                aboutComp.append(String.valueOf(Messages.Eval_compliant_with_some_other_errors) + FileUtils.LINE_SEP);
                if (totalAltError > 0) {
                    aboutComp.append(String.valueOf(Messages.Eval_confirm_alt_attributes_first) + FileUtils.LINE_SEP);
                    aboutComp.append(this.getImageAltStatistics());
                } else {
                    aboutComp.append(Messages.Eval_confirm_errors_detailed_report);
                }
            } else if (hasOther && other != 100) {
                aboutComp.append(String.valueOf(Messages.Eval_some_errors_on_metrics) + FileUtils.LINE_SEP + MessageFormat.format((String)Messages.Eval_some_errors_on_metrics1, (Object[])new String[]{noGoodMetrics.substring(0, noGoodMetrics.length() - 1)}));
            } else if (compTotal / compCount == 100) {
                isGood = true;
                aboutComp.append(String.valueOf(Messages.Eval_completely_compliant) + FileUtils.LINE_SEP + Messages.Eval_user_check2);
            } else {
                isGood = true;
                aboutComp.append(String.valueOf(Messages.Eval_completely_compliant_with_user_check_items) + FileUtils.LINE_SEP + Messages.Eval_user_check1);
            }
        } else {
            if (compTotal / compCount >= 50) {
                aboutComp.append(String.valueOf(Messages.Eval_some_accessibility_issues) + FileUtils.LINE_SEP);
            } else {
                aboutComp.append(String.valueOf(Messages.Eval_many_accessibility_issues) + FileUtils.LINE_SEP);
            }
            if (totalAltError > 0) {
                aboutComp.append(String.valueOf(Messages.Eval_confirm_alt_attributes_first) + FileUtils.LINE_SEP);
                aboutComp.append(this.getImageAltStatistics());
            } else {
                aboutComp.append(Messages.Eval_confirm_errors_detailed_report);
            }
        }
        if (hasOperable && this.guidelineHolder.isEnabledMetric("operable")) {
            if (operable >= 75) {
                if (this.pageData.getMaxTime() > 240) {
                    aboutNav.append(String.valueOf(MessageFormat.format((String)Messages.Eval_navigability_long_time_error_msg, (Object[])new String[]{FileUtils.LINE_SEP, FileUtils.LINE_SEP, FileUtils.LINE_SEP, FileUtils.LINE_SEP})) + FileUtils.LINE_SEP);
                } else {
                    aboutNav.append(String.valueOf(MessageFormat.format((String)Messages.Eval_navigability_good_msg, (Object[])new String[]{FileUtils.LINE_SEP, FileUtils.LINE_SEP})) + FileUtils.LINE_SEP);
                }
            } else {
                isGood = false;
                aboutNav.append(String.valueOf(MessageFormat.format((String)Messages.Eval_navigability_low_score_error_msg, (Object[])new String[]{FileUtils.LINE_SEP, FileUtils.LINE_SEP, FileUtils.LINE_SEP, FileUtils.LINE_SEP})) + FileUtils.LINE_SEP);
            }
        }
        if ((hasComp || hasOperable) && isGood) {
            tmpSB.append(String.valueOf(Messages.Eval_excellent) + FileUtils.LINE_SEP + FileUtils.LINE_SEP);
        }
        tmpSB.append(aboutComp + FileUtils.LINE_SEP + FileUtils.LINE_SEP);
        tmpSB.append(aboutNav);
        return tmpSB.toString();
    }

    private String getImageAltStatistics() {
        StringBuffer tmpSB = new StringBuffer(FileUtils.LINE_SEP);
        if (this.noImageAltCount > 0) {
            tmpSB.append(" -" + Messages.Eval_no_img_alt_error_msg + FileUtils.LINE_SEP);
        }
        if (this.wrongImageAltCount > 0) {
            tmpSB.append(" -" + Messages.Eval_wrong_img_alt_error_msg + FileUtils.LINE_SEP);
        }
        if (this.redundantImageAltCount > 0) {
            tmpSB.append(" -" + Messages.Eval_redundant_img_alt_error_msg + FileUtils.LINE_SEP);
        }
        tmpSB.append(FileUtils.LINE_SEP);
        if (this.noImageAltCount > 0) {
            tmpSB.append(SPACE + Messages.Eval_no_img_alt + SPACE + this.noImageAltCount + FileUtils.LINE_SEP);
        }
        if (this.wrongImageAltCount > 0) {
            tmpSB.append(SPACE + Messages.Eval_wrong_img_alt + SPACE + this.wrongImageAltCount + FileUtils.LINE_SEP);
        }
        if (this.redundantImageAltCount > 0) {
            tmpSB.append(SPACE + Messages.Eval_redundant_img_alt + SPACE + this.redundantImageAltCount + FileUtils.LINE_SEP);
        }
        return tmpSB.toString();
    }
}

